/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hudi.org.apache.http.client.methods;

import io.hops.hudi.org.apache.http.ProtocolVersion;
import io.hops.hudi.org.apache.http.RequestLine;
import io.hops.hudi.org.apache.http.annotation.NotThreadSafe;
import io.hops.hudi.org.apache.http.client.config.RequestConfig;
import io.hops.hudi.org.apache.http.client.methods.AbstractExecutionAwareRequest;
import io.hops.hudi.org.apache.http.client.methods.Configurable;
import io.hops.hudi.org.apache.http.client.methods.HttpUriRequest;
import io.hops.hudi.org.apache.http.message.BasicRequestLine;
import io.hops.hudi.org.apache.http.params.HttpProtocolParams;
import java.net.URI;

@NotThreadSafe
public abstract class HttpRequestBase
extends AbstractExecutionAwareRequest
implements HttpUriRequest,
Configurable {
    private ProtocolVersion version;
    private URI uri;
    private RequestConfig config;

    @Override
    public abstract String getMethod();

    public void setProtocolVersion(ProtocolVersion version) {
        this.version = version;
    }

    @Override
    public ProtocolVersion getProtocolVersion() {
        return this.version != null ? this.version : HttpProtocolParams.getVersion(this.getParams());
    }

    @Override
    public URI getURI() {
        return this.uri;
    }

    @Override
    public RequestLine getRequestLine() {
        String method = this.getMethod();
        ProtocolVersion ver = this.getProtocolVersion();
        URI uriCopy = this.getURI();
        String uritext = null;
        if (uriCopy != null) {
            uritext = uriCopy.toASCIIString();
        }
        if (uritext == null || uritext.isEmpty()) {
            uritext = "/";
        }
        return new BasicRequestLine(method, uritext, ver);
    }

    @Override
    public RequestConfig getConfig() {
        return this.config;
    }

    public void setConfig(RequestConfig config) {
        this.config = config;
    }

    public void setURI(URI uri2) {
        this.uri = uri2;
    }

    public void started() {
    }

    public void releaseConnection() {
        this.reset();
    }

    public String toString() {
        return this.getMethod() + " " + this.getURI() + " " + this.getProtocolVersion();
    }
}

