/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hudi.org.apache.http.client.utils;

import io.hops.hudi.org.apache.http.HttpHost;
import io.hops.hudi.org.apache.http.annotation.Immutable;
import io.hops.hudi.org.apache.http.client.utils.URIBuilder;
import io.hops.hudi.org.apache.http.conn.routing.RouteInfo;
import io.hops.hudi.org.apache.http.util.Args;
import io.hops.hudi.org.apache.http.util.TextUtils;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import java.util.Locale;
import java.util.Stack;

@Immutable
public class URIUtils {
    @Deprecated
    public static URI createURI(String scheme2, String host2, int port, String path, String query, String fragment) throws URISyntaxException {
        StringBuilder buffer = new StringBuilder();
        if (host2 != null) {
            if (scheme2 != null) {
                buffer.append(scheme2);
                buffer.append("://");
            }
            buffer.append(host2);
            if (port > 0) {
                buffer.append(':');
                buffer.append(port);
            }
        }
        if (path == null || !path.startsWith("/")) {
            buffer.append('/');
        }
        if (path != null) {
            buffer.append(path);
        }
        if (query != null) {
            buffer.append('?');
            buffer.append(query);
        }
        if (fragment != null) {
            buffer.append('#');
            buffer.append(fragment);
        }
        return new URI(buffer.toString());
    }

    public static URI rewriteURI(URI uri2, HttpHost target, boolean dropFragment) throws URISyntaxException {
        Args.notNull(uri2, "URI");
        if (uri2.isOpaque()) {
            return uri2;
        }
        URIBuilder uribuilder = new URIBuilder(uri2);
        if (target != null) {
            uribuilder.setScheme(target.getSchemeName());
            uribuilder.setHost(target.getHostName());
            uribuilder.setPort(target.getPort());
        } else {
            uribuilder.setScheme(null);
            uribuilder.setHost(null);
            uribuilder.setPort(-1);
        }
        if (dropFragment) {
            uribuilder.setFragment(null);
        }
        if (TextUtils.isEmpty(uribuilder.getPath())) {
            uribuilder.setPath("/");
        }
        return uribuilder.build();
    }

    public static URI rewriteURI(URI uri2, HttpHost target) throws URISyntaxException {
        return URIUtils.rewriteURI(uri2, target, false);
    }

    public static URI rewriteURI(URI uri2) throws URISyntaxException {
        Args.notNull(uri2, "URI");
        if (uri2.isOpaque()) {
            return uri2;
        }
        URIBuilder uribuilder = new URIBuilder(uri2);
        if (uribuilder.getUserInfo() != null) {
            uribuilder.setUserInfo(null);
        }
        if (TextUtils.isEmpty(uribuilder.getPath())) {
            uribuilder.setPath("/");
        }
        if (uribuilder.getHost() != null) {
            uribuilder.setHost(uribuilder.getHost().toLowerCase(Locale.ROOT));
        }
        uribuilder.setFragment(null);
        return uribuilder.build();
    }

    public static URI rewriteURIForRoute(URI uri2, RouteInfo route) throws URISyntaxException {
        if (uri2 == null) {
            return null;
        }
        if (route.getProxyHost() != null && !route.isTunnelled()) {
            if (!uri2.isAbsolute()) {
                HttpHost target = route.getTargetHost();
                return URIUtils.rewriteURI(uri2, target, true);
            }
            return URIUtils.rewriteURI(uri2);
        }
        if (uri2.isAbsolute()) {
            return URIUtils.rewriteURI(uri2, null, true);
        }
        return URIUtils.rewriteURI(uri2);
    }

    public static URI resolve(URI baseURI, String reference) {
        return URIUtils.resolve(baseURI, URI.create(reference));
    }

    public static URI resolve(URI baseURI, URI reference) {
        Args.notNull(baseURI, "Base URI");
        Args.notNull(reference, "Reference URI");
        URI ref = reference;
        String s = ref.toString();
        if (s.startsWith("?")) {
            return URIUtils.resolveReferenceStartingWithQueryString(baseURI, ref);
        }
        boolean emptyReference = s.isEmpty();
        if (emptyReference) {
            ref = URI.create("#");
        }
        URI resolved = baseURI.resolve(ref);
        if (emptyReference) {
            String resolvedString = resolved.toString();
            resolved = URI.create(resolvedString.substring(0, resolvedString.indexOf(35)));
        }
        return URIUtils.normalizeSyntax(resolved);
    }

    private static URI resolveReferenceStartingWithQueryString(URI baseURI, URI reference) {
        String baseUri = baseURI.toString();
        baseUri = baseUri.indexOf(63) > -1 ? baseUri.substring(0, baseUri.indexOf(63)) : baseUri;
        return URI.create(baseUri + reference.toString());
    }

    private static URI normalizeSyntax(URI uri2) {
        if (uri2.isOpaque() || uri2.getAuthority() == null) {
            return uri2;
        }
        Args.check(uri2.isAbsolute(), "Base URI must be absolute");
        String path = uri2.getPath() == null ? "" : uri2.getPath();
        String[] inputSegments = path.split("/");
        Stack<String> outputSegments = new Stack<String>();
        for (String inputSegment : inputSegments) {
            if (inputSegment.isEmpty() || ".".equals(inputSegment)) continue;
            if ("..".equals(inputSegment)) {
                if (outputSegments.isEmpty()) continue;
                outputSegments.pop();
                continue;
            }
            outputSegments.push(inputSegment);
        }
        StringBuilder outputBuffer = new StringBuilder();
        for (String outputSegment : outputSegments) {
            outputBuffer.append('/').append(outputSegment);
        }
        if (path.lastIndexOf(47) == path.length() - 1) {
            outputBuffer.append('/');
        }
        try {
            String scheme2 = uri2.getScheme().toLowerCase(Locale.ROOT);
            String auth = uri2.getAuthority().toLowerCase(Locale.ROOT);
            URI ref = new URI(scheme2, auth, outputBuffer.toString(), null, null);
            if (uri2.getQuery() == null && uri2.getFragment() == null) {
                return ref;
            }
            StringBuilder normalized = new StringBuilder(ref.toASCIIString());
            if (uri2.getQuery() != null) {
                normalized.append('?').append(uri2.getRawQuery());
            }
            if (uri2.getFragment() != null) {
                normalized.append('#').append(uri2.getRawFragment());
            }
            return URI.create(normalized.toString());
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static HttpHost extractHost(URI uri2) {
        if (uri2 == null) {
            return null;
        }
        HttpHost target = null;
        if (uri2.isAbsolute()) {
            int port = uri2.getPort();
            String host2 = uri2.getHost();
            if (host2 == null && (host2 = uri2.getAuthority()) != null) {
                int colon;
                int at = host2.indexOf(64);
                if (at >= 0) {
                    host2 = host2.length() > at + 1 ? host2.substring(at + 1) : null;
                }
                if (host2 != null && (colon = host2.indexOf(58)) >= 0) {
                    int pos = colon + 1;
                    int len = 0;
                    for (int i = pos; i < host2.length() && Character.isDigit(host2.charAt(i)); ++i) {
                        ++len;
                    }
                    if (len > 0) {
                        try {
                            port = Integer.parseInt(host2.substring(pos, pos + len));
                        }
                        catch (NumberFormatException ex) {
                            // empty catch block
                        }
                    }
                    host2 = host2.substring(0, colon);
                }
            }
            String scheme2 = uri2.getScheme();
            if (!TextUtils.isBlank(host2)) {
                try {
                    target = new HttpHost(host2, port, scheme2);
                }
                catch (IllegalArgumentException ignore) {
                    // empty catch block
                }
            }
        }
        return target;
    }

    public static URI resolve(URI originalURI, HttpHost target, List<URI> redirects) throws URISyntaxException {
        URIBuilder uribuilder;
        Args.notNull(originalURI, "Request URI");
        if (redirects == null || redirects.isEmpty()) {
            uribuilder = new URIBuilder(originalURI);
        } else {
            uribuilder = new URIBuilder(redirects.get(redirects.size() - 1));
            String frag = uribuilder.getFragment();
            for (int i = redirects.size() - 1; frag == null && i >= 0; --i) {
                frag = redirects.get(i).getFragment();
            }
            uribuilder.setFragment(frag);
        }
        if (uribuilder.getFragment() == null) {
            uribuilder.setFragment(originalURI.getFragment());
        }
        if (target != null && !uribuilder.isAbsolute()) {
            uribuilder.setScheme(target.getSchemeName());
            uribuilder.setHost(target.getHostName());
            uribuilder.setPort(target.getPort());
        }
        return uribuilder.build();
    }

    private URIUtils() {
    }
}

