/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hudi.common.model.HoodieCommitMetadata;
import org.apache.hudi.common.util.JsonUtils;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

@JsonIgnoreProperties(ignoreUnknown=true)
public class HoodieReplaceCommitMetadata
extends HoodieCommitMetadata {
    private static final Logger LOG = LogManager.getLogger(HoodieReplaceCommitMetadata.class);
    protected Map<String, List<String>> partitionToReplaceFileIds = new HashMap<String, List<String>>();

    public HoodieReplaceCommitMetadata() {
        this(false);
    }

    public HoodieReplaceCommitMetadata(boolean compacted) {
        super(compacted);
    }

    public void setPartitionToReplaceFileIds(Map<String, List<String>> partitionToReplaceFileIds) {
        this.partitionToReplaceFileIds = partitionToReplaceFileIds;
    }

    public void addReplaceFileId(String partitionPath, String fileId) {
        if (!this.partitionToReplaceFileIds.containsKey(partitionPath)) {
            this.partitionToReplaceFileIds.put(partitionPath, new ArrayList());
        }
        this.partitionToReplaceFileIds.get(partitionPath).add(fileId);
    }

    public List<String> getReplaceFileIds(String partitionPath) {
        return this.partitionToReplaceFileIds.get(partitionPath);
    }

    public Map<String, List<String>> getPartitionToReplaceFileIds() {
        return this.partitionToReplaceFileIds;
    }

    @Override
    public String toJsonString() throws IOException {
        if (this.partitionToWriteStats.containsKey(null)) {
            LOG.info((Object)("partition path is null for " + this.partitionToWriteStats.get(null)));
            this.partitionToWriteStats.remove(null);
        }
        if (this.partitionToReplaceFileIds.containsKey(null)) {
            LOG.info((Object)("partition path is null for " + this.partitionToReplaceFileIds.get(null)));
            this.partitionToReplaceFileIds.remove(null);
        }
        return JsonUtils.getObjectMapper().writerWithDefaultPrettyPrinter().writeValueAsString(this);
    }

    public static <T> T fromJsonString(String jsonStr, Class<T> clazz) throws Exception {
        if (jsonStr == null || jsonStr.isEmpty()) {
            return clazz.newInstance();
        }
        return JsonUtils.getObjectMapper().readValue(jsonStr, clazz);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HoodieReplaceCommitMetadata that = (HoodieReplaceCommitMetadata)o;
        if (!this.partitionToWriteStats.equals(that.partitionToWriteStats)) {
            return false;
        }
        return this.compacted.equals(that.compacted);
    }

    @Override
    public int hashCode() {
        int result = this.partitionToWriteStats.hashCode();
        result = 31 * result + this.compacted.hashCode();
        return result;
    }

    public static <T> T fromBytes(byte[] bytes, Class<T> clazz) throws IOException {
        try {
            return HoodieReplaceCommitMetadata.fromJsonString(new String(bytes, StandardCharsets.UTF_8), clazz);
        }
        catch (Exception e) {
            throw new IOException("unable to read commit metadata", e);
        }
    }

    @Override
    public String toString() {
        return "HoodieReplaceMetadata{partitionToWriteStats=" + this.partitionToWriteStats + ", partitionToReplaceFileIds=" + this.partitionToReplaceFileIds + ", compacted=" + this.compacted + ", extraMetadata=" + this.extraMetadata + ", operationType=" + (Object)((Object)this.operationType) + '}';
    }
}

