/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.table.timeline.versioning.clean;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.hadoop.fs.Path;
import org.apache.hudi.avro.model.HoodieCleanMetadata;
import org.apache.hudi.avro.model.HoodieCleanPartitionMetadata;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.timeline.versioning.AbstractMigratorBase;
import org.apache.hudi.common.util.ValidationUtils;
import org.apache.hudi.common.util.collection.Pair;

public class CleanMetadataV2MigrationHandler
extends AbstractMigratorBase<HoodieCleanMetadata> {
    public static final Integer VERSION = 2;

    public CleanMetadataV2MigrationHandler(HoodieTableMetaClient metaClient) {
        super(metaClient);
    }

    @Override
    public Integer getManagedVersion() {
        return VERSION;
    }

    @Override
    public HoodieCleanMetadata upgradeFrom(HoodieCleanMetadata input) {
        ValidationUtils.checkArgument(input.getVersion() == 1, "Input version is " + input.getVersion() + ". Must be 1");
        Map<String, HoodieCleanPartitionMetadata> partitionMetadataMap = input.getPartitionMetadata().entrySet().stream().map(entry -> {
            String partitionPath = (String)entry.getKey();
            HoodieCleanPartitionMetadata partitionMetadata = (HoodieCleanPartitionMetadata)((Object)((Object)entry.getValue()));
            List<String> deletePathPatterns = this.convertToV2Path(partitionMetadata.getDeletePathPatterns());
            List<String> successDeleteFiles = this.convertToV2Path(partitionMetadata.getSuccessDeleteFiles());
            List<String> failedDeleteFiles = this.convertToV2Path(partitionMetadata.getFailedDeleteFiles());
            HoodieCleanPartitionMetadata cleanPartitionMetadata = HoodieCleanPartitionMetadata.newBuilder().setPolicy(partitionMetadata.getPolicy()).setPartitionPath(partitionMetadata.getPartitionPath()).setDeletePathPatterns(deletePathPatterns).setSuccessDeleteFiles(successDeleteFiles).setFailedDeleteFiles(failedDeleteFiles).build();
            return Pair.of(partitionPath, cleanPartitionMetadata);
        }).collect(Collectors.toMap(Pair::getKey, Pair::getValue));
        return HoodieCleanMetadata.newBuilder().setEarliestCommitToRetain(input.getEarliestCommitToRetain()).setLastCompletedCommitTimestamp(input.getLastCompletedCommitTimestamp()).setStartCleanTime(input.getStartCleanTime()).setTimeTakenInMillis(input.getTimeTakenInMillis()).setTotalFilesDeleted(input.getTotalFilesDeleted()).setPartitionMetadata(partitionMetadataMap).setVersion(this.getManagedVersion()).build();
    }

    @Override
    public HoodieCleanMetadata downgradeFrom(HoodieCleanMetadata input) {
        throw new IllegalArgumentException("This is the current highest version. Input cannot be any higher version");
    }

    private List<String> convertToV2Path(List<String> paths) {
        return paths.stream().map(path -> new Path(path).getName()).collect(Collectors.toList());
    }
}

