/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hudi.org.apache.jetty.websocket.client.io;

import io.hops.hudi.org.apache.jetty.io.ByteBufferPool;
import io.hops.hudi.org.apache.jetty.io.EndPoint;
import io.hops.hudi.org.apache.jetty.util.thread.Scheduler;
import io.hops.hudi.org.apache.jetty.websocket.api.BatchMode;
import io.hops.hudi.org.apache.jetty.websocket.api.WebSocketPolicy;
import io.hops.hudi.org.apache.jetty.websocket.api.WriteCallback;
import io.hops.hudi.org.apache.jetty.websocket.api.extensions.Frame;
import io.hops.hudi.org.apache.jetty.websocket.api.extensions.IncomingFrames;
import io.hops.hudi.org.apache.jetty.websocket.client.masks.Masker;
import io.hops.hudi.org.apache.jetty.websocket.client.masks.RandomMasker;
import io.hops.hudi.org.apache.jetty.websocket.common.WebSocketFrame;
import io.hops.hudi.org.apache.jetty.websocket.common.io.AbstractWebSocketConnection;
import java.net.InetSocketAddress;
import java.util.concurrent.Executor;

public class WebSocketClientConnection
extends AbstractWebSocketConnection {
    private final Masker masker = new RandomMasker();

    public WebSocketClientConnection(EndPoint endp, Executor executor, Scheduler scheduler, WebSocketPolicy websocketPolicy, ByteBufferPool bufferPool) {
        super(endp, executor, scheduler, websocketPolicy, bufferPool);
    }

    @Override
    public InetSocketAddress getLocalAddress() {
        return this.getEndPoint().getLocalAddress();
    }

    @Override
    public InetSocketAddress getRemoteAddress() {
        return this.getEndPoint().getRemoteAddress();
    }

    @Override
    public void outgoingFrame(Frame frame, WriteCallback callback, BatchMode batchMode) {
        if (frame instanceof WebSocketFrame) {
            this.masker.setMask((WebSocketFrame)frame);
        }
        super.outgoingFrame(frame, callback, batchMode);
    }

    @Override
    public void setNextIncomingFrames(IncomingFrames incoming) {
        this.getParser().setIncomingFramesHandler(incoming);
    }
}

