/*
 * Decompiled with CFR 0.152.
 */
package io.javalin.core.util;

import io.javalin.UploadedFile;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.MultipartConfigElement;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.Part;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.io.ByteStreamsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u0014\u0012\u0004\u0012\u00020\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u00060\u00042\u0006\u0010\u0007\u001a\u00020\bJ\u001e\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00050\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u0005H\u0002J\u001c\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\u00062\u0006\u0010\r\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u0005J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0010\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002\u00a8\u0006\u0013"}, d2={"Lio/javalin/core/util/MultipartUtil;", "", "()V", "getFieldMap", "", "", "", "req", "Ljavax/servlet/http/HttpServletRequest;", "getPartValue", "partName", "getUploadedFiles", "Lio/javalin/UploadedFile;", "servletRequest", "isField", "", "filePart", "Ljavax/servlet/http/Part;", "isFile", "javalin"})
public final class MultipartUtil {
    public static final MultipartUtil INSTANCE;

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<UploadedFile> getUploadedFiles(@NotNull HttpServletRequest servletRequest, @NotNull String partName) {
        Part it;
        Iterable $receiver$iv$iv;
        Iterable $receiver$iv;
        Intrinsics.checkParameterIsNotNull(servletRequest, "servletRequest");
        Intrinsics.checkParameterIsNotNull(partName, "partName");
        servletRequest.setAttribute("io.hops.hudi.org.apache.jetty.multipartConfig", (Object)new MultipartConfigElement(System.getProperty("java.io.tmpdir")));
        Collection collection = servletRequest.getParts();
        Intrinsics.checkExpressionValueIsNotNull(collection, "servletRequest.parts");
        Iterable iterable = $receiver$iv = (Iterable)collection;
        Collection destination$iv$iv = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            Part part = it = (Part)element$iv$iv;
            Intrinsics.checkExpressionValueIsNotNull(part, "it");
            if (!(INSTANCE.isFile(part) && Intrinsics.areEqual(it.getName(), partName))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $receiver$iv = (List)destination$iv$iv;
        $receiver$iv$iv = $receiver$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver$iv, 10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void filePart;
            it = (Part)item$iv$iv;
            Collection collection2 = destination$iv$iv;
            void v2 = filePart;
            Intrinsics.checkExpressionValueIsNotNull(v2, "filePart");
            String string = v2.getContentType();
            Intrinsics.checkExpressionValueIsNotNull(string, "filePart.contentType");
            InputStream inputStream = filePart.getInputStream();
            Intrinsics.checkExpressionValueIsNotNull(inputStream, "filePart.inputStream");
            InputStream inputStream2 = new ByteArrayInputStream(ByteStreamsKt.readBytes$default(inputStream, 0, 1, null));
            String string2 = filePart.getSubmittedFileName();
            Intrinsics.checkExpressionValueIsNotNull(string2, "filePart.submittedFileName");
            String string3 = filePart.getSubmittedFileName();
            Intrinsics.checkExpressionValueIsNotNull(string3, "filePart.submittedFileName");
            UploadedFile uploadedFile = new UploadedFile(string, inputStream2, string2, StringsKt.replaceBeforeLast$default(string3, ".", "", null, 4, null));
            collection2.add(uploadedFile);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Map<String, List<String>> getFieldMap(@NotNull HttpServletRequest req) {
        void $receiver$iv$iv;
        Intrinsics.checkParameterIsNotNull(req, "req");
        req.setAttribute("io.hops.hudi.org.apache.jetty.multipartConfig", (Object)new MultipartConfigElement(System.getProperty("java.io.tmpdir")));
        Collection collection = req.getParts();
        Intrinsics.checkExpressionValueIsNotNull(collection, "req.parts");
        Iterable $receiver$iv = collection;
        int capacity$iv = RangesKt.coerceAtLeast(MapsKt.mapCapacity(CollectionsKt.collectionSizeOrDefault($receiver$iv, 10)), 16);
        Iterable iterable = $receiver$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        for (Object element$iv$iv : $receiver$iv$iv) {
            Part part;
            Map map = destination$iv$iv;
            Part part2 = part = (Part)element$iv$iv;
            Intrinsics.checkExpressionValueIsNotNull(part2, "part");
            String string = part2.getName();
            String string2 = part.getName();
            Intrinsics.checkExpressionValueIsNotNull(string2, "part.name");
            Pair<String, List<String>> pair = TuplesKt.to(string, INSTANCE.getPartValue(req, string2));
            map.put(pair.getFirst(), pair.getSecond());
        }
        return destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private final List<String> getPartValue(HttpServletRequest req, String partName) {
        Part it;
        Iterable $receiver$iv$iv;
        Iterable $receiver$iv;
        Collection collection = req.getParts();
        Intrinsics.checkExpressionValueIsNotNull(collection, "req.parts");
        Iterable iterable = $receiver$iv = (Iterable)collection;
        Collection destination$iv$iv = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            Part part = it = (Part)element$iv$iv;
            Intrinsics.checkExpressionValueIsNotNull(part, "it");
            if (!(INSTANCE.isField(part) && Intrinsics.areEqual(it.getName(), partName))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $receiver$iv = (List)destination$iv$iv;
        $receiver$iv$iv = $receiver$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver$iv, 10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            Charset charset;
            void filePart;
            it = (Part)item$iv$iv;
            Collection collection2 = destination$iv$iv;
            void v2 = filePart;
            Intrinsics.checkExpressionValueIsNotNull(v2, "filePart");
            InputStream inputStream = v2.getInputStream();
            Intrinsics.checkExpressionValueIsNotNull(inputStream, "filePart.inputStream");
            byte[] byArray = ByteStreamsKt.readBytes$default(inputStream, 0, 1, null);
            Intrinsics.checkExpressionValueIsNotNull(Charset.forName("UTF-8"), "Charset.forName(\"UTF-8\")");
            String string = new String(byArray, charset);
            collection2.add(string);
        }
        return CollectionsKt.toList((List)destination$iv$iv);
    }

    private final boolean isField(Part filePart) {
        return filePart.getSubmittedFileName() == null;
    }

    private final boolean isFile(Part filePart) {
        return !this.isField(filePart);
    }

    private MultipartUtil() {
    }

    static {
        MultipartUtil multipartUtil;
        INSTANCE = multipartUtil = new MultipartUtil();
    }
}

