/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.metrics;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.hudi.common.metrics.Counter;

public class Registry {
    ConcurrentHashMap<String, Counter> counters = new ConcurrentHashMap();
    final String name;
    private static ConcurrentHashMap<String, Registry> registryMap = new ConcurrentHashMap();

    private Registry(String name) {
        this.name = name;
    }

    public static synchronized Registry getRegistry(String registryName) {
        if (!registryMap.containsKey(registryName)) {
            registryMap.put(registryName, new Registry(registryName));
        }
        return registryMap.get(registryName);
    }

    public static synchronized Map<String, Long> getAllMetrics(boolean flush, boolean prefixWithRegistryName) {
        HashMap<String, Long> allMetrics = new HashMap<String, Long>();
        registryMap.forEach((registryName, registry) -> {
            allMetrics.putAll(registry.getAllCounts(prefixWithRegistryName));
            if (flush) {
                registry.clear();
            }
        });
        return allMetrics;
    }

    public void clear() {
        this.counters.clear();
    }

    public void increment(String name) {
        this.getCounter(name).increment();
    }

    public void add(String name, long value) {
        this.getCounter(name).add(value);
    }

    private synchronized Counter getCounter(String name) {
        if (!this.counters.containsKey(name)) {
            this.counters.put(name, new Counter());
        }
        return this.counters.get(name);
    }

    public Map<String, Long> getAllCounts() {
        return this.getAllCounts(false);
    }

    public Map<String, Long> getAllCounts(boolean prefixWithRegistryName) {
        HashMap<String, Long> countersMap = new HashMap<String, Long>();
        this.counters.forEach((k, v) -> {
            String key = prefixWithRegistryName ? this.name + "." + k : k;
            countersMap.put(key, v.getValue());
        });
        return countersMap;
    }
}

