/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.table.log.block;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hudi.common.fs.SizeAwareDataInputStream;
import org.apache.hudi.common.model.HoodieKey;
import org.apache.hudi.common.model.HoodieLogFile;
import org.apache.hudi.common.table.log.block.HoodieLogBlock;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.SerializationUtils;
import org.apache.hudi.exception.HoodieIOException;

public class HoodieDeleteBlock
extends HoodieLogBlock {
    private HoodieKey[] keysToDelete;

    public HoodieDeleteBlock(HoodieKey[] keysToDelete, Map<HoodieLogBlock.HeaderMetadataType, String> header) {
        this(Option.empty(), null, false, Option.empty(), header, new HashMap<HoodieLogBlock.HeaderMetadataType, String>());
        this.keysToDelete = keysToDelete;
    }

    private HoodieDeleteBlock(Option<byte[]> content, FSDataInputStream inputStream, boolean readBlockLazily, Option<HoodieLogBlock.HoodieLogBlockContentLocation> blockContentLocation, Map<HoodieLogBlock.HeaderMetadataType, String> header, Map<HoodieLogBlock.HeaderMetadataType, String> footer) {
        super(header, footer, blockContentLocation, content, inputStream, readBlockLazily);
    }

    @Override
    public byte[] getContentBytes() throws IOException {
        if (this.getContent().isPresent()) {
            return this.getContent().get();
        }
        if (this.readBlockLazily && !this.getContent().isPresent() && this.keysToDelete == null) {
            this.getKeysToDelete();
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream output = new DataOutputStream(baos);
        byte[] bytesToWrite = SerializationUtils.serialize(this.getKeysToDelete());
        output.writeInt(version);
        output.writeInt(bytesToWrite.length);
        output.write(bytesToWrite);
        return baos.toByteArray();
    }

    public HoodieKey[] getKeysToDelete() {
        try {
            if (this.keysToDelete == null) {
                if (!this.getContent().isPresent() && this.readBlockLazily) {
                    this.inflate();
                }
                SizeAwareDataInputStream dis = new SizeAwareDataInputStream(new DataInputStream(new ByteArrayInputStream(this.getContent().get())));
                int version = dis.readInt();
                int dataLength = dis.readInt();
                byte[] data = new byte[dataLength];
                dis.readFully(data);
                this.keysToDelete = (HoodieKey[])SerializationUtils.deserialize(data);
                this.deflate();
            }
            return this.keysToDelete;
        }
        catch (IOException io) {
            throw new HoodieIOException("Unable to generate keys to delete from block content", io);
        }
    }

    @Override
    public HoodieLogBlock.HoodieLogBlockType getBlockType() {
        return HoodieLogBlock.HoodieLogBlockType.DELETE_BLOCK;
    }

    public static HoodieLogBlock getBlock(HoodieLogFile logFile, FSDataInputStream inputStream, Option<byte[]> content, boolean readBlockLazily, long position, long blockSize, long blockEndPos, Map<HoodieLogBlock.HeaderMetadataType, String> header, Map<HoodieLogBlock.HeaderMetadataType, String> footer) throws IOException {
        return new HoodieDeleteBlock(content, inputStream, readBlockLazily, Option.of(new HoodieLogBlock.HoodieLogBlockContentLocation(logFile, position, blockSize, blockEndPos)), header, footer);
    }
}

