/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.table.timeline;

import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.hudi.avro.model.HoodieCleanMetadata;
import org.apache.hudi.avro.model.HoodieRestoreMetadata;
import org.apache.hudi.common.model.HoodieCommitMetadata;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.table.timeline.HoodieTimeline;
import org.apache.hudi.common.table.timeline.TimelineMetadataUtils;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.exception.HoodieIOException;

public class TimelineUtils {
    public static List<String> getPartitionsWritten(HoodieTimeline timeline) {
        HoodieTimeline timelineToSync = timeline.getCommitsAndCompactionTimeline();
        return TimelineUtils.getAffectedPartitions(timelineToSync);
    }

    public static List<String> getAffectedPartitions(HoodieTimeline timeline) {
        return timeline.filterCompletedInstants().getInstants().flatMap(s -> {
            switch (s.getAction()) {
                case "commit": 
                case "deltacommit": {
                    try {
                        HoodieCommitMetadata commitMetadata = HoodieCommitMetadata.fromBytes(timeline.getInstantDetails((HoodieInstant)s).get(), HoodieCommitMetadata.class);
                        return commitMetadata.getPartitionToWriteStats().keySet().stream();
                    }
                    catch (IOException e) {
                        throw new HoodieIOException("Failed to get partitions written at " + s, e);
                    }
                }
                case "clean": {
                    try {
                        HoodieCleanMetadata cleanMetadata = TimelineMetadataUtils.deserializeHoodieCleanMetadata(timeline.getInstantDetails((HoodieInstant)s).get());
                        return cleanMetadata.getPartitionMetadata().keySet().stream();
                    }
                    catch (IOException e) {
                        throw new HoodieIOException("Failed to get partitions cleaned at " + s, e);
                    }
                }
                case "rollback": {
                    try {
                        return TimelineMetadataUtils.deserializeHoodieRollbackMetadata(timeline.getInstantDetails((HoodieInstant)s).get()).getPartitionMetadata().keySet().stream();
                    }
                    catch (IOException e) {
                        throw new HoodieIOException("Failed to get partitions rolledback at " + s, e);
                    }
                }
                case "restore": {
                    try {
                        HoodieRestoreMetadata restoreMetadata = TimelineMetadataUtils.deserializeAvroMetadata(timeline.getInstantDetails((HoodieInstant)s).get(), HoodieRestoreMetadata.class);
                        return restoreMetadata.getHoodieRestoreMetadata().values().stream().flatMap(Collection::stream).flatMap(rollbackMetadata -> rollbackMetadata.getPartitionMetadata().keySet().stream());
                    }
                    catch (IOException e) {
                        throw new HoodieIOException("Failed to get partitions restored at " + s, e);
                    }
                }
                case "savepoint": {
                    try {
                        return TimelineMetadataUtils.deserializeHoodieSavepointMetadata(timeline.getInstantDetails((HoodieInstant)s).get()).getPartitionMetadata().keySet().stream();
                    }
                    catch (IOException e) {
                        throw new HoodieIOException("Failed to get partitions savepoint at " + s, e);
                    }
                }
                case "compaction": {
                    return Stream.empty();
                }
            }
            throw new HoodieIOException("unknown action in timeline " + s.getAction());
        }).distinct().filter(s -> !s.isEmpty()).collect(Collectors.toList());
    }

    public static Option<String> getExtraMetadataFromLatest(HoodieTableMetaClient metaClient, String extraMetadataKey) {
        return metaClient.getCommitsTimeline().filterCompletedInstants().getReverseOrderedInstants().findFirst().map(instant -> TimelineUtils.getMetadataValue(metaClient, extraMetadataKey, instant)).orElse(Option.empty());
    }

    public static Map<String, Option<String>> getAllExtraMetadataForKey(HoodieTableMetaClient metaClient, String extraMetadataKey) {
        return metaClient.getCommitsTimeline().filterCompletedInstants().getReverseOrderedInstants().collect(Collectors.toMap(HoodieInstant::getTimestamp, instant -> TimelineUtils.getMetadataValue(metaClient, extraMetadataKey, instant)));
    }

    private static Option<String> getMetadataValue(HoodieTableMetaClient metaClient, String extraMetadataKey, HoodieInstant instant) {
        try {
            HoodieCommitMetadata commitMetadata = HoodieCommitMetadata.fromBytes(metaClient.getCommitsTimeline().getInstantDetails(instant).get(), HoodieCommitMetadata.class);
            return Option.ofNullable(commitMetadata.getExtraMetadata().get(extraMetadataKey));
        }
        catch (IOException e) {
            throw new HoodieIOException("Unable to parse instant metadata " + instant, e);
        }
    }
}

