/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.util;

import java.util.List;
import java.util.Map;
import org.apache.hudi.common.model.HoodieCommitMetadata;
import org.apache.hudi.common.model.HoodieReplaceCommitMetadata;
import org.apache.hudi.common.model.HoodieTableType;
import org.apache.hudi.common.model.HoodieWriteStat;
import org.apache.hudi.common.model.WriteOperationType;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.exception.HoodieException;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

public class CommitUtils {
    private static final Logger LOG = LogManager.getLogger(CommitUtils.class);

    public static String getCommitActionType(HoodieTableType tableType) {
        switch (tableType) {
            case COPY_ON_WRITE: {
                return "commit";
            }
            case MERGE_ON_READ: {
                return "deltacommit";
            }
        }
        throw new HoodieException("Could not commit on unknown table type " + (Object)((Object)tableType));
    }

    public static HoodieCommitMetadata buildMetadata(List<HoodieWriteStat> writeStats, Map<String, List<String>> partitionToReplaceFileIds, Option<Map<String, String>> extraMetadata, WriteOperationType operationType, String schemaToStoreInCommit, String commitActionType) {
        HoodieCommitMetadata commitMetadata = CommitUtils.buildMetadataFromStats(writeStats, partitionToReplaceFileIds, commitActionType, operationType);
        if (extraMetadata.isPresent()) {
            extraMetadata.get().forEach(commitMetadata::addMetadata);
        }
        commitMetadata.addMetadata("schema", schemaToStoreInCommit);
        commitMetadata.setOperationType(operationType);
        return commitMetadata;
    }

    private static HoodieCommitMetadata buildMetadataFromStats(List<HoodieWriteStat> writeStats, Map<String, List<String>> partitionToReplaceFileIds, String commitActionType, WriteOperationType operationType) {
        HoodieCommitMetadata commitMetadata;
        if (commitActionType == "replacecommit") {
            HoodieReplaceCommitMetadata replaceMetadata = new HoodieReplaceCommitMetadata();
            replaceMetadata.setPartitionToReplaceFileIds(partitionToReplaceFileIds);
            commitMetadata = replaceMetadata;
        } else {
            commitMetadata = new HoodieCommitMetadata();
        }
        for (HoodieWriteStat writeStat : writeStats) {
            String partition = writeStat.getPartitionPath();
            commitMetadata.addWriteStat(partition, writeStat);
        }
        LOG.info("Creating  metadata for " + (Object)((Object)operationType) + " numWriteStats:" + writeStats.size() + "numReplaceFileIds:" + partitionToReplaceFileIds.values().stream().mapToInt(e -> e.size()).sum());
        return commitMetadata;
    }
}

