/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hudi.org.apache.jetty.client.util;

import io.hops.hudi.org.apache.jetty.client.api.Authentication;
import io.hops.hudi.org.apache.jetty.client.api.ContentResponse;
import io.hops.hudi.org.apache.jetty.client.api.Request;
import io.hops.hudi.org.apache.jetty.client.util.AbstractAuthentication;
import io.hops.hudi.org.apache.jetty.http.HttpHeader;
import io.hops.hudi.org.apache.jetty.util.Attributes;
import io.hops.hudi.org.apache.jetty.util.B64Code;
import java.net.URI;
import java.nio.charset.StandardCharsets;

public class BasicAuthentication
extends AbstractAuthentication {
    private final String user;
    private final String password;

    public BasicAuthentication(URI uri, String realm, String user, String password) {
        super(uri, realm);
        this.user = user;
        this.password = password;
    }

    @Override
    public String getType() {
        return "Basic";
    }

    @Override
    public Authentication.Result authenticate(Request request, ContentResponse response, Authentication.HeaderInfo headerInfo, Attributes context) {
        return new BasicResult(this.getURI(), headerInfo.getHeader(), this.user, this.password);
    }

    public static class BasicResult
    implements Authentication.Result {
        private final URI uri;
        private final HttpHeader header;
        private final String value;

        public BasicResult(URI uri, String user, String password) {
            this(uri, HttpHeader.AUTHORIZATION, user, password);
        }

        public BasicResult(URI uri, HttpHeader header, String user, String password) {
            this.uri = uri;
            this.header = header;
            this.value = "Basic " + B64Code.encode(user + ":" + password, StandardCharsets.ISO_8859_1);
        }

        @Override
        public URI getURI() {
            return this.uri;
        }

        @Override
        public void apply(Request request) {
            if (!request.getHeaders().contains(this.header, this.value)) {
                request.header(this.header, this.value);
            }
        }

        public String toString() {
            return String.format("Basic authentication result for %s", this.getURI());
        }
    }
}

