/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hudi.org.apache.jetty.server;

import io.hops.hudi.org.apache.jetty.io.AbstractConnection;
import io.hops.hudi.org.apache.jetty.io.Connection;
import io.hops.hudi.org.apache.jetty.io.EndPoint;
import io.hops.hudi.org.apache.jetty.server.AbstractConnectionFactory;
import io.hops.hudi.org.apache.jetty.server.ConnectionFactory;
import io.hops.hudi.org.apache.jetty.server.Connector;
import io.hops.hudi.org.apache.jetty.server.SslConnectionFactory;
import io.hops.hudi.org.apache.jetty.util.BufferUtil;
import io.hops.hudi.org.apache.jetty.util.Callback;
import io.hops.hudi.org.apache.jetty.util.log.Log;
import io.hops.hudi.org.apache.jetty.util.log.Logger;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;

public class OptionalSslConnectionFactory
extends AbstractConnectionFactory {
    private static final Logger LOG = Log.getLogger(OptionalSslConnection.class);
    private static final int TLS_ALERT_FRAME_TYPE = 21;
    private static final int TLS_HANDSHAKE_FRAME_TYPE = 22;
    private static final int TLS_MAJOR_VERSION = 3;
    private final SslConnectionFactory sslConnectionFactory;
    private final String otherProtocol;

    public OptionalSslConnectionFactory(SslConnectionFactory sslConnectionFactory, String otherProtocol) {
        super("ssl|other");
        this.sslConnectionFactory = sslConnectionFactory;
        this.otherProtocol = otherProtocol;
    }

    @Override
    public Connection newConnection(Connector connector, EndPoint endPoint) {
        return this.configure(new OptionalSslConnection(endPoint, connector), connector, endPoint);
    }

    protected boolean seemsTLS(ByteBuffer buffer) {
        int tlsFrameType = buffer.get(0) & 0xFF;
        int tlsMajorVersion = buffer.get(1) & 0xFF;
        return (tlsFrameType == 22 || tlsFrameType == 21) && tlsMajorVersion == 3;
    }

    protected void otherProtocol(ByteBuffer buffer, EndPoint endPoint) {
        int byte1 = buffer.get(0) & 0xFF;
        int byte2 = buffer.get(1) & 0xFF;
        if (byte1 == 71 && byte2 == 69) {
            String body = "<!DOCTYPE html>\r\n<html>\r\n<head><title>Bad Request</title></head>\r\n<body><h1>Bad Request</h1><p>HTTP request to HTTPS port</p></body>\r\n</html>";
            String response = "HTTP/1.1 400 Bad Request\r\nContent-Type: text/html\r\nContent-Length: " + body.length() + "\r\nConnection: close\r\n\r\n" + body;
            Callback.Completable completable = new Callback.Completable();
            endPoint.write(completable, ByteBuffer.wrap(response.getBytes(StandardCharsets.US_ASCII)));
            completable.whenComplete((r, x) -> endPoint.close());
        } else {
            endPoint.close();
        }
    }

    private class OptionalSslConnection
    extends AbstractConnection
    implements Connection.UpgradeFrom {
        private final Connector connector;
        private final ByteBuffer buffer;

        public OptionalSslConnection(EndPoint endPoint, Connector connector) {
            super(endPoint, connector.getExecutor());
            this.connector = connector;
            this.buffer = BufferUtil.allocateDirect(1536);
        }

        @Override
        public void onOpen() {
            super.onOpen();
            this.fillInterested();
        }

        @Override
        public void onFillable() {
            block5: {
                try {
                    int filled;
                    while ((filled = this.getEndPoint().fill(this.buffer)) > 0) {
                        if (BufferUtil.length(this.buffer) < 2) continue;
                        this.upgrade(this.buffer);
                        break block5;
                    }
                    if (filled == 0) {
                        this.fillInterested();
                    } else {
                        this.close();
                    }
                }
                catch (IOException x) {
                    LOG.warn(x);
                    this.close();
                }
            }
        }

        @Override
        public ByteBuffer onUpgradeFrom() {
            return this.buffer;
        }

        private void upgrade(ByteBuffer buffer) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Read {}", BufferUtil.toDetailString(buffer));
            }
            EndPoint endPoint = this.getEndPoint();
            if (OptionalSslConnectionFactory.this.seemsTLS(buffer)) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Detected TLS bytes, upgrading to {}", OptionalSslConnectionFactory.this.sslConnectionFactory);
                }
                endPoint.upgrade(OptionalSslConnectionFactory.this.sslConnectionFactory.newConnection(this.connector, endPoint));
            } else if (OptionalSslConnectionFactory.this.otherProtocol != null) {
                ConnectionFactory connectionFactory = this.connector.getConnectionFactory(OptionalSslConnectionFactory.this.otherProtocol);
                if (connectionFactory != null) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Detected non-TLS bytes, upgrading to {}", connectionFactory);
                    }
                    Connection next = connectionFactory.newConnection(this.connector, endPoint);
                    endPoint.upgrade(next);
                } else {
                    LOG.warn("Missing {} {} in {}", OptionalSslConnectionFactory.this.otherProtocol, ConnectionFactory.class.getSimpleName(), this.connector);
                    this.close();
                }
            } else {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Detected non-TLS bytes, but no other protocol to upgrade to", new Object[0]);
                }
                OptionalSslConnectionFactory.this.otherProtocol(buffer, endPoint);
            }
        }
    }
}

