/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hudi.org.apache.jetty.webapp;

import io.hops.hudi.org.apache.jetty.util.log.Log;
import io.hops.hudi.org.apache.jetty.util.log.Logger;
import io.hops.hudi.org.apache.jetty.util.resource.EmptyResource;
import io.hops.hudi.org.apache.jetty.util.resource.Resource;
import io.hops.hudi.org.apache.jetty.webapp.AbsoluteOrdering;
import io.hops.hudi.org.apache.jetty.webapp.DefaultsDescriptor;
import io.hops.hudi.org.apache.jetty.webapp.Descriptor;
import io.hops.hudi.org.apache.jetty.webapp.DescriptorProcessor;
import io.hops.hudi.org.apache.jetty.webapp.DiscoveredAnnotation;
import io.hops.hudi.org.apache.jetty.webapp.FragmentDescriptor;
import io.hops.hudi.org.apache.jetty.webapp.MetaDataComplete;
import io.hops.hudi.org.apache.jetty.webapp.Ordering;
import io.hops.hudi.org.apache.jetty.webapp.Origin;
import io.hops.hudi.org.apache.jetty.webapp.OverrideDescriptor;
import io.hops.hudi.org.apache.jetty.webapp.RelativeOrdering;
import io.hops.hudi.org.apache.jetty.webapp.WebAppContext;
import io.hops.hudi.org.apache.jetty.webapp.WebDescriptor;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class MetaData {
    private static final Logger LOG = Log.getLogger(MetaData.class);
    public static final String VALIDATE_XML = "io.hops.hudi.org.apache.jetty.webapp.validateXml";
    public static final String ORDERED_LIBS = "javax.servlet.context.orderedLibs";
    public static final Resource NON_FRAG_RESOURCE = EmptyResource.INSTANCE;
    protected Map<String, OriginInfo> _origins = new HashMap<String, OriginInfo>();
    protected WebDescriptor _webDefaultsRoot;
    protected WebDescriptor _webXmlRoot;
    protected final List<WebDescriptor> _webOverrideRoots = new ArrayList<WebDescriptor>();
    protected boolean _metaDataComplete;
    protected final List<DescriptorProcessor> _descriptorProcessors = new ArrayList<DescriptorProcessor>();
    protected final List<FragmentDescriptor> _webFragmentRoots = new ArrayList<FragmentDescriptor>();
    protected final Map<String, FragmentDescriptor> _webFragmentNameMap = new HashMap<String, FragmentDescriptor>();
    protected final Map<Resource, FragmentDescriptor> _webFragmentResourceMap = new HashMap<Resource, FragmentDescriptor>();
    protected final Map<Resource, List<DiscoveredAnnotation>> _annotations = new HashMap<Resource, List<DiscoveredAnnotation>>();
    protected final List<Resource> _webInfClasses = new ArrayList<Resource>();
    protected final List<Resource> _webInfJars = new ArrayList<Resource>();
    protected final List<Resource> _orderedContainerResources = new ArrayList<Resource>();
    protected final List<Resource> _orderedWebInfResources = new ArrayList<Resource>();
    protected Ordering _ordering;
    protected boolean _allowDuplicateFragmentNames = false;
    protected boolean _validateXml = false;

    public void clear() {
        this._webDefaultsRoot = null;
        this._origins.clear();
        this._webXmlRoot = null;
        this._webOverrideRoots.clear();
        this._metaDataComplete = false;
        this._annotations.clear();
        this._descriptorProcessors.clear();
        this._webFragmentRoots.clear();
        this._webFragmentNameMap.clear();
        this._webFragmentResourceMap.clear();
        this._annotations.clear();
        this._webInfJars.clear();
        this._orderedWebInfResources.clear();
        this._orderedContainerResources.clear();
        this._ordering = null;
        this._allowDuplicateFragmentNames = false;
    }

    public void setDefaults(Resource webDefaults) throws Exception {
        this._webDefaultsRoot = new DefaultsDescriptor(webDefaults);
        this._webDefaultsRoot.setValidating(this.isValidateXml());
        this._webDefaultsRoot.parse();
        if (this._webDefaultsRoot.isOrdered()) {
            Ordering ordering = this.getOrdering();
            if (ordering == null) {
                ordering = new AbsoluteOrdering(this);
            }
            List<String> order = this._webDefaultsRoot.getOrdering();
            for (String s : order) {
                if (s.equalsIgnoreCase("others")) {
                    ((AbsoluteOrdering)ordering).addOthers();
                    continue;
                }
                ((AbsoluteOrdering)ordering).add(s);
            }
            this.setOrdering(ordering);
        }
    }

    public void setWebXml(Resource webXml) throws Exception {
        this._webXmlRoot = new WebDescriptor(webXml);
        this._webXmlRoot.setValidating(this.isValidateXml());
        this._webXmlRoot.parse();
        boolean bl = this._metaDataComplete = this._webXmlRoot.getMetaDataComplete() == MetaDataComplete.True;
        if (this._webXmlRoot.isOrdered()) {
            Ordering ordering = this.getOrdering();
            if (ordering == null) {
                ordering = new AbsoluteOrdering(this);
            }
            List<String> order = this._webXmlRoot.getOrdering();
            for (String s : order) {
                if (s.equalsIgnoreCase("others")) {
                    ((AbsoluteOrdering)ordering).addOthers();
                    continue;
                }
                ((AbsoluteOrdering)ordering).add(s);
            }
            this.setOrdering(ordering);
        }
    }

    public void addOverride(Resource override) throws Exception {
        OverrideDescriptor webOverrideRoot = new OverrideDescriptor(override);
        webOverrideRoot.setValidating(false);
        webOverrideRoot.parse();
        switch (webOverrideRoot.getMetaDataComplete()) {
            case True: {
                this._metaDataComplete = true;
                break;
            }
            case False: {
                this._metaDataComplete = false;
                break;
            }
        }
        if (webOverrideRoot.isOrdered()) {
            Ordering ordering = this.getOrdering();
            if (ordering == null) {
                ordering = new AbsoluteOrdering(this);
            }
            List<String> order = webOverrideRoot.getOrdering();
            for (String s : order) {
                if (s.equalsIgnoreCase("others")) {
                    ((AbsoluteOrdering)ordering).addOthers();
                    continue;
                }
                ((AbsoluteOrdering)ordering).add(s);
            }
            this.setOrdering(ordering);
        }
        this._webOverrideRoots.add(webOverrideRoot);
    }

    public void addFragment(Resource jarResource, Resource xmlResource) throws Exception {
        if (this._metaDataComplete) {
            return;
        }
        FragmentDescriptor descriptor = new FragmentDescriptor(xmlResource);
        this._webFragmentResourceMap.put(jarResource, descriptor);
        this._webFragmentRoots.add(descriptor);
        descriptor.setValidating(this.isValidateXml());
        descriptor.parse();
        if (descriptor.getName() != null) {
            Descriptor existing = this._webFragmentNameMap.get(descriptor.getName());
            if (existing != null && !this.isAllowDuplicateFragmentNames()) {
                throw new IllegalStateException("Duplicate fragment name: " + descriptor.getName() + " for " + existing.getResource() + " and " + descriptor.getResource());
            }
            this._webFragmentNameMap.put(descriptor.getName(), descriptor);
        }
        if (this._ordering == null && descriptor.isOrdered()) {
            this.setOrdering(new RelativeOrdering(this));
            return;
        }
        this.orderFragments();
    }

    public void addDiscoveredAnnotations(List<DiscoveredAnnotation> annotations) {
        if (annotations == null) {
            return;
        }
        for (DiscoveredAnnotation a : annotations) {
            this.addDiscoveredAnnotation(a);
        }
    }

    public synchronized void addDiscoveredAnnotation(DiscoveredAnnotation annotation) {
        List<DiscoveredAnnotation> list;
        if (annotation == null) {
            return;
        }
        Resource resource = annotation.getResource();
        if (resource == null || !this._webInfJars.contains(resource)) {
            resource = EmptyResource.INSTANCE;
        }
        if ((list = this._annotations.get(resource)) == null) {
            list = new ArrayList<DiscoveredAnnotation>();
            this._annotations.put(resource, list);
        }
        list.add(annotation);
    }

    public void addDescriptorProcessor(DescriptorProcessor p) {
        this._descriptorProcessors.add(p);
    }

    public void removeDescriptorProcessor(DescriptorProcessor p) {
        this._descriptorProcessors.remove(p);
    }

    public void orderFragments() {
        this._orderedWebInfResources.clear();
        if (this.getOrdering() != null) {
            this._orderedWebInfResources.addAll(this.getOrdering().order(this._webInfJars));
        }
    }

    /*
     * WARNING - void declaration
     */
    public void resolve(WebAppContext context) throws Exception {
        void var4_12;
        LOG.debug("metadata resolve {}", context);
        this._origins.clear();
        List<Resource> orderedWebInfJars = null;
        if (this.getOrdering() != null) {
            orderedWebInfJars = this.getOrderedWebInfJars();
            ArrayList orderedLibs = new ArrayList();
            for (Resource resource : orderedWebInfJars) {
                String fullname = resource.getName();
                int i = fullname.indexOf(".jar");
                int j = fullname.lastIndexOf("/", i);
                orderedLibs.add(fullname.substring(j + 1, i + 4));
            }
            context.setAttribute(ORDERED_LIBS, orderedLibs);
        }
        if (this._webXmlRoot != null) {
            context.getServletContext().setEffectiveMajorVersion(this._webXmlRoot.getMajorVersion());
            context.getServletContext().setEffectiveMinorVersion(this._webXmlRoot.getMinorVersion());
        }
        for (DescriptorProcessor descriptorProcessor : this._descriptorProcessors) {
            descriptorProcessor.process(context, this.getWebDefault());
            descriptorProcessor.process(context, this.getWebXml());
            for (WebDescriptor wd : this.getOverrideWebs()) {
                LOG.debug("process {} {}", context, wd);
                descriptorProcessor.process(context, wd);
            }
        }
        List<DiscoveredAnnotation> nonFragAnnotations = this._annotations.get(NON_FRAG_RESOURCE);
        if (nonFragAnnotations != null) {
            for (DiscoveredAnnotation discoveredAnnotation : nonFragAnnotations) {
                LOG.debug("apply {}", discoveredAnnotation);
                discoveredAnnotation.apply();
            }
        }
        Object var4_9 = null;
        if (this.getOrdering() != null) {
            List<Resource> list = orderedWebInfJars;
        } else {
            List<Resource> list = this.getWebInfJars();
        }
        for (Resource r : var4_12) {
            List<DiscoveredAnnotation> fragAnnotations;
            FragmentDescriptor fd = this._webFragmentResourceMap.get(r);
            if (fd != null) {
                for (DescriptorProcessor p : this._descriptorProcessors) {
                    LOG.debug("process {} {}", context, fd);
                    p.process(context, fd);
                }
            }
            if ((fragAnnotations = this._annotations.get(r)) == null) continue;
            for (DiscoveredAnnotation a : fragAnnotations) {
                LOG.debug("apply {}", a);
                a.apply();
            }
        }
    }

    public boolean isDistributable() {
        boolean distributable = this._webDefaultsRoot != null && this._webDefaultsRoot.isDistributable() || this._webXmlRoot != null && this._webXmlRoot.isDistributable();
        for (WebDescriptor d : this._webOverrideRoots) {
            distributable &= d.isDistributable();
        }
        if (this.getOrdering() != null) {
            List<Resource> orderedResources = this.getOrderedWebInfJars();
            for (Resource r : orderedResources) {
                FragmentDescriptor d = this._webFragmentResourceMap.get(r);
                if (d == null) continue;
                distributable = distributable && d.isDistributable();
            }
        }
        return distributable;
    }

    public WebDescriptor getWebXml() {
        return this._webXmlRoot;
    }

    public List<WebDescriptor> getOverrideWebs() {
        return this._webOverrideRoots;
    }

    public WebDescriptor getWebDefault() {
        return this._webDefaultsRoot;
    }

    public List<FragmentDescriptor> getFragments() {
        return this._webFragmentRoots;
    }

    public List<Resource> getOrderedWebInfJars() {
        return this._orderedWebInfResources;
    }

    public List<FragmentDescriptor> getOrderedFragments() {
        ArrayList<FragmentDescriptor> list = new ArrayList<FragmentDescriptor>();
        if (this.getOrdering() == null) {
            return list;
        }
        for (Resource r : this.getOrderedWebInfJars()) {
            FragmentDescriptor fd = this._webFragmentResourceMap.get(r);
            if (fd == null) continue;
            list.add(fd);
        }
        return list;
    }

    public Ordering getOrdering() {
        return this._ordering;
    }

    public void setOrdering(Ordering o) {
        this._ordering = o;
        this.orderFragments();
    }

    public FragmentDescriptor getFragment(Resource jar) {
        return this._webFragmentResourceMap.get(jar);
    }

    public FragmentDescriptor getFragment(String name) {
        return this._webFragmentNameMap.get(name);
    }

    public Resource getJarForFragment(String name) {
        FragmentDescriptor f = this.getFragment(name);
        if (f == null) {
            return null;
        }
        Resource jar = null;
        for (Resource r : this._webFragmentResourceMap.keySet()) {
            if (!this._webFragmentResourceMap.get(r).equals(f)) continue;
            jar = r;
        }
        return jar;
    }

    public Map<String, FragmentDescriptor> getNamedFragments() {
        return Collections.unmodifiableMap(this._webFragmentNameMap);
    }

    public Origin getOrigin(String name) {
        OriginInfo x = this._origins.get(name);
        if (x == null) {
            return Origin.NotSet;
        }
        return x.getOriginType();
    }

    public OriginInfo getOriginInfo(String name) {
        OriginInfo x = this._origins.get(name);
        if (x == null) {
            return null;
        }
        return x;
    }

    public Descriptor getOriginDescriptor(String name) {
        OriginInfo o = this._origins.get(name);
        if (o == null) {
            return null;
        }
        return o.getDescriptor();
    }

    public void setOrigin(String name, Descriptor d) {
        OriginInfo x = new OriginInfo(name, d);
        this._origins.put(name, x);
    }

    public void setOrigin(String name, Annotation annotation, Class<?> annotated) {
        if (name == null) {
            return;
        }
        OriginInfo x = new OriginInfo(name, annotation, annotated);
        this._origins.put(name, x);
    }

    public void setOriginAPI(String name) {
        if (name == null) {
            return;
        }
        OriginInfo x = new OriginInfo(name);
        this._origins.put(name, x);
    }

    public boolean isMetaDataComplete() {
        return this._metaDataComplete;
    }

    public void addWebInfJar(Resource newResource) {
        this._webInfJars.add(newResource);
    }

    public List<Resource> getWebInfJars() {
        return Collections.unmodifiableList(this._webInfJars);
    }

    public List<Resource> getContainerResources() {
        return this._orderedContainerResources;
    }

    public void addContainerResource(Resource jar) {
        this._orderedContainerResources.add(jar);
    }

    public void setWebInfClassesDirs(List<Resource> dirs) {
        this._webInfClasses.addAll(dirs);
    }

    public List<Resource> getWebInfClassesDirs() {
        return this._webInfClasses;
    }

    public boolean isAllowDuplicateFragmentNames() {
        return this._allowDuplicateFragmentNames;
    }

    public void setAllowDuplicateFragmentNames(boolean allowDuplicateFragmentNames) {
        this._allowDuplicateFragmentNames = allowDuplicateFragmentNames;
    }

    public boolean isValidateXml() {
        return this._validateXml;
    }

    public void setValidateXml(boolean validateXml) {
        this._validateXml = validateXml;
    }

    public Map<String, OriginInfo> getOrigins() {
        return Collections.unmodifiableMap(this._origins);
    }

    public static class OriginInfo {
        private final String name;
        private final Origin origin;
        private final Descriptor descriptor;
        private final Annotation annotation;
        private final Class<?> annotated;

        public OriginInfo(String n, Annotation a, Class<?> ac) {
            this.name = n;
            this.origin = Origin.Annotation;
            this.descriptor = null;
            this.annotation = a;
            this.annotated = ac;
        }

        public OriginInfo(String n, Descriptor d) {
            this.name = n;
            this.descriptor = d;
            this.annotation = null;
            this.annotated = null;
            if (d == null) {
                throw new IllegalArgumentException("No descriptor");
            }
            this.origin = d instanceof FragmentDescriptor ? Origin.WebFragment : (d instanceof OverrideDescriptor ? Origin.WebOverride : (d instanceof DefaultsDescriptor ? Origin.WebDefaults : Origin.WebXml));
        }

        public OriginInfo(String n) {
            this.name = n;
            this.origin = Origin.API;
            this.annotation = null;
            this.descriptor = null;
            this.annotated = null;
        }

        public String getName() {
            return this.name;
        }

        public Origin getOriginType() {
            return this.origin;
        }

        public Descriptor getDescriptor() {
            return this.descriptor;
        }

        public String toString() {
            if (this.descriptor != null) {
                return this.descriptor.toString();
            }
            if (this.annotation != null) {
                return "@" + this.annotation.annotationType().getSimpleName() + "(" + this.annotated.getName() + ")";
            }
            return this.origin.toString();
        }
    }
}

