/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hudi.org.apache.jetty.websocket.client;

import io.hops.hudi.org.apache.jetty.client.HttpClient;
import io.hops.hudi.org.apache.jetty.client.HttpConversation;
import io.hops.hudi.org.apache.jetty.client.HttpRequest;
import io.hops.hudi.org.apache.jetty.client.HttpResponse;
import io.hops.hudi.org.apache.jetty.client.HttpResponseException;
import io.hops.hudi.org.apache.jetty.client.api.ContentResponse;
import io.hops.hudi.org.apache.jetty.client.api.Response;
import io.hops.hudi.org.apache.jetty.client.api.Result;
import io.hops.hudi.org.apache.jetty.client.http.HttpConnectionOverHTTP;
import io.hops.hudi.org.apache.jetty.client.http.HttpConnectionUpgrader;
import io.hops.hudi.org.apache.jetty.http.HttpField;
import io.hops.hudi.org.apache.jetty.http.HttpFields;
import io.hops.hudi.org.apache.jetty.http.HttpHeader;
import io.hops.hudi.org.apache.jetty.http.HttpMethod;
import io.hops.hudi.org.apache.jetty.http.HttpVersion;
import io.hops.hudi.org.apache.jetty.io.Connection;
import io.hops.hudi.org.apache.jetty.io.EndPoint;
import io.hops.hudi.org.apache.jetty.util.B64Code;
import io.hops.hudi.org.apache.jetty.util.MultiMap;
import io.hops.hudi.org.apache.jetty.util.QuotedStringTokenizer;
import io.hops.hudi.org.apache.jetty.util.UrlEncoded;
import io.hops.hudi.org.apache.jetty.util.log.Log;
import io.hops.hudi.org.apache.jetty.util.log.Logger;
import io.hops.hudi.org.apache.jetty.websocket.api.Session;
import io.hops.hudi.org.apache.jetty.websocket.api.UpgradeException;
import io.hops.hudi.org.apache.jetty.websocket.api.UpgradeRequest;
import io.hops.hudi.org.apache.jetty.websocket.api.extensions.ExtensionConfig;
import io.hops.hudi.org.apache.jetty.websocket.api.extensions.ExtensionFactory;
import io.hops.hudi.org.apache.jetty.websocket.client.ClientUpgradeRequest;
import io.hops.hudi.org.apache.jetty.websocket.client.ClientUpgradeResponse;
import io.hops.hudi.org.apache.jetty.websocket.client.WebSocketClient;
import io.hops.hudi.org.apache.jetty.websocket.client.io.UpgradeListener;
import io.hops.hudi.org.apache.jetty.websocket.client.io.WebSocketClientConnection;
import io.hops.hudi.org.apache.jetty.websocket.common.AcceptHash;
import io.hops.hudi.org.apache.jetty.websocket.common.SessionFactory;
import io.hops.hudi.org.apache.jetty.websocket.common.WebSocketSession;
import io.hops.hudi.org.apache.jetty.websocket.common.events.EventDriver;
import io.hops.hudi.org.apache.jetty.websocket.common.extensions.ExtensionStack;
import java.io.IOException;
import java.net.HttpCookie;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeoutException;

public class WebSocketUpgradeRequest
extends HttpRequest
implements Response.CompleteListener,
HttpConnectionUpgrader {
    private static final Logger LOG = Log.getLogger(WebSocketUpgradeRequest.class);
    private final WebSocketClient wsClient;
    private final EventDriver localEndpoint;
    private final CompletableFuture<Session> fut;
    private final ClientUpgradeRequestFacade apiRequestFacade = new ClientUpgradeRequestFacade();
    private UpgradeListener upgradeListener;

    protected WebSocketUpgradeRequest(WebSocketClient wsClient, HttpClient httpClient, ClientUpgradeRequest request) {
        this(wsClient, httpClient, request.getRequestURI(), request.getLocalEndpoint());
        this.apiRequestFacade.init(request);
    }

    public WebSocketUpgradeRequest(WebSocketClient wsClient, HttpClient httpClient, URI wsURI, Object localEndpoint) {
        super(httpClient, new HttpConversation(), wsURI);
        if (!wsURI.isAbsolute()) {
            throw new IllegalArgumentException("WebSocket URI must be an absolute URI: " + wsURI);
        }
        String scheme = wsURI.getScheme();
        if (scheme == null || !scheme.equalsIgnoreCase("ws") && !scheme.equalsIgnoreCase("wss")) {
            throw new IllegalArgumentException("WebSocket URI must use 'ws' or 'wss' scheme: " + wsURI);
        }
        this.wsClient = wsClient;
        try {
            if (!this.wsClient.isRunning()) {
                this.wsClient.start();
            }
        }
        catch (Exception e) {
            throw new IllegalStateException("Unable to start WebSocketClient", e);
        }
        this.localEndpoint = this.wsClient.getEventDriverFactory().wrap(localEndpoint);
        this.fut = new CompletableFuture();
        this.getConversation().setAttribute(HttpConnectionUpgrader.class.getName(), this);
    }

    private final String genRandomKey() {
        byte[] bytes = new byte[16];
        ThreadLocalRandom.current().nextBytes(bytes);
        return new String(B64Code.encode(bytes));
    }

    private ExtensionFactory getExtensionFactory() {
        return this.wsClient.getExtensionFactory();
    }

    private SessionFactory getSessionFactory() {
        return this.wsClient.getSessionFactory();
    }

    private void initWebSocketHeaders() {
        this.method(HttpMethod.GET);
        this.version(HttpVersion.HTTP_1_1);
        this.header(HttpHeader.UPGRADE, "websocket");
        this.header(HttpHeader.CONNECTION, "Upgrade");
        this.header(HttpHeader.SEC_WEBSOCKET_KEY, this.genRandomKey());
        this.header(HttpHeader.SEC_WEBSOCKET_VERSION, "13");
        this.header(HttpHeader.PRAGMA, "no-cache");
        this.header(HttpHeader.CACHE_CONTROL, "no-cache");
        if (!this.apiRequestFacade.getExtensions().isEmpty()) {
            for (ExtensionConfig ext : this.apiRequestFacade.getExtensions()) {
                this.header(HttpHeader.SEC_WEBSOCKET_EXTENSIONS, ext.getParameterizedName());
            }
        }
        if (!this.apiRequestFacade.getSubProtocols().isEmpty()) {
            for (String protocol : this.apiRequestFacade.getSubProtocols()) {
                this.header(HttpHeader.SEC_WEBSOCKET_SUBPROTOCOL, protocol);
            }
        }
        if (this.upgradeListener != null) {
            this.upgradeListener.onHandshakeRequest(this.apiRequestFacade);
        }
    }

    @Override
    public void onComplete(Result result) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("onComplete() - {}", result);
        }
        URI requestURI = result.getRequest().getURI();
        Response response = result.getResponse();
        int responseStatusCode = response.getStatus();
        String responseLine = responseStatusCode + " " + response.getReason();
        if (result.isFailed()) {
            Throwable failure;
            if (LOG.isDebugEnabled()) {
                if (result.getFailure() != null) {
                    LOG.debug("General Failure", result.getFailure());
                }
                if (result.getRequestFailure() != null) {
                    LOG.debug("Request Failure", result.getRequestFailure());
                }
                if (result.getResponseFailure() != null) {
                    LOG.debug("Response Failure", result.getResponseFailure());
                }
            }
            if ((failure = result.getFailure()) instanceof IOException || failure instanceof UpgradeException) {
                this.handleException(failure);
            } else {
                this.handleException(new UpgradeException(requestURI, responseStatusCode, responseLine, failure));
            }
            return;
        }
        if (responseStatusCode != 101) {
            this.handleException(new UpgradeException(requestURI, responseStatusCode, "Failed to upgrade to websocket: Unexpected HTTP Response Status Code: " + responseLine));
        }
    }

    private void handleException(Throwable failure) {
        this.localEndpoint.onError(failure);
        this.fut.completeExceptionally(failure);
    }

    @Override
    public ContentResponse send() throws InterruptedException, TimeoutException, ExecutionException {
        throw new RuntimeException("Working with raw ContentResponse is invalid for WebSocket");
    }

    @Override
    public void send(Response.CompleteListener listener) {
        this.initWebSocketHeaders();
        super.send(listener);
    }

    public CompletableFuture<Session> sendAsync() {
        this.send(this);
        return this.fut;
    }

    @Override
    public void upgrade(HttpResponse response, HttpConnectionOverHTTP oldConn) {
        String[] extValues;
        String respHash;
        if (!this.getHeaders().get(HttpHeader.UPGRADE).equalsIgnoreCase("websocket")) {
            throw new HttpResponseException("Not WebSocket Upgrade", response);
        }
        String reqKey = this.getHeaders().get(HttpHeader.SEC_WEBSOCKET_KEY);
        String expectedHash = AcceptHash.hashKey(reqKey);
        if (!expectedHash.equalsIgnoreCase(respHash = response.getHeaders().get(HttpHeader.SEC_WEBSOCKET_ACCEPT))) {
            throw new HttpResponseException("Invalid Sec-WebSocket-Accept hash", response);
        }
        EndPoint endp = oldConn.getEndPoint();
        WebSocketClientConnection connection = new WebSocketClientConnection(endp, this.wsClient.getExecutor(), this.wsClient.getScheduler(), this.localEndpoint.getPolicy(), this.wsClient.getBufferPool());
        Collection<Connection.Listener> connectionListeners = this.wsClient.getBeans(Connection.Listener.class);
        if (connectionListeners != null) {
            connectionListeners.forEach(listener -> connection.addListener((Connection.Listener)listener));
        }
        URI requestURI = this.getURI();
        WebSocketSession session = this.getSessionFactory().createSession(requestURI, this.localEndpoint, connection);
        session.setUpgradeRequest(new ClientUpgradeRequest(this));
        session.setUpgradeResponse(new ClientUpgradeResponse(response));
        connection.addListener(session);
        ExtensionStack extensionStack = new ExtensionStack(this.getExtensionFactory());
        ArrayList<ExtensionConfig> extensions = new ArrayList<ExtensionConfig>();
        HttpField extField = response.getHeaders().getField(HttpHeader.SEC_WEBSOCKET_EXTENSIONS);
        if (extField != null && (extValues = extField.getValues()) != null) {
            for (String extVal : extValues) {
                QuotedStringTokenizer tok = new QuotedStringTokenizer(extVal, ",");
                while (tok.hasMoreTokens()) {
                    extensions.add(ExtensionConfig.parse(tok.nextToken()));
                }
            }
        }
        extensionStack.negotiate(extensions);
        extensionStack.configure(connection.getParser());
        extensionStack.configure(connection.getGenerator());
        connection.setNextIncomingFrames(extensionStack);
        extensionStack.setNextIncoming(session);
        session.setOutgoingHandler(extensionStack);
        extensionStack.setNextOutgoing(connection);
        session.addManaged(extensionStack);
        session.setFuture(this.fut);
        this.wsClient.addManaged(session);
        if (this.upgradeListener != null) {
            this.upgradeListener.onHandshakeResponse(new ClientUpgradeResponse(response));
        }
        endp.upgrade(connection);
    }

    public void setUpgradeListener(UpgradeListener upgradeListener) {
        this.upgradeListener = upgradeListener;
    }

    private HttpFields getHttpFields() {
        return super.getHeaders();
    }

    private class ClientUpgradeRequestFacade
    implements UpgradeRequest {
        private List<ExtensionConfig> extensions = new ArrayList<ExtensionConfig>();
        private List<String> subProtocols = new ArrayList<String>();
        private Object session;

        public void init(ClientUpgradeRequest request) {
            this.extensions = new ArrayList<ExtensionConfig>(request.getExtensions());
            this.subProtocols = new ArrayList<String>(request.getSubProtocols());
            request.getHeaders().forEach((name, values2) -> values2.forEach(value -> WebSocketUpgradeRequest.this.header((String)name, (String)value)));
            for (HttpCookie cookie : request.getCookies()) {
                WebSocketUpgradeRequest.this.cookie(cookie);
            }
        }

        @Override
        public List<ExtensionConfig> getExtensions() {
            return this.extensions;
        }

        @Override
        public List<String> getSubProtocols() {
            return this.subProtocols;
        }

        @Override
        public void addExtensions(ExtensionConfig ... configs) {
            for (ExtensionConfig config : configs) {
                this.extensions.add(config);
            }
            this.updateExtensionHeader();
        }

        @Override
        public void addExtensions(String ... configs) {
            this.extensions.addAll(ExtensionConfig.parseList(configs));
            this.updateExtensionHeader();
        }

        @Override
        public void clearHeaders() {
            throw new UnsupportedOperationException("Clearing all headers breaks WebSocket upgrade");
        }

        @Override
        public String getHeader(String name) {
            return WebSocketUpgradeRequest.this.getHttpFields().get(name);
        }

        @Override
        public int getHeaderInt(String name) {
            String value = WebSocketUpgradeRequest.this.getHttpFields().get(name);
            if (value == null) {
                return -1;
            }
            return Integer.parseInt(value);
        }

        @Override
        public List<String> getHeaders(String name) {
            return WebSocketUpgradeRequest.this.getHttpFields().getValuesList(name);
        }

        @Override
        public String getHttpVersion() {
            return WebSocketUpgradeRequest.this.getVersion().asString();
        }

        @Override
        public String getOrigin() {
            return WebSocketUpgradeRequest.this.getHttpFields().get(HttpHeader.ORIGIN);
        }

        @Override
        public Map<String, List<String>> getParameterMap() {
            TreeMap<String, List<String>> paramMap = new TreeMap<String, List<String>>(String.CASE_INSENSITIVE_ORDER);
            String query = this.getQueryString();
            MultiMap<String> multimap = new MultiMap<String>();
            UrlEncoded.decodeTo(query, multimap, StandardCharsets.UTF_8);
            paramMap.putAll(multimap);
            return paramMap;
        }

        @Override
        public String getProtocolVersion() {
            String ver = WebSocketUpgradeRequest.this.getHttpFields().get(HttpHeader.SEC_WEBSOCKET_VERSION);
            if (ver == null) {
                return Integer.toString(13);
            }
            return ver;
        }

        @Override
        public String getQueryString() {
            return WebSocketUpgradeRequest.this.getURI().getQuery();
        }

        @Override
        public URI getRequestURI() {
            return WebSocketUpgradeRequest.this.getURI();
        }

        @Override
        public Object getSession() {
            return this.session;
        }

        @Override
        public Principal getUserPrincipal() {
            return null;
        }

        @Override
        public boolean hasSubProtocol(String test) {
            return this.getSubProtocols().contains(test);
        }

        @Override
        public boolean isOrigin(String test) {
            return test.equalsIgnoreCase(this.getOrigin());
        }

        @Override
        public boolean isSecure() {
            return "wss".equalsIgnoreCase(WebSocketUpgradeRequest.this.getURI().getScheme());
        }

        @Override
        public void setCookies(List<HttpCookie> cookies) {
            for (HttpCookie cookie : cookies) {
                WebSocketUpgradeRequest.this.cookie(cookie);
            }
        }

        @Override
        public void setExtensions(List<ExtensionConfig> configs) {
            this.extensions = configs;
            this.updateExtensionHeader();
        }

        private void updateExtensionHeader() {
            HttpFields headers = WebSocketUpgradeRequest.this.getHttpFields();
            headers.remove(HttpHeader.SEC_WEBSOCKET_EXTENSIONS);
            for (ExtensionConfig config : this.extensions) {
                headers.add(HttpHeader.SEC_WEBSOCKET_EXTENSIONS, config.getParameterizedName());
            }
        }

        @Override
        public void setHeader(String name, List<String> values2) {
            WebSocketUpgradeRequest.this.getHttpFields().put(name, values2);
        }

        @Override
        public void setHeader(String name, String value) {
            WebSocketUpgradeRequest.this.getHttpFields().put(name, value);
        }

        @Override
        public void setHeaders(Map<String, List<String>> headers) {
            for (Map.Entry<String, List<String>> entry : headers.entrySet()) {
                WebSocketUpgradeRequest.this.getHttpFields().put(entry.getKey(), entry.getValue());
            }
        }

        @Override
        public void setHttpVersion(String httpVersion) {
            WebSocketUpgradeRequest.this.version(HttpVersion.fromString(httpVersion));
        }

        @Override
        public void setMethod(String method) {
            WebSocketUpgradeRequest.this.method(method);
        }

        @Override
        public void setRequestURI(URI uri) {
            throw new UnsupportedOperationException("Cannot reset/change RequestURI");
        }

        @Override
        public void setSession(Object session) {
            this.session = session;
        }

        @Override
        public void setSubProtocols(List<String> protocols) {
            this.subProtocols = protocols;
        }

        @Override
        public void setSubProtocols(String ... protocols) {
            this.subProtocols.clear();
            this.subProtocols.addAll(Arrays.asList(protocols));
        }

        @Override
        public List<HttpCookie> getCookies() {
            return WebSocketUpgradeRequest.this.getCookies();
        }

        @Override
        public Map<String, List<String>> getHeaders() {
            TreeMap<String, List<String>> headersMap = new TreeMap<String, List<String>>(String.CASE_INSENSITIVE_ORDER);
            HttpFields fields = WebSocketUpgradeRequest.this.getHttpFields();
            for (String name : fields.getFieldNamesCollection()) {
                headersMap.put(name, fields.getValuesList(name));
            }
            return headersMap;
        }

        @Override
        public String getHost() {
            return WebSocketUpgradeRequest.this.getHost();
        }

        @Override
        public String getMethod() {
            return WebSocketUpgradeRequest.this.getMethod();
        }
    }
}

