/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hudi.org.apache.jetty.websocket.common.extensions;

import io.hops.hudi.org.apache.jetty.io.ByteBufferPool;
import io.hops.hudi.org.apache.jetty.util.annotation.ManagedAttribute;
import io.hops.hudi.org.apache.jetty.util.annotation.ManagedObject;
import io.hops.hudi.org.apache.jetty.util.component.AbstractLifeCycle;
import io.hops.hudi.org.apache.jetty.util.log.Log;
import io.hops.hudi.org.apache.jetty.util.log.Logger;
import io.hops.hudi.org.apache.jetty.websocket.api.BatchMode;
import io.hops.hudi.org.apache.jetty.websocket.api.WebSocketPolicy;
import io.hops.hudi.org.apache.jetty.websocket.api.WriteCallback;
import io.hops.hudi.org.apache.jetty.websocket.api.extensions.Extension;
import io.hops.hudi.org.apache.jetty.websocket.api.extensions.ExtensionConfig;
import io.hops.hudi.org.apache.jetty.websocket.api.extensions.Frame;
import io.hops.hudi.org.apache.jetty.websocket.api.extensions.IncomingFrames;
import io.hops.hudi.org.apache.jetty.websocket.api.extensions.OutgoingFrames;
import io.hops.hudi.org.apache.jetty.websocket.common.LogicalConnection;
import io.hops.hudi.org.apache.jetty.websocket.common.scopes.WebSocketContainerScope;

@ManagedObject(value="Abstract Extension")
public abstract class AbstractExtension
extends AbstractLifeCycle
implements Extension {
    private final Logger log = Log.getLogger(this.getClass());
    private WebSocketPolicy policy;
    private ByteBufferPool bufferPool;
    private ExtensionConfig config;
    private LogicalConnection connection;
    private OutgoingFrames nextOutgoing;
    private IncomingFrames nextIncoming;

    @Deprecated
    public void init(WebSocketContainerScope container) {
        this.init(container.getPolicy(), container.getBufferPool());
    }

    public void init(WebSocketPolicy policy, ByteBufferPool bufferPool) {
        this.policy = policy;
        this.bufferPool = bufferPool;
    }

    public ByteBufferPool getBufferPool() {
        return this.bufferPool;
    }

    @Override
    public ExtensionConfig getConfig() {
        return this.config;
    }

    public LogicalConnection getConnection() {
        return this.connection;
    }

    @Override
    public String getName() {
        return this.config.getName();
    }

    @ManagedAttribute(name="Next Incoming Frame Handler", readonly=true)
    public IncomingFrames getNextIncoming() {
        return this.nextIncoming;
    }

    @ManagedAttribute(name="Next Outgoing Frame Handler", readonly=true)
    public OutgoingFrames getNextOutgoing() {
        return this.nextOutgoing;
    }

    public WebSocketPolicy getPolicy() {
        return this.policy;
    }

    @Override
    public boolean isRsv1User() {
        return false;
    }

    @Override
    public boolean isRsv2User() {
        return false;
    }

    @Override
    public boolean isRsv3User() {
        return false;
    }

    protected void nextIncomingFrame(Frame frame) {
        this.log.debug("nextIncomingFrame({})", frame);
        this.nextIncoming.incomingFrame(frame);
    }

    protected void nextOutgoingFrame(Frame frame, WriteCallback callback, BatchMode batchMode) {
        try {
            this.log.debug("nextOutgoingFrame({})", frame);
            this.nextOutgoing.outgoingFrame(frame, callback, batchMode);
        }
        catch (Throwable t) {
            if (callback != null) {
                callback.writeFailed(t);
            }
            this.log.warn(t);
        }
    }

    public void setBufferPool(ByteBufferPool bufferPool) {
        this.bufferPool = bufferPool;
    }

    public void setConfig(ExtensionConfig config) {
        this.config = config;
    }

    public void setConnection(LogicalConnection connection) {
        this.connection = connection;
    }

    @Override
    public void setNextIncomingFrames(IncomingFrames nextIncoming) {
        this.nextIncoming = nextIncoming;
    }

    @Override
    public void setNextOutgoingFrames(OutgoingFrames nextOutgoing) {
        this.nextOutgoing = nextOutgoing;
    }

    public void setPolicy(WebSocketPolicy policy) {
        this.policy = policy;
    }

    @Override
    public String toString() {
        return String.format("%s[%s]", this.getClass().getSimpleName(), this.config.getParameterizedName());
    }
}

