/*
 * Decompiled with CFR 0.152.
 */
package io.javalin.json;

import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.javalin.core.util.OptionalDependency;
import io.javalin.core.util.Util;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0004H\u0007J\b\u0010\b\u001a\u00020\u0004H\u0002J'\u0010\t\u001a\u0002H\n\"\u0004\b\u0000\u0010\n2\u0006\u0010\u000b\u001a\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u0002H\n0\u000e\u00a2\u0006\u0002\u0010\u000fJ\b\u0010\u0010\u001a\u00020\u0004H\u0007J\u000e\u0010\u0011\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\u0001R\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lio/javalin/json/JavalinJackson;", "", "()V", "objectMapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "configure", "", "staticObjectMapper", "createObjectMapper", "fromJson", "T", "json", "", "clazz", "Ljava/lang/Class;", "(Ljava/lang/String;Ljava/lang/Class;)Ljava/lang/Object;", "getObjectMapper", "toJson", "object", "javalin"})
public final class JavalinJackson {
    private static ObjectMapper objectMapper;
    public static final JavalinJackson INSTANCE;

    @JvmStatic
    public static final void configure(@NotNull ObjectMapper staticObjectMapper) {
        Intrinsics.checkParameterIsNotNull(staticObjectMapper, "staticObjectMapper");
        objectMapper = staticObjectMapper;
    }

    @JvmStatic
    @NotNull
    public static final ObjectMapper getObjectMapper() {
        ObjectMapper objectMapper = JavalinJackson.objectMapper;
        if (objectMapper == null) {
            objectMapper = INSTANCE.createObjectMapper();
        }
        ObjectMapper objectMapper2 = JavalinJackson.objectMapper = objectMapper;
        if (objectMapper2 == null) {
            Intrinsics.throwNpe();
        }
        return objectMapper2;
    }

    @NotNull
    public final String toJson(@NotNull Object object) {
        Intrinsics.checkParameterIsNotNull(object, "object");
        Util.INSTANCE.ensureDependencyPresent(OptionalDependency.JACKSON);
        String string = JavalinJackson.getObjectMapper().writeValueAsString(object);
        Intrinsics.checkExpressionValueIsNotNull(string, "getObjectMapper().writeValueAsString(`object`)");
        return string;
    }

    public final <T> T fromJson(@NotNull String json2, @NotNull Class<T> clazz) {
        Intrinsics.checkParameterIsNotNull(json2, "json");
        Intrinsics.checkParameterIsNotNull(clazz, "clazz");
        Util.INSTANCE.ensureDependencyPresent(OptionalDependency.JACKSON);
        if (Util.INSTANCE.isKotlinClass(clazz)) {
            Util.INSTANCE.ensureDependencyPresent(OptionalDependency.JACKSON_KT);
        }
        return JavalinJackson.getObjectMapper().readValue(json2, clazz);
    }

    private final ObjectMapper createObjectMapper() {
        ObjectMapper objectMapper;
        try {
            String className = OptionalDependency.JACKSON_KT.getTestClass();
            Object obj = Class.forName(className).getConstructor(new Class[0]).newInstance(new Object[0]);
            if (obj == null) {
                throw new TypeCastException("null cannot be cast to non-null type com.fasterxml.jackson.databind.Module");
            }
            ObjectMapper objectMapper2 = new ObjectMapper().registerModule((Module)obj);
            Intrinsics.checkExpressionValueIsNotNull(objectMapper2, "ObjectMapper().registerM\u2026.newInstance() as Module)");
            objectMapper = objectMapper2;
        }
        catch (ClassNotFoundException e) {
            objectMapper = new ObjectMapper();
        }
        return objectMapper;
    }

    private JavalinJackson() {
    }

    static {
        JavalinJackson javalinJackson;
        INSTANCE = javalinJackson = new JavalinJackson();
    }
}

