/*
 * Decompiled with CFR 0.152.
 */
package io.javalin.websocket;

import io.hops.hudi.org.apache.jetty.websocket.api.Session;
import io.hops.hudi.org.apache.jetty.websocket.api.UpgradeRequest;
import io.hops.hudi.org.apache.jetty.websocket.api.annotations.OnWebSocketClose;
import io.hops.hudi.org.apache.jetty.websocket.api.annotations.OnWebSocketConnect;
import io.hops.hudi.org.apache.jetty.websocket.api.annotations.OnWebSocketError;
import io.hops.hudi.org.apache.jetty.websocket.api.annotations.OnWebSocketMessage;
import io.hops.hudi.org.apache.jetty.websocket.api.annotations.WebSocket;
import io.javalin.websocket.BinaryMessageHandler;
import io.javalin.websocket.CloseHandler;
import io.javalin.websocket.ConnectHandler;
import io.javalin.websocket.ErrorHandler;
import io.javalin.websocket.MessageHandler;
import io.javalin.websocket.WsEntry;
import io.javalin.websocket.WsHandler;
import io.javalin.websocket.WsSession;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@WebSocket
@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010$\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010\u0003\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u000bJ\u0010\u0010\u0017\u001a\u00020\u00152\u0006\u0010\u0018\u001a\u00020\u0005H\u0002J\u0012\u0010\u0019\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0018\u001a\u00020\u0005H\u0002J\u0010\u0010\u0019\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u001a\u001a\u00020\u001bJ(\u0010\u001c\u001a\u00020\u00152\u0006\u0010\u0018\u001a\u00020\u00052\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020 H\u0007J\"\u0010\"\u001a\u00020\u00152\u0006\u0010\u0018\u001a\u00020\u00052\u0006\u0010#\u001a\u00020 2\b\u0010$\u001a\u0004\u0018\u00010\u0006H\u0007J\u0010\u0010%\u001a\u00020\u00152\u0006\u0010\u0018\u001a\u00020\u0005H\u0007J\u001a\u0010&\u001a\u00020\u00152\u0006\u0010\u0018\u001a\u00020\u00052\b\u0010'\u001a\u0004\u0018\u00010(H\u0007J\u0018\u0010)\u001a\u00020\u00152\u0006\u0010\u0018\u001a\u00020\u00052\u0006\u0010*\u001a\u00020\u0006H\u0007J\u0018\u0010+\u001a\u00020,2\u0006\u0010\u0018\u001a\u00020\u00052\u0006\u0010\u0016\u001a\u00020\u000bH\u0002R\u001a\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R&\u0010\u0007\u001a\u001a\u0012\u0004\u0012\u00020\u0005\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\b0\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u001c\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013\u00a8\u0006-"}, d2={"Lio/javalin/websocket/WsPathMatcher;", "", "()V", "sessionIds", "Ljava/util/concurrent/ConcurrentHashMap;", "Lio/hops/hudi/org/apache/jetty/websocket/api/Session;", "", "sessionPathParams", "", "wsEntries", "", "Lio/javalin/websocket/WsEntry;", "getWsEntries", "()Ljava/util/List;", "wsLogger", "Lio/javalin/websocket/WsHandler;", "getWsLogger", "()Lio/javalin/websocket/WsHandler;", "setWsLogger", "(Lio/javalin/websocket/WsHandler;)V", "add", "", "wsEntry", "destroy", "session", "findEntry", "req", "Lio/hops/hudi/org/apache/jetty/websocket/api/UpgradeRequest;", "webSocketBinaryMessage", "buffer", "", "offset", "", "length", "webSocketClose", "statusCode", "reason", "webSocketConnect", "webSocketError", "throwable", "", "webSocketMessage", "message", "wrap", "Lio/javalin/websocket/WsSession;", "javalin"})
public final class WsPathMatcher {
    @NotNull
    private final List<WsEntry> wsEntries;
    @Nullable
    private WsHandler wsLogger;
    private final ConcurrentHashMap<Session, String> sessionIds;
    private final ConcurrentHashMap<Session, Map<String, String>> sessionPathParams;

    @NotNull
    public final List<WsEntry> getWsEntries() {
        return this.wsEntries;
    }

    @Nullable
    public final WsHandler getWsLogger() {
        return this.wsLogger;
    }

    public final void setWsLogger(@Nullable WsHandler wsHandler) {
        this.wsLogger = wsHandler;
    }

    public final void add(@NotNull WsEntry wsEntry) {
        Intrinsics.checkParameterIsNotNull(wsEntry, "wsEntry");
        if (!wsEntry.getCaseSensitiveUrls()) {
            String string = wsEntry.getPath();
            String string2 = wsEntry.getPath();
            String string3 = string;
            if (string3 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            String string4 = string3.toLowerCase();
            Intrinsics.checkExpressionValueIsNotNull(string4, "(this as java.lang.String).toLowerCase()");
            String string5 = string4;
            if (Intrinsics.areEqual(string2, string5) ^ true) {
                throw (Throwable)new IllegalArgumentException("By default URLs must be lowercase. Change casing or call `app.enableCaseSensitiveUrls()` to allow mixed casing.");
            }
        }
        this.wsEntries.add(wsEntry);
    }

    @OnWebSocketConnect
    public final void webSocketConnect(@NotNull Session session) {
        block2: {
            Object object;
            WsEntry wsEntry;
            Intrinsics.checkParameterIsNotNull(session, "session");
            WsEntry wsEntry2 = this.findEntry(session);
            if (wsEntry2 == null) break block2;
            WsEntry it = wsEntry = wsEntry2;
            WsSession wsSession = this.wrap(session, it);
            ConnectHandler connectHandler = it.getHandler().connectHandler;
            if (connectHandler != null) {
                connectHandler.handle(wsSession);
            }
            if ((object = this.wsLogger) != null && (object = ((WsHandler)object).connectHandler) != null) {
                object.handle(wsSession);
            }
        }
    }

    @OnWebSocketMessage
    public final void webSocketMessage(@NotNull Session session, @NotNull String message) {
        block2: {
            Object object;
            WsEntry wsEntry;
            Intrinsics.checkParameterIsNotNull(session, "session");
            Intrinsics.checkParameterIsNotNull(message, "message");
            WsEntry wsEntry2 = this.findEntry(session);
            if (wsEntry2 == null) break block2;
            WsEntry it = wsEntry = wsEntry2;
            WsSession wsSession = this.wrap(session, it);
            MessageHandler messageHandler = it.getHandler().messageHandler;
            if (messageHandler != null) {
                messageHandler.handle(wsSession, message);
            }
            if ((object = this.wsLogger) != null && (object = ((WsHandler)object).messageHandler) != null) {
                object.handle(wsSession, message);
            }
        }
    }

    @OnWebSocketMessage
    public final void webSocketBinaryMessage(@NotNull Session session, @NotNull byte[] buffer, int offset, int length) {
        block2: {
            Object object;
            WsEntry wsEntry;
            Intrinsics.checkParameterIsNotNull(session, "session");
            Intrinsics.checkParameterIsNotNull(buffer, "buffer");
            WsEntry wsEntry2 = this.findEntry(session);
            if (wsEntry2 == null) break block2;
            WsEntry it = wsEntry = wsEntry2;
            WsSession wsSession = this.wrap(session, it);
            BinaryMessageHandler binaryMessageHandler = it.getHandler().binaryMessageHandler;
            if (binaryMessageHandler != null) {
                binaryMessageHandler.handle(wsSession, ArraysKt.toTypedArray(buffer), offset, length);
            }
            if ((object = this.wsLogger) != null && (object = ((WsHandler)object).binaryMessageHandler) != null) {
                object.handle(wsSession, ArraysKt.toTypedArray(buffer), offset, length);
            }
        }
    }

    @OnWebSocketError
    public final void webSocketError(@NotNull Session session, @Nullable Throwable throwable) {
        block2: {
            Object object;
            WsEntry wsEntry;
            Intrinsics.checkParameterIsNotNull(session, "session");
            WsEntry wsEntry2 = this.findEntry(session);
            if (wsEntry2 == null) break block2;
            WsEntry it = wsEntry = wsEntry2;
            WsSession wsSession = this.wrap(session, it);
            ErrorHandler errorHandler = it.getHandler().errorHandler;
            if (errorHandler != null) {
                errorHandler.handle(wsSession, throwable);
            }
            if ((object = this.wsLogger) != null && (object = ((WsHandler)object).errorHandler) != null) {
                object.handle(wsSession, throwable);
            }
        }
    }

    @OnWebSocketClose
    public final void webSocketClose(@NotNull Session session, int statusCode, @Nullable String reason) {
        Intrinsics.checkParameterIsNotNull(session, "session");
        WsEntry wsEntry = this.findEntry(session);
        if (wsEntry != null) {
            Object object;
            WsEntry wsEntry2;
            WsEntry it = wsEntry2 = wsEntry;
            WsSession wsSession = this.wrap(session, it);
            CloseHandler closeHandler = it.getHandler().closeHandler;
            if (closeHandler != null) {
                closeHandler.handle(wsSession, statusCode, reason);
            }
            if ((object = this.wsLogger) != null && (object = ((WsHandler)object).closeHandler) != null) {
                object.handle(wsSession, statusCode, reason);
            }
        }
        this.destroy(session);
    }

    private final WsEntry findEntry(Session session) {
        UpgradeRequest upgradeRequest = session.getUpgradeRequest();
        Intrinsics.checkExpressionValueIsNotNull(upgradeRequest, "session.upgradeRequest");
        return this.findEntry(upgradeRequest);
    }

    @Nullable
    public final WsEntry findEntry(@NotNull UpgradeRequest req) {
        Object v2;
        block1: {
            Iterable iterable;
            Intrinsics.checkParameterIsNotNull(req, "req");
            Iterable iterable2 = iterable = (Iterable)this.wsEntries;
            for (Object t : iterable2) {
                WsEntry it = (WsEntry)t;
                URI uRI = req.getRequestURI();
                Intrinsics.checkExpressionValueIsNotNull(uRI, "req.requestURI");
                String string = uRI.getPath();
                Intrinsics.checkExpressionValueIsNotNull(string, "req.requestURI.path");
                if (!it.matches(string)) continue;
                v2 = t;
                break block1;
            }
            v2 = null;
        }
        return v2;
    }

    private final WsSession wrap(Session session, WsEntry wsEntry) {
        this.sessionIds.putIfAbsent(session, UUID.randomUUID().toString());
        UpgradeRequest upgradeRequest = session.getUpgradeRequest();
        Intrinsics.checkExpressionValueIsNotNull(upgradeRequest, "session.upgradeRequest");
        URI uRI = upgradeRequest.getRequestURI();
        Intrinsics.checkExpressionValueIsNotNull(uRI, "session.upgradeRequest.requestURI");
        String string = uRI.getPath();
        Intrinsics.checkExpressionValueIsNotNull(string, "session.upgradeRequest.requestURI.path");
        this.sessionPathParams.putIfAbsent(session, wsEntry.extractPathParams(string));
        String string2 = this.sessionIds.get(session);
        if (string2 == null) {
            Intrinsics.throwNpe();
        }
        Intrinsics.checkExpressionValueIsNotNull(string2, "sessionIds[session]!!");
        Map<String, String> map = this.sessionPathParams.get(session);
        if (map == null) {
            Intrinsics.throwNpe();
        }
        Intrinsics.checkExpressionValueIsNotNull(map, "sessionPathParams[session]!!");
        return new WsSession(string2, session, map, wsEntry.getPath());
    }

    private final void destroy(Session session) {
        this.sessionIds.remove(session);
        this.sessionPathParams.remove(session);
    }

    public WsPathMatcher() {
        List list;
        WsPathMatcher wsPathMatcher = this;
        wsPathMatcher.wsEntries = list = (List)new ArrayList();
        this.sessionIds = new ConcurrentHashMap();
        this.sessionPathParams = new ConcurrentHashMap();
    }
}

