/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.codec;

import com.google.common.io.CountingInputStream;
import com.google.common.io.CountingOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellComparator;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.Tag;
import org.apache.hadoop.hbase.codec.Codec;
import org.apache.hadoop.hbase.codec.KeyValueCodecWithTags;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={SmallTests.class})
public class TestKeyValueCodecWithTags {
    @Test
    public void testKeyValueWithTag() throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        CountingOutputStream cos = new CountingOutputStream((OutputStream)baos);
        DataOutputStream dos = new DataOutputStream((OutputStream)cos);
        KeyValueCodecWithTags codec = new KeyValueCodecWithTags();
        Codec.Encoder encoder = codec.getEncoder(dos);
        KeyValue kv1 = new KeyValue(Bytes.toBytes("r"), Bytes.toBytes("f"), Bytes.toBytes("1"), Long.MAX_VALUE, Bytes.toBytes("1"), new Tag[]{new Tag(1, Bytes.toBytes("teststring1")), new Tag(2, Bytes.toBytes("teststring2"))});
        KeyValue kv2 = new KeyValue(Bytes.toBytes("r"), Bytes.toBytes("f"), Bytes.toBytes("2"), Long.MAX_VALUE, Bytes.toBytes("2"), new Tag[]{new Tag(1, Bytes.toBytes("teststring3"))});
        KeyValue kv3 = new KeyValue(Bytes.toBytes("r"), Bytes.toBytes("f"), Bytes.toBytes("3"), Long.MAX_VALUE, Bytes.toBytes("3"), new Tag[]{new Tag(2, Bytes.toBytes("teststring4")), new Tag(2, Bytes.toBytes("teststring5")), new Tag(1, Bytes.toBytes("teststring6"))});
        encoder.write(kv1);
        encoder.write(kv2);
        encoder.write(kv3);
        encoder.flush();
        dos.close();
        long offset = cos.getCount();
        CountingInputStream cis = new CountingInputStream((InputStream)new ByteArrayInputStream(baos.toByteArray()));
        DataInputStream dis = new DataInputStream((InputStream)cis);
        Codec.Decoder decoder2 = codec.getDecoder(dis);
        Assert.assertTrue((boolean)decoder2.advance());
        Cell c = decoder2.current();
        Assert.assertTrue((boolean)CellComparator.equals(c, kv1));
        List<Tag> tags = Tag.asList(c.getTagsArray(), c.getTagsOffset(), c.getTagsLength());
        Assert.assertEquals((long)2L, (long)tags.size());
        Tag tag = tags.get(0);
        Assert.assertEquals((long)1L, (long)tag.getType());
        Assert.assertTrue((boolean)Bytes.equals(Bytes.toBytes("teststring1"), tag.getValue()));
        tag = tags.get(1);
        Assert.assertEquals((long)2L, (long)tag.getType());
        Assert.assertTrue((boolean)Bytes.equals(Bytes.toBytes("teststring2"), tag.getValue()));
        Assert.assertTrue((boolean)decoder2.advance());
        c = decoder2.current();
        Assert.assertTrue((boolean)CellComparator.equals(c, kv2));
        tags = Tag.asList(c.getTagsArray(), c.getTagsOffset(), c.getTagsLength());
        Assert.assertEquals((long)1L, (long)tags.size());
        tag = tags.get(0);
        Assert.assertEquals((long)1L, (long)tag.getType());
        Assert.assertTrue((boolean)Bytes.equals(Bytes.toBytes("teststring3"), tag.getValue()));
        Assert.assertTrue((boolean)decoder2.advance());
        c = decoder2.current();
        Assert.assertTrue((boolean)CellComparator.equals(c, kv3));
        tags = Tag.asList(c.getTagsArray(), c.getTagsOffset(), c.getTagsLength());
        Assert.assertEquals((long)3L, (long)tags.size());
        tag = tags.get(0);
        Assert.assertEquals((long)2L, (long)tag.getType());
        Assert.assertTrue((boolean)Bytes.equals(Bytes.toBytes("teststring4"), tag.getValue()));
        tag = tags.get(1);
        Assert.assertEquals((long)2L, (long)tag.getType());
        Assert.assertTrue((boolean)Bytes.equals(Bytes.toBytes("teststring5"), tag.getValue()));
        tag = tags.get(2);
        Assert.assertEquals((long)1L, (long)tag.getType());
        Assert.assertTrue((boolean)Bytes.equals(Bytes.toBytes("teststring6"), tag.getValue()));
        Assert.assertFalse((boolean)decoder2.advance());
        dis.close();
        Assert.assertEquals((long)offset, (long)cis.getCount());
    }
}

