/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.filter;

import com.google.common.base.Preconditions;
import com.google.protobuf.InvalidProtocolBufferException;
import java.util.ArrayList;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.KeyValueUtil;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.classification.InterfaceStability;
import org.apache.hadoop.hbase.exceptions.DeserializationException;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.filter.FilterBase;
import org.apache.hadoop.hbase.filter.ParseFilter;
import org.apache.hadoop.hbase.protobuf.generated.FilterProtos;
import org.apache.hadoop.hbase.util.ByteStringer;
import org.apache.hadoop.hbase.util.Bytes;

@InterfaceAudience.Public
@InterfaceStability.Stable
public class ColumnRangeFilter
extends FilterBase {
    protected byte[] minColumn = null;
    protected boolean minColumnInclusive = true;
    protected byte[] maxColumn = null;
    protected boolean maxColumnInclusive = false;

    public ColumnRangeFilter(byte[] minColumn, boolean minColumnInclusive, byte[] maxColumn, boolean maxColumnInclusive) {
        this.minColumn = minColumn;
        this.minColumnInclusive = minColumnInclusive;
        this.maxColumn = maxColumn;
        this.maxColumnInclusive = maxColumnInclusive;
    }

    public boolean isMinColumnInclusive() {
        return this.minColumnInclusive;
    }

    public boolean isMaxColumnInclusive() {
        return this.maxColumnInclusive;
    }

    public byte[] getMinColumn() {
        return this.minColumn;
    }

    public boolean getMinColumnInclusive() {
        return this.minColumnInclusive;
    }

    public byte[] getMaxColumn() {
        return this.maxColumn;
    }

    public boolean getMaxColumnInclusive() {
        return this.maxColumnInclusive;
    }

    @Override
    public Filter.ReturnCode filterKeyValue(Cell kv) {
        byte[] buffer = kv.getQualifierArray();
        int qualifierOffset = kv.getQualifierOffset();
        int qualifierLength = kv.getQualifierLength();
        int cmpMin = 1;
        if (this.minColumn != null) {
            cmpMin = Bytes.compareTo(buffer, qualifierOffset, qualifierLength, this.minColumn, 0, this.minColumn.length);
        }
        if (cmpMin < 0) {
            return Filter.ReturnCode.SEEK_NEXT_USING_HINT;
        }
        if (!this.minColumnInclusive && cmpMin == 0) {
            return Filter.ReturnCode.NEXT_COL;
        }
        if (this.maxColumn == null) {
            return Filter.ReturnCode.INCLUDE;
        }
        int cmpMax = Bytes.compareTo(buffer, qualifierOffset, qualifierLength, this.maxColumn, 0, this.maxColumn.length);
        if (this.maxColumnInclusive && cmpMax <= 0 || !this.maxColumnInclusive && cmpMax < 0) {
            return Filter.ReturnCode.INCLUDE;
        }
        return Filter.ReturnCode.NEXT_ROW;
    }

    @Override
    public Cell transformCell(Cell v) {
        return v;
    }

    public static Filter createFilterFromArguments(ArrayList<byte[]> filterArguments) {
        Preconditions.checkArgument((filterArguments.size() == 4 ? 1 : 0) != 0, (String)"Expected 4 but got: %s", (Object[])new Object[]{filterArguments.size()});
        byte[] minColumn = ParseFilter.removeQuotesFromByteArray(filterArguments.get(0));
        boolean minColumnInclusive = ParseFilter.convertByteArrayToBoolean(filterArguments.get(1));
        byte[] maxColumn = ParseFilter.removeQuotesFromByteArray(filterArguments.get(2));
        boolean maxColumnInclusive = ParseFilter.convertByteArrayToBoolean(filterArguments.get(3));
        if (minColumn.length == 0) {
            minColumn = null;
        }
        if (maxColumn.length == 0) {
            maxColumn = null;
        }
        return new ColumnRangeFilter(minColumn, minColumnInclusive, maxColumn, maxColumnInclusive);
    }

    @Override
    public byte[] toByteArray() {
        FilterProtos.ColumnRangeFilter.Builder builder = FilterProtos.ColumnRangeFilter.newBuilder();
        if (this.minColumn != null) {
            builder.setMinColumn(ByteStringer.wrap(this.minColumn));
        }
        builder.setMinColumnInclusive(this.minColumnInclusive);
        if (this.maxColumn != null) {
            builder.setMaxColumn(ByteStringer.wrap(this.maxColumn));
        }
        builder.setMaxColumnInclusive(this.maxColumnInclusive);
        return builder.build().toByteArray();
    }

    public static ColumnRangeFilter parseFrom(byte[] pbBytes) throws DeserializationException {
        FilterProtos.ColumnRangeFilter proto;
        try {
            proto = FilterProtos.ColumnRangeFilter.parseFrom(pbBytes);
        }
        catch (InvalidProtocolBufferException e) {
            throw new DeserializationException(e);
        }
        return new ColumnRangeFilter(proto.hasMinColumn() ? proto.getMinColumn().toByteArray() : null, proto.getMinColumnInclusive(), proto.hasMaxColumn() ? proto.getMaxColumn().toByteArray() : null, proto.getMaxColumnInclusive());
    }

    @Override
    boolean areSerializedFieldsEqual(Filter o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ColumnRangeFilter)) {
            return false;
        }
        ColumnRangeFilter other = (ColumnRangeFilter)o;
        return Bytes.equals(this.getMinColumn(), other.getMinColumn()) && this.getMinColumnInclusive() == other.getMinColumnInclusive() && Bytes.equals(this.getMaxColumn(), other.getMaxColumn()) && this.getMaxColumnInclusive() == other.getMaxColumnInclusive();
    }

    @Override
    public Cell getNextCellHint(Cell kv) {
        return KeyValueUtil.createFirstOnRow(kv.getRowArray(), kv.getRowOffset(), kv.getRowLength(), kv.getFamilyArray(), kv.getFamilyOffset(), kv.getFamilyLength(), this.minColumn, 0, Bytes.len(this.minColumn));
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + " " + (this.minColumnInclusive ? "[" : "(") + Bytes.toStringBinary(this.minColumn) + ", " + Bytes.toStringBinary(this.maxColumn) + (this.maxColumnInclusive ? "]" : ")");
    }
}

