/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.fs;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.TimeoutException;
import java.util.stream.Collectors;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hudi.common.fs.ConsistencyGuard;
import org.apache.hudi.common.fs.ConsistencyGuardConfig;
import org.apache.hudi.common.util.ValidationUtils;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

public class FailSafeConsistencyGuard
implements ConsistencyGuard {
    private static final Logger LOG = LogManager.getLogger(FailSafeConsistencyGuard.class);
    protected final FileSystem fs;
    protected final ConsistencyGuardConfig consistencyGuardConfig;

    public FailSafeConsistencyGuard(FileSystem fs, ConsistencyGuardConfig consistencyGuardConfig) {
        this.fs = fs;
        this.consistencyGuardConfig = consistencyGuardConfig;
        ValidationUtils.checkArgument(consistencyGuardConfig.isConsistencyCheckEnabled());
    }

    @Override
    public void waitTillFileAppears(Path filePath) throws TimeoutException {
        this.waitForFileVisibility(filePath, ConsistencyGuard.FileVisibility.APPEAR);
    }

    @Override
    public void waitTillFileDisappears(Path filePath) throws TimeoutException {
        this.waitForFileVisibility(filePath, ConsistencyGuard.FileVisibility.DISAPPEAR);
    }

    @Override
    public void waitTillAllFilesAppear(String dirPath, List<String> files) throws TimeoutException {
        this.waitForFilesVisibility(dirPath, files, ConsistencyGuard.FileVisibility.APPEAR);
    }

    @Override
    public void waitTillAllFilesDisappear(String dirPath, List<String> files) throws TimeoutException {
        this.waitForFilesVisibility(dirPath, files, ConsistencyGuard.FileVisibility.DISAPPEAR);
    }

    public void waitForFilesVisibility(String dirPath, List<String> files, ConsistencyGuard.FileVisibility event) throws TimeoutException {
        Path dir = new Path(dirPath);
        List<String> filesWithoutSchemeAndAuthority = this.getFilesWithoutSchemeAndAuthority(files);
        this.retryTillSuccess(dir, filesWithoutSchemeAndAuthority, event);
    }

    protected boolean checkFileVisibility(Path filePath, ConsistencyGuard.FileVisibility visibility) throws IOException {
        try {
            FileStatus status = this.fs.getFileStatus(filePath);
            switch (visibility) {
                case APPEAR: {
                    return status != null;
                }
            }
            return status == null;
        }
        catch (FileNotFoundException nfe) {
            switch (visibility) {
                case APPEAR: {
                    return false;
                }
            }
            return true;
        }
    }

    private void waitForFileVisibility(Path filePath, ConsistencyGuard.FileVisibility visibility) throws TimeoutException {
        long waitMs = this.consistencyGuardConfig.getInitialConsistencyCheckIntervalMs();
        for (int attempt = 0; attempt < this.consistencyGuardConfig.getMaxConsistencyChecks(); ++attempt) {
            try {
                if (this.checkFileVisibility(filePath, visibility)) {
                    return;
                }
            }
            catch (IOException ioe) {
                LOG.warn("Got IOException waiting for file visibility. Retrying", ioe);
            }
            this.sleepSafe(waitMs);
            waitMs *= 2L;
            waitMs = Math.min(waitMs, (long)this.consistencyGuardConfig.getMaxConsistencyCheckIntervalMs());
        }
        throw new TimeoutException("Timed-out waiting for the file to " + visibility.name());
    }

    private void retryTillSuccess(Path dir, List<String> files, ConsistencyGuard.FileVisibility event) throws TimeoutException {
        long waitMs = this.consistencyGuardConfig.getInitialConsistencyCheckIntervalMs();
        LOG.info("Max Attempts=" + this.consistencyGuardConfig.getMaxConsistencyChecks());
        for (int attempt = 0; attempt < this.consistencyGuardConfig.getMaxConsistencyChecks(); ++attempt) {
            boolean success = this.checkFilesVisibility(attempt, dir, files, event);
            if (success) {
                return;
            }
            this.sleepSafe(waitMs);
            waitMs *= 2L;
            waitMs = Math.min(waitMs, (long)this.consistencyGuardConfig.getMaxConsistencyCheckIntervalMs());
        }
        throw new TimeoutException("Timed out waiting for files to adhere to event " + event.name());
    }

    protected boolean checkFilesVisibility(int retryNum, Path dir, List<String> files, ConsistencyGuard.FileVisibility event) {
        try {
            LOG.info("Trying " + retryNum);
            FileStatus[] entries = this.fs.listStatus(dir);
            List gotFiles = Arrays.stream(entries).map(e -> Path.getPathWithoutSchemeAndAuthority((Path)e.getPath())).map(Path::toString).collect(Collectors.toList());
            ArrayList<String> candidateFiles = new ArrayList<String>(files);
            boolean altered = candidateFiles.removeAll(gotFiles);
            switch (event) {
                case DISAPPEAR: {
                    LOG.info("Following files are visible" + candidateFiles);
                    return !altered;
                }
            }
            return candidateFiles.isEmpty();
        }
        catch (IOException ioe) {
            LOG.warn("Got IOException waiting for file event. Have tried " + retryNum + " time(s)", ioe);
            return false;
        }
    }

    protected List<String> getFilesWithoutSchemeAndAuthority(List<String> files) {
        return files.stream().map(f -> Path.getPathWithoutSchemeAndAuthority((Path)new Path(f))).map(Path::toString).collect(Collectors.toList());
    }

    private void sleepSafe(long waitMs) {
        try {
            Thread.sleep(waitMs);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }
}

