/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.fs.inline;

import org.apache.hadoop.fs.Path;

public class InLineFSUtils {
    private static final String START_OFFSET_STR = "start_offset";
    private static final String LENGTH_STR = "length";
    private static final String EQUALS_STR = "=";

    public static Path getInlineFilePath(Path outerPath, String origScheme, long inLineStartOffset, long inLineLength) {
        String subPath = outerPath.toString().substring(outerPath.toString().indexOf(":") + 1);
        return new Path("inlinefs://" + subPath + "/" + origScheme + "/?" + START_OFFSET_STR + EQUALS_STR + inLineStartOffset + "&" + LENGTH_STR + EQUALS_STR + inLineLength);
    }

    public static Path getOuterfilePathFromInlinePath(Path inlinePath) {
        String scheme = inlinePath.getParent().getName();
        Path basePath = inlinePath.getParent().getParent();
        return new Path(basePath.toString().replaceFirst("inlinefs", scheme));
    }

    public static int startOffset(Path inlinePath) {
        String[] slices = inlinePath.toString().split("[?&=]");
        return Integer.parseInt(slices[slices.length - 3]);
    }

    public static int length(Path inlinePath) {
        String[] slices = inlinePath.toString().split("[?&=]");
        return Integer.parseInt(slices[slices.length - 1]);
    }
}

