/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.table;

import java.util.Arrays;
import org.apache.hudi.exception.HoodieException;

public enum HoodieTableVersion {
    ZERO(0),
    ONE(1);

    private final int versionCode;

    private HoodieTableVersion(int versionCode) {
        this.versionCode = versionCode;
    }

    public int versionCode() {
        return this.versionCode;
    }

    public static HoodieTableVersion current() {
        return ONE;
    }

    static HoodieTableVersion versionFromCode(int versionCode) {
        return Arrays.stream(HoodieTableVersion.values()).filter(v -> v.versionCode == versionCode).findAny().orElseThrow(() -> new HoodieException("Unknown versionCode:" + versionCode));
    }
}

