/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.timeline.service.handlers;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.hadoop.conf.Configuration;
import org.apache.hudi.common.model.CompactionOperation;
import org.apache.hudi.common.table.timeline.dto.CompactionOpDTO;
import org.apache.hudi.common.table.timeline.dto.FileGroupDTO;
import org.apache.hudi.common.table.timeline.dto.FileSliceDTO;
import org.apache.hudi.common.table.view.FileSystemViewManager;
import org.apache.hudi.timeline.service.handlers.Handler;

public class FileSliceHandler
extends Handler {
    public FileSliceHandler(Configuration conf, FileSystemViewManager viewManager) throws IOException {
        super(conf, viewManager);
    }

    public List<FileSliceDTO> getAllFileSlices(String basePath, String partitionPath) {
        return this.viewManager.getFileSystemView(basePath).getAllFileSlices(partitionPath).map(FileSliceDTO::fromFileSlice).collect(Collectors.toList());
    }

    public List<FileSliceDTO> getLatestFileSliceInRange(String basePath, List<String> instantsToReturn) {
        return this.viewManager.getFileSystemView(basePath).getLatestFileSliceInRange(instantsToReturn).map(FileSliceDTO::fromFileSlice).collect(Collectors.toList());
    }

    public List<FileSliceDTO> getLatestMergedFileSlicesBeforeOrOn(String basePath, String partitionPath, String maxInstantTime) {
        return this.viewManager.getFileSystemView(basePath).getLatestMergedFileSlicesBeforeOrOn(partitionPath, maxInstantTime).map(FileSliceDTO::fromFileSlice).collect(Collectors.toList());
    }

    public List<FileSliceDTO> getLatestFileSlicesBeforeOrOn(String basePath, String partitionPath, String maxInstantTime, boolean includeFileSlicesInPendingCompaction) {
        return this.viewManager.getFileSystemView(basePath).getLatestFileSlicesBeforeOrOn(partitionPath, maxInstantTime, includeFileSlicesInPendingCompaction).map(FileSliceDTO::fromFileSlice).collect(Collectors.toList());
    }

    public List<FileSliceDTO> getLatestUnCompactedFileSlices(String basePath, String partitionPath) {
        return this.viewManager.getFileSystemView(basePath).getLatestUnCompactedFileSlices(partitionPath).map(FileSliceDTO::fromFileSlice).collect(Collectors.toList());
    }

    public List<FileSliceDTO> getLatestFileSlices(String basePath, String partitionPath) {
        return this.viewManager.getFileSystemView(basePath).getLatestFileSlices(partitionPath).map(FileSliceDTO::fromFileSlice).collect(Collectors.toList());
    }

    public List<FileSliceDTO> getLatestFileSlice(String basePath, String partitionPath, String fileId) {
        return this.viewManager.getFileSystemView(basePath).getLatestFileSlice(partitionPath, fileId).map(FileSliceDTO::fromFileSlice).map(xva$0 -> Arrays.asList(xva$0)).orElse(new ArrayList());
    }

    public List<CompactionOpDTO> getPendingCompactionOperations(String basePath) {
        return this.viewManager.getFileSystemView(basePath).getPendingCompactionOperations().map(instantOp -> CompactionOpDTO.fromCompactionOperation((String)instantOp.getKey(), (CompactionOperation)instantOp.getValue())).collect(Collectors.toList());
    }

    public List<FileGroupDTO> getAllFileGroups(String basePath, String partitionPath) {
        return this.viewManager.getFileSystemView(basePath).getAllFileGroups(partitionPath).map(FileGroupDTO::fromFileGroup).collect(Collectors.toList());
    }

    public List<FileGroupDTO> getReplacedFileGroupsBeforeOrOn(String basePath, String maxCommitTime, String partitionPath) {
        return this.viewManager.getFileSystemView(basePath).getReplacedFileGroupsBeforeOrOn(maxCommitTime, partitionPath).map(FileGroupDTO::fromFileGroup).collect(Collectors.toList());
    }

    public boolean refreshTable(String basePath) {
        this.viewManager.clearFileSystemView(basePath);
        return true;
    }
}

