/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hudi.org.roaringbitmap.buffer;

import io.hops.hudi.org.roaringbitmap.Util;
import io.hops.hudi.org.roaringbitmap.buffer.BufferUtil;
import io.hops.hudi.org.roaringbitmap.buffer.ImmutableRoaringBitmap;
import io.hops.hudi.org.roaringbitmap.buffer.MappeableBitmapContainer;
import io.hops.hudi.org.roaringbitmap.buffer.MappeableContainer;
import io.hops.hudi.org.roaringbitmap.buffer.MappeableContainerPointer;
import io.hops.hudi.org.roaringbitmap.buffer.MutableRoaringArray;
import io.hops.hudi.org.roaringbitmap.buffer.MutableRoaringBitmap;
import java.nio.CharBuffer;
import java.nio.LongBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.PriorityQueue;

public final class BufferFastAggregation {
    public static MutableRoaringBitmap and(ImmutableRoaringBitmap ... bitmaps) {
        if (bitmaps.length > 10) {
            return BufferFastAggregation.workShyAnd(new long[1024], bitmaps);
        }
        return BufferFastAggregation.naive_and(bitmaps);
    }

    public static MutableRoaringBitmap and(long[] aggregationBuffer, ImmutableRoaringBitmap ... bitmaps) {
        if (bitmaps.length > 10) {
            if (aggregationBuffer.length < 1024) {
                throw new IllegalArgumentException("buffer should have at least 1024 elements.");
            }
            try {
                MutableRoaringBitmap mutableRoaringBitmap = BufferFastAggregation.workShyAnd(aggregationBuffer, bitmaps);
                return mutableRoaringBitmap;
            }
            finally {
                Arrays.fill(aggregationBuffer, 0L);
            }
        }
        return BufferFastAggregation.naive_and(bitmaps);
    }

    public static MutableRoaringBitmap and(Iterator<? extends ImmutableRoaringBitmap> bitmaps) {
        return BufferFastAggregation.and(new long[1024], bitmaps);
    }

    public static MutableRoaringBitmap and(long[] aggregationBuffer, Iterator<? extends ImmutableRoaringBitmap> bitmaps) {
        if (bitmaps.hasNext()) {
            try {
                MutableRoaringBitmap mutableRoaringBitmap = BufferFastAggregation.workShyAnd(aggregationBuffer, bitmaps);
                return mutableRoaringBitmap;
            }
            finally {
                Arrays.fill(aggregationBuffer, 0L);
            }
        }
        return new MutableRoaringBitmap();
    }

    public static MutableRoaringBitmap and(MutableRoaringBitmap ... bitmaps) {
        return BufferFastAggregation.and(BufferFastAggregation.convertToImmutable(bitmaps));
    }

    public static int andCardinality(ImmutableRoaringBitmap ... bitmaps) {
        switch (bitmaps.length) {
            case 0: {
                return 0;
            }
            case 1: {
                return bitmaps[0].getCardinality();
            }
            case 2: {
                return ImmutableRoaringBitmap.andCardinality(bitmaps[0], bitmaps[1]);
            }
        }
        return BufferFastAggregation.workShyAndCardinality(bitmaps);
    }

    public static int orCardinality(ImmutableRoaringBitmap ... bitmaps) {
        switch (bitmaps.length) {
            case 0: {
                return 0;
            }
            case 1: {
                return bitmaps[0].getCardinality();
            }
            case 2: {
                return ImmutableRoaringBitmap.orCardinality(bitmaps[0], bitmaps[1]);
            }
        }
        return BufferFastAggregation.horizontalOrCardinality(bitmaps);
    }

    public static Iterator<ImmutableRoaringBitmap> convertToImmutable(final Iterator<MutableRoaringBitmap> i) {
        return new Iterator<ImmutableRoaringBitmap>(){

            @Override
            public boolean hasNext() {
                return i.hasNext();
            }

            @Override
            public ImmutableRoaringBitmap next() {
                return (ImmutableRoaringBitmap)i.next();
            }

            @Override
            public void remove() {
            }
        };
    }

    private static ImmutableRoaringBitmap[] convertToImmutable(MutableRoaringBitmap[] array) {
        ImmutableRoaringBitmap[] answer = new ImmutableRoaringBitmap[array.length];
        System.arraycopy(array, 0, answer, 0, answer.length);
        return answer;
    }

    public static MutableRoaringBitmap horizontal_or(ImmutableRoaringBitmap ... bitmaps) {
        MutableRoaringBitmap answer = new MutableRoaringBitmap();
        if (bitmaps.length == 0) {
            return answer;
        }
        PriorityQueue<MappeableContainerPointer> pq = new PriorityQueue<MappeableContainerPointer>(bitmaps.length);
        for (int k = 0; k < bitmaps.length; ++k) {
            MappeableContainerPointer x = bitmaps[k].highLowContainer.getContainerPointer();
            if (x.getContainer() == null) continue;
            pq.add(x);
        }
        while (!pq.isEmpty()) {
            MappeableContainerPointer x1 = (MappeableContainerPointer)pq.poll();
            if (pq.isEmpty() || ((MappeableContainerPointer)pq.peek()).key() != x1.key()) {
                answer.getMappeableRoaringArray().append(x1.key(), x1.getContainer().clone());
                x1.advance();
                if (x1.getContainer() == null) continue;
                pq.add(x1);
                continue;
            }
            MappeableContainerPointer x2 = (MappeableContainerPointer)pq.poll();
            MappeableContainer newc = x1.getContainer().lazyOR(x2.getContainer());
            while (!pq.isEmpty() && ((MappeableContainerPointer)pq.peek()).key() == x1.key()) {
                MappeableContainerPointer x = (MappeableContainerPointer)pq.poll();
                newc = newc.lazyIOR(x.getContainer());
                x.advance();
                if (x.getContainer() != null) {
                    pq.add(x);
                    continue;
                }
                if (!pq.isEmpty()) continue;
                break;
            }
            newc = newc.repairAfterLazy();
            answer.getMappeableRoaringArray().append(x1.key(), newc);
            x1.advance();
            if (x1.getContainer() != null) {
                pq.add(x1);
            }
            x2.advance();
            if (x2.getContainer() == null) continue;
            pq.add(x2);
        }
        return answer;
    }

    @Deprecated
    public static MutableRoaringBitmap horizontal_or(Iterator bitmaps) {
        return BufferFastAggregation.naive_or(bitmaps);
    }

    public static MutableRoaringBitmap horizontal_or(MutableRoaringBitmap ... bitmaps) {
        return BufferFastAggregation.horizontal_or(BufferFastAggregation.convertToImmutable(bitmaps));
    }

    public static MutableRoaringBitmap horizontal_xor(ImmutableRoaringBitmap ... bitmaps) {
        MutableRoaringBitmap answer = new MutableRoaringBitmap();
        if (bitmaps.length == 0) {
            return answer;
        }
        PriorityQueue<MappeableContainerPointer> pq = new PriorityQueue<MappeableContainerPointer>(bitmaps.length);
        for (int k = 0; k < bitmaps.length; ++k) {
            MappeableContainerPointer x = bitmaps[k].highLowContainer.getContainerPointer();
            if (x.getContainer() == null) continue;
            pq.add(x);
        }
        while (!pq.isEmpty()) {
            MappeableContainerPointer x1 = (MappeableContainerPointer)pq.poll();
            if (pq.isEmpty() || ((MappeableContainerPointer)pq.peek()).key() != x1.key()) {
                answer.getMappeableRoaringArray().append(x1.key(), x1.getContainer().clone());
                x1.advance();
                if (x1.getContainer() == null) continue;
                pq.add(x1);
                continue;
            }
            MappeableContainerPointer x2 = (MappeableContainerPointer)pq.poll();
            MappeableContainer newc = x1.getContainer().xor(x2.getContainer());
            while (!pq.isEmpty() && ((MappeableContainerPointer)pq.peek()).key() == x1.key()) {
                MappeableContainerPointer x = (MappeableContainerPointer)pq.poll();
                newc = newc.ixor(x.getContainer());
                x.advance();
                if (x.getContainer() != null) {
                    pq.add(x);
                    continue;
                }
                if (!pq.isEmpty()) continue;
                break;
            }
            answer.getMappeableRoaringArray().append(x1.key(), newc);
            x1.advance();
            if (x1.getContainer() != null) {
                pq.add(x1);
            }
            x2.advance();
            if (x2.getContainer() == null) continue;
            pq.add(x2);
        }
        return answer;
    }

    public static MutableRoaringBitmap horizontal_xor(MutableRoaringBitmap ... bitmaps) {
        return BufferFastAggregation.horizontal_xor(BufferFastAggregation.convertToImmutable(bitmaps));
    }

    public static MutableRoaringBitmap naive_and(ImmutableRoaringBitmap ... bitmaps) {
        MutableRoaringBitmap answer;
        if (bitmaps.length > 0) {
            ImmutableRoaringBitmap smallest = bitmaps[0];
            for (int i = 1; i < bitmaps.length; ++i) {
                ImmutableRoaringBitmap bitmap = bitmaps[i];
                if (bitmap.highLowContainer.size() >= smallest.highLowContainer.size()) continue;
                smallest = bitmap;
            }
            answer = smallest.toMutableRoaringBitmap();
            for (ImmutableRoaringBitmap bitmap : bitmaps) {
                if (bitmap == smallest) continue;
                answer.and(bitmap);
            }
        } else {
            answer = new MutableRoaringBitmap();
        }
        return answer;
    }

    public static MutableRoaringBitmap naive_and(Iterator bitmaps) {
        if (!bitmaps.hasNext()) {
            return new MutableRoaringBitmap();
        }
        MutableRoaringBitmap answer = ((ImmutableRoaringBitmap)bitmaps.next()).toMutableRoaringBitmap();
        while (bitmaps.hasNext()) {
            answer.and((ImmutableRoaringBitmap)bitmaps.next());
        }
        return answer;
    }

    public static MutableRoaringBitmap naive_and(MutableRoaringBitmap ... bitmaps) {
        if (bitmaps.length == 0) {
            return new MutableRoaringBitmap();
        }
        MutableRoaringBitmap answer = bitmaps[0].clone();
        for (int k = 1; k < bitmaps.length; ++k) {
            answer.and(bitmaps[k]);
        }
        return answer;
    }

    static MutableRoaringBitmap workShyAnd(long[] aggregationBuffer, ImmutableRoaringBitmap ... bitmaps) {
        long[] words = aggregationBuffer;
        ImmutableRoaringBitmap first = bitmaps[0];
        for (int i = 0; i < first.highLowContainer.size(); ++i) {
            char key = first.highLowContainer.getKeyAtIndex(i);
            int n = key >>> 6;
            words[n] = words[n] | 1L << key;
        }
        int numContainers = first.highLowContainer.size();
        for (int i = 1; i < bitmaps.length && numContainers > 0; ++i) {
            char[] keys2;
            if (bitmaps[i].highLowContainer instanceof MutableRoaringArray) {
                keys2 = ((MutableRoaringArray)bitmaps[i].highLowContainer).keys;
            } else {
                keys2 = new char[bitmaps[i].highLowContainer.size()];
                for (int j = 0; j < keys2.length; ++j) {
                    keys2[j] = bitmaps[i].highLowContainer.getKeyAtIndex(j);
                }
            }
            numContainers = BufferUtil.intersectArrayIntoBitmap(words, CharBuffer.wrap(keys2), bitmaps[i].highLowContainer.size());
        }
        if (numContainers == 0) {
            return new MutableRoaringBitmap();
        }
        char[] keys3 = new char[numContainers];
        int base = 0;
        int pos = 0;
        long[] lArray = words;
        int n = lArray.length;
        for (int i = 0; i < n; ++i) {
            for (long word = lArray[i]; word != 0L; word &= word - 1L) {
                keys3[pos++] = (char)(base + Long.numberOfTrailingZeros(word));
            }
            base += 64;
        }
        MappeableContainer[][] containers = new MappeableContainer[numContainers][bitmaps.length];
        for (int i = 0; i < bitmaps.length; ++i) {
            ImmutableRoaringBitmap bitmap = bitmaps[i];
            int position = 0;
            for (int j = 0; j < bitmap.highLowContainer.size(); ++j) {
                char key = bitmap.highLowContainer.getKeyAtIndex(j);
                if ((words[key >>> 6] & 1L << key) == 0L) continue;
                containers[position++][i] = bitmap.highLowContainer.getContainerAtIndex(j);
            }
        }
        MutableRoaringArray array = new MutableRoaringArray(keys3, new MappeableContainer[numContainers], 0);
        for (int i = 0; i < numContainers; ++i) {
            MappeableContainer[] slice = containers[i];
            Arrays.fill(words, -1L);
            MappeableContainer tmp = new MappeableBitmapContainer(LongBuffer.wrap(words), -1);
            for (MappeableContainer container : slice) {
                MappeableContainer and = tmp.iand(container);
                if (and == tmp) continue;
                tmp = and;
            }
            if ((tmp = tmp.repairAfterLazy()).isEmpty()) continue;
            array.append(keys3[i], tmp instanceof MappeableBitmapContainer ? tmp.clone() : tmp);
        }
        return new MutableRoaringBitmap(array);
    }

    static MutableRoaringBitmap workShyAnd(long[] aggregationBuffer, Iterator<? extends ImmutableRoaringBitmap> bitmaps) {
        char[] keys2;
        long[] words = aggregationBuffer;
        ArrayList<ImmutableRoaringBitmap> collected = new ArrayList<ImmutableRoaringBitmap>();
        ImmutableRoaringBitmap first = bitmaps.next();
        collected.add(first);
        for (int i = 0; i < first.highLowContainer.size(); ++i) {
            char key = first.highLowContainer.getKeyAtIndex(i);
            int n = key >>> 6;
            words[n] = words[n] | 1L << key;
        }
        int bitmapCount = 1;
        int numContainers = first.highLowContainer.size();
        while (numContainers > 0 && bitmaps.hasNext()) {
            ImmutableRoaringBitmap bitmap = bitmaps.next();
            collected.add(bitmap);
            ++bitmapCount;
            if (bitmap.highLowContainer instanceof MutableRoaringArray) {
                keys2 = ((MutableRoaringArray)bitmap.highLowContainer).keys;
            } else {
                keys2 = new char[bitmap.highLowContainer.size()];
                for (int j = 0; j < keys2.length; ++j) {
                    keys2[j] = bitmap.highLowContainer.getKeyAtIndex(j);
                }
            }
            numContainers = BufferUtil.intersectArrayIntoBitmap(words, CharBuffer.wrap(keys2), bitmap.highLowContainer.size());
        }
        if (numContainers == 0) {
            return new MutableRoaringBitmap();
        }
        keys2 = new char[numContainers];
        int base = 0;
        int pos = 0;
        long[] lArray = words;
        int n = lArray.length;
        for (int i = 0; i < n; ++i) {
            for (long word = lArray[i]; word != 0L; word &= word - 1L) {
                keys2[pos++] = (char)(base + Long.numberOfTrailingZeros(word));
            }
            base += 64;
        }
        MappeableContainer[][] containers = new MappeableContainer[numContainers][bitmapCount];
        for (int i = 0; i < bitmapCount; ++i) {
            ImmutableRoaringBitmap bitmap = (ImmutableRoaringBitmap)collected.get(i);
            int position = 0;
            for (int j = 0; j < bitmap.highLowContainer.size(); ++j) {
                char key = bitmap.highLowContainer.getKeyAtIndex(j);
                if ((words[key >>> 6] & 1L << key) == 0L) continue;
                containers[position++][i] = bitmap.highLowContainer.getContainerAtIndex(j);
            }
        }
        MutableRoaringArray array = new MutableRoaringArray(keys2, new MappeableContainer[numContainers], 0);
        for (int i = 0; i < numContainers; ++i) {
            MappeableContainer[] slice = containers[i];
            Arrays.fill(words, -1L);
            MappeableContainer tmp = new MappeableBitmapContainer(LongBuffer.wrap(words), -1);
            for (MappeableContainer container : slice) {
                MappeableContainer and = tmp.iand(container);
                if (and == tmp) continue;
                tmp = and;
            }
            if ((tmp = tmp.repairAfterLazy()).isEmpty()) continue;
            array.append(keys2[i], tmp instanceof MappeableBitmapContainer ? tmp.clone() : tmp);
        }
        return new MutableRoaringBitmap(array);
    }

    private static int workShyAndCardinality(ImmutableRoaringBitmap ... bitmaps) {
        long[] words = new long[1024];
        ImmutableRoaringBitmap first = bitmaps[0];
        for (int i = 0; i < first.highLowContainer.size(); ++i) {
            char key = first.highLowContainer.getKeyAtIndex(i);
            int n = key >>> 6;
            words[n] = words[n] | 1L << key;
        }
        int numKeys = first.highLowContainer.size();
        for (int i = 1; i < bitmaps.length && numKeys > 0; ++i) {
            char[] keys2;
            if (bitmaps[i].highLowContainer instanceof MutableRoaringArray) {
                keys2 = ((MutableRoaringArray)bitmaps[i].highLowContainer).keys;
            } else {
                keys2 = new char[bitmaps[i].highLowContainer.size()];
                for (int j = 0; j < keys2.length; ++j) {
                    keys2[j] = bitmaps[i].highLowContainer.getKeyAtIndex(j);
                }
            }
            numKeys = BufferUtil.intersectArrayIntoBitmap(words, CharBuffer.wrap(keys2), bitmaps[i].highLowContainer.size());
        }
        if (numKeys == 0) {
            return 0;
        }
        char[] keys3 = new char[numKeys];
        int base = 0;
        int pos = 0;
        long[] lArray = words;
        int n = lArray.length;
        for (int i = 0; i < n; ++i) {
            for (long word = lArray[i]; word != 0L; word &= word - 1L) {
                keys3[pos++] = (char)(base + Long.numberOfTrailingZeros(word));
            }
            base += 64;
        }
        LongBuffer longBuffer = LongBuffer.wrap(words);
        int cardinality = 0;
        for (char key : keys3) {
            Arrays.fill(words, -1L);
            MappeableContainer tmp = new MappeableBitmapContainer(longBuffer, -1);
            for (ImmutableRoaringBitmap bitmap : bitmaps) {
                MappeableContainer container;
                MappeableContainer and;
                int index = bitmap.highLowContainer.getIndex(key);
                if (index < 0 || (and = tmp.iand(container = bitmap.highLowContainer.getContainerAtIndex(index))) == tmp) continue;
                tmp = and;
            }
            cardinality += ((MappeableContainer)tmp).repairAfterLazy().getCardinality();
        }
        return cardinality;
    }

    private static int horizontalOrCardinality(ImmutableRoaringBitmap ... bitmaps) {
        int key;
        long[] words = new long[1024];
        int minKey = 65535;
        int maxKey = 0;
        for (ImmutableRoaringBitmap bitmap : bitmaps) {
            for (int i = 0; i < bitmap.highLowContainer.size(); ++i) {
                key = bitmap.highLowContainer.getKeyAtIndex(i);
                int n = key >>> 6;
                words[n] = words[n] | 1L << key;
                minKey = Math.min(minKey, key);
                maxKey = Math.max(maxKey, key);
            }
        }
        int numKeys = Util.cardinalityInBitmapRange(words, minKey, maxKey + 1);
        char[] keys2 = new char[numKeys];
        int base = 0;
        int pos = 0;
        long[] i = words;
        key = i.length;
        for (int j = 0; j < key; ++j) {
            for (long word = i[j]; word != 0L; word &= word - 1L) {
                keys2[pos++] = (char)(base + Long.numberOfTrailingZeros(word));
            }
            base += 64;
        }
        LongBuffer longBuffer = LongBuffer.wrap(words);
        int cardinality = 0;
        for (char key2 : keys2) {
            Arrays.fill(words, 0L);
            MappeableContainer tmp = new MappeableBitmapContainer(longBuffer, -1);
            for (ImmutableRoaringBitmap bitmap : bitmaps) {
                MappeableContainer container;
                MappeableContainer or;
                int index = bitmap.highLowContainer.getIndex(key2);
                if (index < 0 || (or = tmp.lazyIOR(container = bitmap.highLowContainer.getContainerAtIndex(index))) == tmp) continue;
                tmp = or;
            }
            cardinality += ((MappeableContainer)tmp).repairAfterLazy().getCardinality();
        }
        return cardinality;
    }

    public static MutableRoaringBitmap workAndMemoryShyAnd(long[] buffer, ImmutableRoaringBitmap ... bitmaps) {
        if (buffer.length < 1024) {
            throw new IllegalArgumentException("buffer should have at least 1024 elements.");
        }
        long[] words = buffer;
        ImmutableRoaringBitmap first = bitmaps[0];
        for (int i = 0; i < first.highLowContainer.size(); ++i) {
            char key = first.highLowContainer.getKeyAtIndex(i);
            int n = key >>> 6;
            words[n] = words[n] | 1L << key;
        }
        int numContainers = first.highLowContainer.size();
        for (int i = 1; i < bitmaps.length && numContainers > 0; ++i) {
            char[] keys2;
            if (bitmaps[i].highLowContainer instanceof MutableRoaringArray) {
                keys2 = ((MutableRoaringArray)bitmaps[i].highLowContainer).keys;
            } else {
                keys2 = new char[bitmaps[i].highLowContainer.size()];
                for (int j = 0; j < keys2.length; ++j) {
                    keys2[j] = bitmaps[i].highLowContainer.getKeyAtIndex(j);
                }
            }
            numContainers = BufferUtil.intersectArrayIntoBitmap(words, CharBuffer.wrap(keys2), bitmaps[i].highLowContainer.size());
        }
        if (numContainers == 0) {
            return new MutableRoaringBitmap();
        }
        char[] keys3 = new char[numContainers];
        int base = 0;
        int pos = 0;
        long[] lArray = words;
        int n = lArray.length;
        for (int i = 0; i < n; ++i) {
            for (long word = lArray[i]; word != 0L; word &= word - 1L) {
                keys3[pos++] = (char)(base + Long.numberOfTrailingZeros(word));
            }
            base += 64;
        }
        MutableRoaringArray array = new MutableRoaringArray(keys3, new MappeableContainer[numContainers], 0);
        for (int i = 0; i < numContainers; ++i) {
            char MatchingKey = keys3[i];
            Arrays.fill(words, -1L);
            MappeableContainer tmp = new MappeableBitmapContainer(LongBuffer.wrap(words), -1);
            for (ImmutableRoaringBitmap bitmap : bitmaps) {
                MappeableContainer container;
                MappeableContainer and;
                int idx = bitmap.highLowContainer.getIndex(MatchingKey);
                if (idx < 0 || (and = tmp.iand(container = bitmap.highLowContainer.getContainerAtIndex(idx))) == tmp) continue;
                tmp = and;
            }
            if ((tmp = tmp.repairAfterLazy()).isEmpty()) continue;
            array.append(keys3[i], tmp instanceof MappeableBitmapContainer ? tmp.clone() : tmp);
        }
        return new MutableRoaringBitmap(array);
    }

    public static MutableRoaringBitmap naive_or(ImmutableRoaringBitmap ... bitmaps) {
        MutableRoaringBitmap answer = new MutableRoaringBitmap();
        for (int k = 0; k < bitmaps.length; ++k) {
            answer.naivelazyor(bitmaps[k]);
        }
        answer.repairAfterLazy();
        return answer;
    }

    public static MutableRoaringBitmap naive_or(Iterator bitmaps) {
        MutableRoaringBitmap answer = new MutableRoaringBitmap();
        while (bitmaps.hasNext()) {
            answer.naivelazyor((ImmutableRoaringBitmap)bitmaps.next());
        }
        answer.repairAfterLazy();
        return answer;
    }

    public static MutableRoaringBitmap naive_or(MutableRoaringBitmap ... bitmaps) {
        MutableRoaringBitmap answer = new MutableRoaringBitmap();
        for (int k = 0; k < bitmaps.length; ++k) {
            answer.lazyor(bitmaps[k]);
        }
        answer.repairAfterLazy();
        return answer;
    }

    public static MutableRoaringBitmap naive_xor(ImmutableRoaringBitmap ... bitmaps) {
        MutableRoaringBitmap answer = new MutableRoaringBitmap();
        for (int k = 0; k < bitmaps.length; ++k) {
            answer.xor(bitmaps[k]);
        }
        return answer;
    }

    public static MutableRoaringBitmap naive_xor(Iterator bitmaps) {
        MutableRoaringBitmap answer = new MutableRoaringBitmap();
        while (bitmaps.hasNext()) {
            answer.xor((ImmutableRoaringBitmap)bitmaps.next());
        }
        return answer;
    }

    public static MutableRoaringBitmap naive_xor(MutableRoaringBitmap ... bitmaps) {
        MutableRoaringBitmap answer = new MutableRoaringBitmap();
        for (int k = 0; k < bitmaps.length; ++k) {
            answer.xor(bitmaps[k]);
        }
        return answer;
    }

    public static MutableRoaringBitmap or(ImmutableRoaringBitmap ... bitmaps) {
        return BufferFastAggregation.naive_or(bitmaps);
    }

    public static MutableRoaringBitmap or(Iterator bitmaps) {
        return BufferFastAggregation.naive_or(bitmaps);
    }

    public static MutableRoaringBitmap or(MutableRoaringBitmap ... bitmaps) {
        return BufferFastAggregation.naive_or(bitmaps);
    }

    public static MutableRoaringBitmap priorityqueue_or(ImmutableRoaringBitmap ... bitmaps) {
        if (bitmaps.length == 0) {
            return new MutableRoaringBitmap();
        }
        if (bitmaps.length == 1) {
            return bitmaps[0].toMutableRoaringBitmap();
        }
        ImmutableRoaringBitmap[] buffer = Arrays.copyOf(bitmaps, bitmaps.length);
        final int[] sizes = new int[buffer.length];
        boolean[] istmp = new boolean[buffer.length];
        for (int k = 0; k < sizes.length; ++k) {
            sizes[k] = buffer[k].serializedSizeInBytes();
        }
        PriorityQueue<Integer> pq = new PriorityQueue<Integer>(128, new Comparator<Integer>(){

            @Override
            public int compare(Integer a, Integer b) {
                return sizes[a] - sizes[b];
            }
        });
        for (int k = 0; k < sizes.length; ++k) {
            pq.add(k);
        }
        while (pq.size() > 1) {
            Integer x1 = pq.poll();
            Integer x2 = pq.poll();
            if (istmp[x1] && istmp[x2]) {
                buffer[x1.intValue()] = MutableRoaringBitmap.lazyorfromlazyinputs((MutableRoaringBitmap)buffer[x1], (MutableRoaringBitmap)buffer[x2]);
                sizes[x1.intValue()] = buffer[x1].serializedSizeInBytes();
                pq.add(x1);
                continue;
            }
            if (istmp[x2]) {
                ((MutableRoaringBitmap)buffer[x2]).lazyor(buffer[x1]);
                sizes[x2.intValue()] = buffer[x2].serializedSizeInBytes();
                pq.add(x2);
                continue;
            }
            if (istmp[x1]) {
                ((MutableRoaringBitmap)buffer[x1]).lazyor(buffer[x2]);
                sizes[x1.intValue()] = buffer[x1].serializedSizeInBytes();
                pq.add(x1);
                continue;
            }
            buffer[x1.intValue()] = ImmutableRoaringBitmap.lazyor(buffer[x1], buffer[x2]);
            sizes[x1.intValue()] = buffer[x1].serializedSizeInBytes();
            istmp[x1.intValue()] = true;
            pq.add(x1);
        }
        MutableRoaringBitmap answer = (MutableRoaringBitmap)buffer[pq.poll()];
        answer.repairAfterLazy();
        return answer;
    }

    public static MutableRoaringBitmap priorityqueue_or(Iterator bitmaps) {
        if (!bitmaps.hasNext()) {
            return new MutableRoaringBitmap();
        }
        ArrayList<ImmutableRoaringBitmap> buffer = new ArrayList<ImmutableRoaringBitmap>();
        while (bitmaps.hasNext()) {
            buffer.add((ImmutableRoaringBitmap)bitmaps.next());
        }
        final long[] sizes = new long[buffer.size()];
        boolean[] istmp = new boolean[buffer.size()];
        for (int k = 0; k < sizes.length; ++k) {
            sizes[k] = ((ImmutableRoaringBitmap)buffer.get(k)).getLongSizeInBytes();
        }
        PriorityQueue<Integer> pq = new PriorityQueue<Integer>(128, new Comparator<Integer>(){

            @Override
            public int compare(Integer a, Integer b) {
                return (int)(sizes[a] - sizes[b]);
            }
        });
        for (int k = 0; k < sizes.length; ++k) {
            pq.add(k);
        }
        if (pq.size() == 1) {
            return ((ImmutableRoaringBitmap)buffer.get(pq.poll())).toMutableRoaringBitmap();
        }
        while (pq.size() > 1) {
            Integer x1 = pq.poll();
            Integer x2 = pq.poll();
            if (istmp[x1] && istmp[x2]) {
                buffer.set(x1, MutableRoaringBitmap.lazyorfromlazyinputs((MutableRoaringBitmap)buffer.get(x1), (MutableRoaringBitmap)buffer.get(x2)));
                sizes[x1.intValue()] = ((ImmutableRoaringBitmap)buffer.get(x1)).getLongSizeInBytes();
                pq.add(x1);
                continue;
            }
            if (istmp[x2]) {
                ((MutableRoaringBitmap)buffer.get(x2)).lazyor((ImmutableRoaringBitmap)buffer.get(x1));
                sizes[x2.intValue()] = ((ImmutableRoaringBitmap)buffer.get(x2)).getLongSizeInBytes();
                pq.add(x2);
                continue;
            }
            if (istmp[x1]) {
                ((MutableRoaringBitmap)buffer.get(x1)).lazyor((ImmutableRoaringBitmap)buffer.get(x2));
                sizes[x1.intValue()] = ((ImmutableRoaringBitmap)buffer.get(x1)).getLongSizeInBytes();
                pq.add(x1);
                continue;
            }
            buffer.set(x1, ImmutableRoaringBitmap.lazyor((ImmutableRoaringBitmap)buffer.get(x1), (ImmutableRoaringBitmap)buffer.get(x2)));
            sizes[x1.intValue()] = ((ImmutableRoaringBitmap)buffer.get(x1)).getLongSizeInBytes();
            istmp[x1.intValue()] = true;
            pq.add(x1);
        }
        MutableRoaringBitmap answer = (MutableRoaringBitmap)buffer.get(pq.poll());
        answer.repairAfterLazy();
        return answer;
    }

    public static MutableRoaringBitmap priorityqueue_xor(ImmutableRoaringBitmap ... bitmaps) {
        if (bitmaps.length < 2) {
            throw new IllegalArgumentException("Expecting at least 2 bitmaps");
        }
        PriorityQueue<ImmutableRoaringBitmap> pq = new PriorityQueue<ImmutableRoaringBitmap>(bitmaps.length, new Comparator<ImmutableRoaringBitmap>(){

            @Override
            public int compare(ImmutableRoaringBitmap a, ImmutableRoaringBitmap b) {
                return (int)(a.getLongSizeInBytes() - b.getLongSizeInBytes());
            }
        });
        Collections.addAll(pq, bitmaps);
        while (pq.size() > 1) {
            ImmutableRoaringBitmap x1 = pq.poll();
            ImmutableRoaringBitmap x2 = pq.poll();
            pq.add(ImmutableRoaringBitmap.xor(x1, x2));
        }
        return (MutableRoaringBitmap)pq.poll();
    }

    public static MutableRoaringBitmap xor(ImmutableRoaringBitmap ... bitmaps) {
        return BufferFastAggregation.naive_xor(bitmaps);
    }

    public static MutableRoaringBitmap xor(Iterator bitmaps) {
        return BufferFastAggregation.naive_xor(bitmaps);
    }

    public static MutableRoaringBitmap xor(MutableRoaringBitmap ... bitmaps) {
        return BufferFastAggregation.naive_xor(bitmaps);
    }

    private BufferFastAggregation() {
    }
}

