/*
 * Decompiled with CFR 0.152.
 */
package io.javalin.jetty;

import io.hops.hudi.org.apache.jetty.server.ConnectionFactory;
import io.hops.hudi.org.apache.jetty.server.Connector;
import io.hops.hudi.org.apache.jetty.server.Handler;
import io.hops.hudi.org.apache.jetty.server.HandlerContainer;
import io.hops.hudi.org.apache.jetty.server.HttpConnectionFactory;
import io.hops.hudi.org.apache.jetty.server.Request;
import io.hops.hudi.org.apache.jetty.server.Server;
import io.hops.hudi.org.apache.jetty.server.ServerConnector;
import io.hops.hudi.org.apache.jetty.server.handler.AbstractHandlerContainer;
import io.hops.hudi.org.apache.jetty.server.handler.HandlerCollection;
import io.hops.hudi.org.apache.jetty.server.handler.HandlerWrapper;
import io.hops.hudi.org.apache.jetty.server.session.SessionHandler;
import io.hops.hudi.org.apache.jetty.servlet.ServletContextHandler;
import io.hops.hudi.org.apache.jetty.servlet.ServletHolder;
import io.hops.hudi.org.apache.jetty.util.component.AbstractLifeCycle;
import io.javalin.core.JavalinConfig;
import io.javalin.core.util.JavalinLogger;
import io.javalin.core.util.Util;
import io.javalin.jetty.JavalinJettyServlet;
import io.javalin.jetty.JettyUtil;
import java.net.BindException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.servlet.Servlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0019\u001a\u00020\u00162\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\b\u0010\u001c\u001a\u00020\u001dH\u0002J\u0006\u0010\u001a\u001a\u00020\u001bJ\u000e\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!J\u0014\u0010\"\u001a\u00020#*\u00020$2\u0006\u0010%\u001a\u00020&H\u0002J\f\u0010'\u001a\u00020$*\u00020(H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u001c\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u001a\u0010\r\u001a\u00020\u000eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u0012\u0010\u0013\u001a\u00020\u00148\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0015\u001a\u00020\b*\u00020\u00168BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018\u00a8\u0006)"}, d2={"Lio/javalin/jetty/JettyServer;", "", "config", "Lio/javalin/core/JavalinConfig;", "(Lio/javalin/core/JavalinConfig;)V", "getConfig", "()Lio/javalin/core/JavalinConfig;", "serverHost", "", "getServerHost", "()Ljava/lang/String;", "setServerHost", "(Ljava/lang/String;)V", "serverPort", "", "getServerPort", "()I", "setServerPort", "(I)V", "started", "", "protocol", "Lio/hops/hudi/org/apache/jetty/server/ServerConnector;", "getProtocol", "(Lorg/eclipse/jetty/server/ServerConnector;)Ljava/lang/String;", "defaultConnector", "server", "Lio/hops/hudi/org/apache/jetty/server/Server;", "defaultSessionHandler", "Lio/hops/hudi/org/apache/jetty/server/session/SessionHandler;", "start", "", "wsAndHttpServlet", "Lio/javalin/jetty/JavalinJettyServlet;", "attachHandler", "Lio/hops/hudi/org/apache/jetty/server/handler/AbstractHandlerContainer;", "Lio/hops/hudi/org/apache/jetty/server/Handler;", "servletContextHandler", "Lio/hops/hudi/org/apache/jetty/servlet/ServletContextHandler;", "unwrap", "Lio/hops/hudi/org/apache/jetty/server/handler/HandlerWrapper;", "javalin"})
public final class JettyServer {
    @NotNull
    private final JavalinConfig config;
    @JvmField
    public boolean started;
    private int serverPort;
    @Nullable
    private String serverHost;

    public JettyServer(@NotNull JavalinConfig config) {
        Intrinsics.checkNotNullParameter(config, "config");
        this.config = config;
        this.serverPort = -1;
    }

    @NotNull
    public final JavalinConfig getConfig() {
        return this.config;
    }

    public final int getServerPort() {
        return this.serverPort;
    }

    public final void setServerPort(int n) {
        this.serverPort = n;
    }

    @Nullable
    public final String getServerHost() {
        return this.serverHost;
    }

    public final void setServerHost(@Nullable String string) {
        this.serverHost = string;
    }

    @NotNull
    public final Server server() {
        Server server = this.config.inner.server;
        this.config.inner.server = server == null ? JettyUtil.getOrDefault(this.config.inner.server) : server;
        Server server2 = this.config.inner.server;
        Intrinsics.checkNotNull(server2);
        server = server2;
        Intrinsics.checkNotNullExpressionValue(server, "config.inner.server!!");
        return server;
    }

    /*
     * WARNING - void declaration
     */
    public final void start(@NotNull JavalinJettyServlet wsAndHttpServlet) throws BindException {
        int n;
        void $this$filterTo$iv$iv;
        Connector[] $this$forEach$iv;
        Object[] $this$filterIsInstanceTo$iv$iv;
        Handler handler;
        SessionHandler sessionHandler;
        Intrinsics.checkNotNullParameter((Object)wsAndHttpServlet, "wsAndHttpServlet");
        if (this.serverPort == -1 && this.config.inner.server == null) {
            this.serverPort = 8080;
            JavalinLogger.startup("No port specified, starting on port " + this.serverPort + ". Call start(port) to change ports.");
        }
        this.config.inner.sessionHandler = (sessionHandler = this.config.inner.sessionHandler) == null ? this.defaultSessionHandler() : sessionHandler;
        Void nullParent = null;
        String string = this.config.contextPath;
        Intrinsics.checkNotNullExpressionValue(string, "config.contextPath");
        Object object = Util.normalizeContextPath(string);
        object = new ServletContextHandler(nullParent, (String)object){
            final /* synthetic */ Void $nullParent;
            {
                this.$nullParent = $nullParent;
                super((HandlerContainer)((Object)$nullParent), $super_call_param$1, 1);
            }

            public void doHandle(@NotNull String target, @NotNull Request jettyRequest, @NotNull HttpServletRequest request, @NotNull HttpServletResponse response) {
                Intrinsics.checkNotNullParameter(target, "target");
                Intrinsics.checkNotNullParameter(jettyRequest, "jettyRequest");
                Intrinsics.checkNotNullParameter(request, "request");
                Intrinsics.checkNotNullParameter(response, "response");
                request.setAttribute("jetty-target", (Object)target);
                request.setAttribute("jetty-request", (Object)jettyRequest);
                this.nextHandle(target, jettyRequest, request, response);
            }
        };
        boolean bl = false;
        boolean bl2 = false;
        Connector[] connectorArray = object;
        boolean bl3 = false;
        connectorArray.setSessionHandler(this.getConfig().inner.sessionHandler);
        Object[] objectArray = this.getConfig().inner.servletContextHandlerConsumer;
        if (objectArray != null) {
            objectArray.accept((ServletContextHandler)connectorArray);
        }
        connectorArray.addServlet(new ServletHolder((Servlet)wsAndHttpServlet), "/*");
        Connector[] wsAndHttpHandler2 = object;
        object = this.server();
        bl = false;
        bl2 = false;
        Connector[] connectorArray2 = object;
        boolean bl4 = false;
        if (connectorArray2.getHandler() == null) {
            handler = (Handler)wsAndHttpHandler2;
        } else {
            objectArray = connectorArray2.getHandler();
            Intrinsics.checkNotNullExpressionValue(objectArray, "handler");
            handler = this.attachHandler((Handler)objectArray, (ServletContextHandler)wsAndHttpHandler2);
        }
        connectorArray2.setHandler(handler);
        objectArray = connectorArray2.getConnectors();
        Intrinsics.checkNotNullExpressionValue(objectArray, "connectors");
        objectArray = objectArray;
        int n2 = 0;
        if (objectArray.length == 0) {
            objectArray = new ServerConnector[]{this.defaultConnector((Server)connectorArray2)};
            connectorArray2.setConnectors((Connector[])objectArray);
        }
        ((AbstractLifeCycle)object).start();
        JavalinLogger.INSTANCE.logAllDelayed$javalin();
        object = this.server().getConnectors();
        Intrinsics.checkNotNullExpressionValue(object, "server().connectors");
        Object $this$filterIsInstance$iv = (Object[])object;
        boolean $i$f$filterIsInstance = false;
        Object[] objectArray2 = $this$filterIsInstance$iv;
        Collection collection = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof ServerConnector)) continue;
            collection.add(element$iv$iv);
        }
        $this$filterIsInstance$iv = (List)collection;
        boolean $i$f$forEach = false;
        for (Object t : $this$forEach$iv) {
            String string2;
            ServerConnector it = (ServerConnector)t;
            boolean bl5 = false;
            JavalinLogger.startup("Listening on " + this.getProtocol(it) + "://" + ((string2 = it.getHost()) == null ? "localhost" : string2) + ':' + it.getLocalPort() + this.getConfig().contextPath);
        }
        $this$forEach$iv = this.server().getConnectors();
        Intrinsics.checkNotNullExpressionValue($this$forEach$iv, "server().connectors");
        Object $this$filter$iv = $this$forEach$iv;
        boolean $i$f$filter = false;
        $this$filterIsInstanceTo$iv$iv = $this$filter$iv;
        Collection collection2 = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Connector it = (Connector)element$iv$iv;
            boolean bl6 = false;
            if (!(!(it instanceof ServerConnector))) continue;
            collection2.add(element$iv$iv);
        }
        $this$filter$iv = (List)collection2;
        $i$f$forEach = false;
        for (Object e : $this$forEach$iv) {
            Connector it = (Connector)e;
            boolean bl7 = false;
            JavalinLogger.startup(Intrinsics.stringPlus("Binding to: ", it));
        }
        JettyUtil.INSTANCE.reEnableJettyLogger();
        Connector connector = this.server().getConnectors()[0];
        object = connector instanceof ServerConnector ? (ServerConnector)connector : null;
        this.serverPort = object == null ? -1 : (n = ((ServerConnector)object).getLocalPort());
    }

    private final ServerConnector defaultConnector(Server server) {
        ServerConnector serverConnector = new ServerConnector(server);
        boolean bl = false;
        boolean bl2 = false;
        ServerConnector $this$defaultConnector_u24lambda_u2d6 = serverConnector;
        boolean bl3 = false;
        $this$defaultConnector_u24lambda_u2d6.setPort(this.getServerPort());
        $this$defaultConnector_u24lambda_u2d6.setHost(this.getServerHost());
        Collection<ConnectionFactory> collection = $this$defaultConnector_u24lambda_u2d6.getConnectionFactories();
        Intrinsics.checkNotNullExpressionValue(collection, "this.connectionFactories");
        Iterable $this$forEach$iv = collection;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ConnectionFactory it = (ConnectionFactory)element$iv;
            boolean bl4 = false;
            if (!(it instanceof HttpConnectionFactory)) continue;
            ((HttpConnectionFactory)it).getHttpConfiguration().setSendServerVersion(false);
        }
        return serverConnector;
    }

    private final SessionHandler defaultSessionHandler() {
        SessionHandler sessionHandler = new SessionHandler();
        boolean bl = false;
        boolean bl2 = false;
        SessionHandler $this$defaultSessionHandler_u24lambda_u2d7 = sessionHandler;
        boolean bl3 = false;
        $this$defaultSessionHandler_u24lambda_u2d7.setHttpOnly(true);
        return sessionHandler;
    }

    private final String getProtocol(ServerConnector $this$protocol) {
        return $this$protocol.getProtocols().contains("ssl") ? "https" : "http";
    }

    private final AbstractHandlerContainer attachHandler(Handler $this$attachHandler, ServletContextHandler servletContextHandler) {
        AbstractHandlerContainer abstractHandlerContainer;
        Handler handler = $this$attachHandler;
        if (handler instanceof HandlerCollection) {
            Handler handler2 = $this$attachHandler;
            boolean bl = false;
            boolean bl2 = false;
            HandlerCollection $this$attachHandler_u24lambda_u2d8 = (HandlerCollection)handler2;
            boolean bl3 = false;
            $this$attachHandler_u24lambda_u2d8.addHandler(servletContextHandler);
            abstractHandlerContainer = (AbstractHandlerContainer)handler2;
        } else if (handler instanceof HandlerWrapper) {
            AbstractHandlerContainer abstractHandlerContainer2;
            Handler handler3 = $this$attachHandler;
            boolean bl = false;
            boolean bl4 = false;
            HandlerWrapper $this$attachHandler_u24lambda_u2d9 = (HandlerWrapper)handler3;
            boolean bl5 = false;
            Handler handler4 = this.unwrap($this$attachHandler_u24lambda_u2d9);
            AbstractHandlerContainer abstractHandlerContainer3 = abstractHandlerContainer2 = handler4 instanceof HandlerCollection ? (HandlerCollection)handler4 : null;
            if (abstractHandlerContainer2 != null) {
                ((HandlerCollection)abstractHandlerContainer2).addHandler(servletContextHandler);
            }
            handler4 = this.unwrap($this$attachHandler_u24lambda_u2d9);
            AbstractHandlerContainer abstractHandlerContainer4 = abstractHandlerContainer2 = handler4 instanceof HandlerWrapper ? (HandlerWrapper)handler4 : null;
            if (abstractHandlerContainer2 != null) {
                ((HandlerWrapper)abstractHandlerContainer2).setHandler(servletContextHandler);
            }
            abstractHandlerContainer = (AbstractHandlerContainer)handler3;
        } else {
            throw new IllegalStateException("Server has unsupported Handler attached to it (must be HandlerCollection or HandlerWrapper)");
        }
        return abstractHandlerContainer;
    }

    private final Handler unwrap(HandlerWrapper $this$unwrap) {
        Handler handler;
        Handler handler2 = $this$unwrap.getHandler();
        if (handler2 == null) {
            handler = $this$unwrap;
        } else if (handler2 instanceof HandlerCollection) {
            Handler handler3 = $this$unwrap.getHandler();
            Intrinsics.checkNotNullExpressionValue(handler3, "this.handler");
            handler = handler3;
        } else if (handler2 instanceof HandlerWrapper) {
            Handler handler4 = $this$unwrap.getHandler();
            if (handler4 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.eclipse.jetty.server.handler.HandlerWrapper");
            }
            handler = this.unwrap((HandlerWrapper)handler4);
        } else {
            throw new IllegalStateException("HandlerWrapper has unsupported Handler type (must be HandlerCollection or HandlerWrapper");
        }
        return handler;
    }
}

