/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import io.hops.hudi.org.apache.hbase.thirdparty.com.google.common.base.Preconditions;
import io.hops.hudi.org.apache.hbase.thirdparty.com.google.protobuf.ServiceException;
import io.hops.hudi.org.apache.hbase.thirdparty.io.netty.util.Timer;
import java.io.IOException;
import java.lang.reflect.UndeclaredThrowableException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellComparator;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.PrivateCellUtil;
import org.apache.hadoop.hbase.RegionLocations;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.AllowPartialScanResultCache;
import org.apache.hadoop.hbase.client.AsyncRegionLocator;
import org.apache.hadoop.hbase.client.BatchScanResultCache;
import org.apache.hadoop.hbase.client.ClusterConnection;
import org.apache.hadoop.hbase.client.CompleteScanResultCache;
import org.apache.hadoop.hbase.client.ConnectionImplementation;
import org.apache.hadoop.hbase.client.Consistency;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.MetricsConnection;
import org.apache.hadoop.hbase.client.MultiResponse;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.client.NonceGenerator;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Query;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.RegionLoadStats;
import org.apache.hadoop.hbase.client.RegionLocateType;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultStatsUtil;
import org.apache.hadoop.hbase.client.RowMutations;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.ScanResultCache;
import org.apache.hadoop.hbase.client.ServerStatisticTracker;
import org.apache.hadoop.hbase.client.metrics.ScanMetrics;
import org.apache.hadoop.hbase.ipc.HBaseRpcController;
import org.apache.hadoop.hbase.security.User;
import org.apache.hadoop.hbase.shaded.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.shaded.protobuf.ResponseConverter;
import org.apache.hadoop.hbase.shaded.protobuf.generated.ClientProtos;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.FutureUtils;
import org.apache.hadoop.hbase.util.ReflectionUtils;
import org.apache.hadoop.ipc.RemoteException;
import org.apache.hadoop.net.DNS;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public final class ConnectionUtils {
    private static final Logger LOG = LoggerFactory.getLogger(ConnectionUtils.class);
    static final NonceGenerator NO_NONCE_GENERATOR = new NonceGenerator(){

        @Override
        public long newNonce() {
            return 0L;
        }

        @Override
        public long getNonceGroup() {
            return 0L;
        }
    };
    static final byte[] MAX_BYTE_ARRAY = Bytes.createMaxByteArray(9);
    static final long SLEEP_DELTA_NS = TimeUnit.MILLISECONDS.toNanos(1L);
    private static final String MY_ADDRESS = ConnectionUtils.getMyAddress();

    private ConnectionUtils() {
    }

    public static long getPauseTime(long pause, int tries) {
        int ntries = tries;
        if (ntries >= HConstants.RETRY_BACKOFF.length) {
            ntries = HConstants.RETRY_BACKOFF.length - 1;
        }
        if (ntries < 0) {
            ntries = 0;
        }
        long normalPause = pause * (long)HConstants.RETRY_BACKOFF[ntries];
        long jitter = (long)((float)normalPause * ThreadLocalRandom.current().nextFloat() * 0.01f);
        return normalPause + jitter;
    }

    public static NonceGenerator injectNonceGeneratorForTesting(ClusterConnection conn, NonceGenerator cnm) {
        return ConnectionImplementation.injectNonceGeneratorForTesting(conn, cnm);
    }

    public static void setServerSideHConnectionRetriesConfig(Configuration c, String sn, Logger log) {
        int hcRetries = c.getInt("hbase.client.retries.number", 15);
        int serversideMultiplier = c.getInt("hbase.client.serverside.retries.multiplier", 3);
        int retries = hcRetries * serversideMultiplier;
        c.setInt("hbase.client.retries.number", retries);
        log.info(sn + " server-side Connection retries=" + retries);
    }

    public static void setupMasterlessConnection(Configuration conf) {
        conf.set("hbase.client.connection.impl", MasterlessConnection.class.getName());
    }

    static int retries2Attempts(int retries) {
        return Math.max(1, retries == Integer.MAX_VALUE ? Integer.MAX_VALUE : retries + 1);
    }

    static String getStubKey(String serviceName, ServerName serverName, boolean hostnameCanChange) {
        String hostname = serverName.getHostname();
        int port = serverName.getPort();
        if (hostnameCanChange) {
            try {
                InetAddress ip2 = InetAddress.getByName(hostname);
                return serviceName + "@" + hostname + "-" + ip2.getHostAddress() + ":" + port;
            }
            catch (UnknownHostException e) {
                LOG.warn("Can not resolve " + hostname + ", please check your network", (Throwable)e);
            }
        }
        return serviceName + "@" + hostname + ":" + port;
    }

    static void checkHasFamilies(Mutation mutation) {
        Preconditions.checkArgument(mutation.numFamilies() > 0, "Invalid arguments to %s, zero columns specified", (Object)mutation.toString());
    }

    static byte[] createClosestRowAfter(byte[] row) {
        return Arrays.copyOf(row, row.length + 1);
    }

    static byte[] createCloseRowBefore(byte[] row) {
        if (row.length == 0) {
            return MAX_BYTE_ARRAY;
        }
        if (row[row.length - 1] == 0) {
            return Arrays.copyOf(row, row.length - 1);
        }
        byte[] nextRow = new byte[row.length + MAX_BYTE_ARRAY.length];
        System.arraycopy(row, 0, nextRow, 0, row.length - 1);
        nextRow[row.length - 1] = (byte)((row[row.length - 1] & 0xFF) - 1);
        System.arraycopy(MAX_BYTE_ARRAY, 0, nextRow, row.length, MAX_BYTE_ARRAY.length);
        return nextRow;
    }

    static boolean isEmptyStartRow(byte[] row) {
        return Bytes.equals(row, HConstants.EMPTY_START_ROW);
    }

    static boolean isEmptyStopRow(byte[] row) {
        return Bytes.equals(row, HConstants.EMPTY_END_ROW);
    }

    static void resetController(HBaseRpcController controller, long timeoutNs, int priority) {
        controller.reset();
        if (timeoutNs >= 0L) {
            controller.setCallTimeout((int)Math.min(Integer.MAX_VALUE, TimeUnit.NANOSECONDS.toMillis(timeoutNs)));
        }
        controller.setPriority(priority);
    }

    static Throwable translateException(Throwable t) {
        if (t instanceof UndeclaredThrowableException && t.getCause() != null) {
            t = t.getCause();
        }
        if (t instanceof RemoteException) {
            t = ((RemoteException)t).unwrapRemoteException();
        }
        if (t instanceof ServiceException && t.getCause() != null) {
            t = ConnectionUtils.translateException(t.getCause());
        }
        return t;
    }

    static long calcEstimatedSize(Result rs) {
        long estimatedHeapSizeOfResult = 0L;
        for (Cell cell : rs.rawCells()) {
            estimatedHeapSizeOfResult += cell.heapSize();
        }
        return estimatedHeapSizeOfResult;
    }

    static Result filterCells(Result result, Cell keepCellsAfter) {
        if (keepCellsAfter == null) {
            return result;
        }
        if (!PrivateCellUtil.matchingRows(keepCellsAfter, result.getRow(), 0, result.getRow().length)) {
            return result;
        }
        Cell[] rawCells = result.rawCells();
        int index = Arrays.binarySearch(rawCells, keepCellsAfter, CellComparator.getInstance()::compareWithoutRow);
        index = index < 0 ? -index - 1 : ++index;
        if (index == 0) {
            return result;
        }
        if (index == rawCells.length) {
            return null;
        }
        return Result.create(Arrays.copyOfRange(rawCells, index, rawCells.length), null, result.isStale(), result.mayHaveMoreCellsInRow());
    }

    static Get toCheckExistenceOnly(Get get2) {
        if (get2.isCheckExistenceOnly()) {
            return get2;
        }
        return ((Get)ReflectionUtils.newInstance(get2.getClass(), get2)).setCheckExistenceOnly(true);
    }

    static List<Get> toCheckExistenceOnly(List<Get> gets) {
        return gets.stream().map(ConnectionUtils::toCheckExistenceOnly).collect(Collectors.toList());
    }

    static RegionLocateType getLocateType(Scan scan) {
        if (scan.isReversed()) {
            if (ConnectionUtils.isEmptyStartRow(scan.getStartRow())) {
                return RegionLocateType.BEFORE;
            }
            return scan.includeStartRow() ? RegionLocateType.CURRENT : RegionLocateType.BEFORE;
        }
        return scan.includeStartRow() ? RegionLocateType.CURRENT : RegionLocateType.AFTER;
    }

    static boolean noMoreResultsForScan(Scan scan, RegionInfo info) {
        if (ConnectionUtils.isEmptyStopRow(info.getEndKey())) {
            return true;
        }
        if (ConnectionUtils.isEmptyStopRow(scan.getStopRow())) {
            return false;
        }
        int c = Bytes.compareTo(info.getEndKey(), scan.getStopRow());
        return c > 0 || c == 0 && !scan.includeStopRow();
    }

    static boolean noMoreResultsForReverseScan(Scan scan, RegionInfo info) {
        if (ConnectionUtils.isEmptyStartRow(info.getStartKey())) {
            return true;
        }
        if (ConnectionUtils.isEmptyStopRow(scan.getStopRow())) {
            return false;
        }
        return Bytes.compareTo(info.getStartKey(), scan.getStopRow()) <= 0;
    }

    static <T> CompletableFuture<List<T>> allOf(List<CompletableFuture<T>> futures) {
        return CompletableFuture.allOf(futures.toArray(new CompletableFuture[0])).thenApply(v -> futures.stream().map(f -> f.getNow(null)).collect(Collectors.toList()));
    }

    public static ScanResultCache createScanResultCache(Scan scan) {
        if (scan.getAllowPartialResults()) {
            return new AllowPartialScanResultCache();
        }
        if (scan.getBatch() > 0) {
            return new BatchScanResultCache(scan.getBatch());
        }
        return new CompleteScanResultCache();
    }

    private static String getMyAddress() {
        try {
            return DNS.getDefaultHost((String)"default", (String)"default");
        }
        catch (UnknownHostException uhe) {
            LOG.error("cannot determine my address", (Throwable)uhe);
            return null;
        }
    }

    static boolean isRemote(String host2) {
        return !host2.equalsIgnoreCase(MY_ADDRESS);
    }

    static void incRPCCallsMetrics(ScanMetrics scanMetrics, boolean isRegionServerRemote) {
        if (scanMetrics == null) {
            return;
        }
        scanMetrics.countOfRPCcalls.incrementAndGet();
        if (isRegionServerRemote) {
            scanMetrics.countOfRemoteRPCcalls.incrementAndGet();
        }
    }

    static void incRPCRetriesMetrics(ScanMetrics scanMetrics, boolean isRegionServerRemote) {
        if (scanMetrics == null) {
            return;
        }
        scanMetrics.countOfRPCRetries.incrementAndGet();
        if (isRegionServerRemote) {
            scanMetrics.countOfRemoteRPCRetries.incrementAndGet();
        }
    }

    static void updateResultsMetrics(ScanMetrics scanMetrics, Result[] rrs, boolean isRegionServerRemote) {
        if (scanMetrics == null || rrs == null || rrs.length == 0) {
            return;
        }
        long resultSize = 0L;
        for (Result rr : rrs) {
            for (Cell cell : rr.rawCells()) {
                resultSize += (long)PrivateCellUtil.estimatedSerializedSizeOf(cell);
            }
        }
        scanMetrics.countOfBytesInResults.addAndGet(resultSize);
        if (isRegionServerRemote) {
            scanMetrics.countOfBytesInRemoteResults.addAndGet(resultSize);
        }
    }

    static void updateServerSideMetrics(ScanMetrics scanMetrics, ClientProtos.ScanResponse response) {
        if (scanMetrics == null || response == null || !response.hasScanMetrics()) {
            return;
        }
        ResponseConverter.getScanMetrics(response).forEach(scanMetrics::addToCounter);
    }

    static void incRegionCountMetrics(ScanMetrics scanMetrics) {
        if (scanMetrics == null) {
            return;
        }
        scanMetrics.countOfRegions.incrementAndGet();
    }

    private static <T> void connect(CompletableFuture<T> srcFuture, CompletableFuture<T> dstFuture, Optional<MetricsConnection> metrics) {
        FutureUtils.addListener(srcFuture, (r, e) -> {
            if (e != null) {
                dstFuture.completeExceptionally((Throwable)e);
            } else if (dstFuture.complete(r)) {
                metrics.ifPresent(MetricsConnection::incrHedgedReadWin);
            }
        });
        FutureUtils.addListener(dstFuture, (r, e) -> srcFuture.cancel(false));
    }

    private static <T> void sendRequestsToSecondaryReplicas(Function<Integer, CompletableFuture<T>> requestReplica, RegionLocations locs, CompletableFuture<T> future, Optional<MetricsConnection> metrics) {
        if (future.isDone()) {
            return;
        }
        int n = locs.size();
        for (int replicaId = 1; replicaId < n; ++replicaId) {
            CompletableFuture<T> secondaryFuture = requestReplica.apply(replicaId);
            metrics.ifPresent(MetricsConnection::incrHedgedReadOps);
            ConnectionUtils.connect(secondaryFuture, future, metrics);
        }
    }

    static <T> CompletableFuture<T> timelineConsistentRead(AsyncRegionLocator locator, TableName tableName, Query query, byte[] row, RegionLocateType locateType, Function<Integer, CompletableFuture<T>> requestReplica, long rpcTimeoutNs, long primaryCallTimeoutNs, Timer retryTimer, Optional<MetricsConnection> metrics) {
        if (query.getConsistency() != Consistency.TIMELINE) {
            return requestReplica.apply(0);
        }
        if (query.getReplicaId() >= 0) {
            return requestReplica.apply(query.getReplicaId());
        }
        CompletableFuture<T> primaryFuture = requestReplica.apply(0);
        CompletableFuture future = new CompletableFuture();
        ConnectionUtils.connect(primaryFuture, future, Optional.empty());
        long startNs = System.nanoTime();
        FutureUtils.addListener(locator.getRegionLocations(tableName, row, locateType, false, rpcTimeoutNs), (locs, error) -> {
            if (error != null) {
                LOG.warn("Failed to locate all the replicas for table={}, row='{}', locateType={} give up timeline consistent read", new Object[]{tableName, Bytes.toStringBinary(row), locateType, error});
                return;
            }
            if (locs.size() <= 1) {
                LOG.warn("There are no secondary replicas for region {}, give up timeline consistent read", (Object)locs.getDefaultRegionLocation().getRegion());
                return;
            }
            long delayNs = primaryCallTimeoutNs - (System.nanoTime() - startNs);
            if (delayNs <= 0L) {
                ConnectionUtils.sendRequestsToSecondaryReplicas(requestReplica, locs, future, metrics);
            } else {
                retryTimer.newTimeout(timeout -> ConnectionUtils.sendRequestsToSecondaryReplicas(requestReplica, locs, future, metrics), delayNs, TimeUnit.NANOSECONDS);
            }
        });
        return future;
    }

    static void validatePut(Put put, int maxKeyValueSize) {
        if (put.isEmpty()) {
            throw new IllegalArgumentException("No columns to insert");
        }
        if (maxKeyValueSize > 0) {
            for (List list : put.getFamilyCellMap().values()) {
                for (Cell cell : list) {
                    if (cell.getSerializedSize() <= maxKeyValueSize) continue;
                    throw new IllegalArgumentException("KeyValue size too large");
                }
            }
        }
    }

    static void validatePutsInRowMutations(RowMutations rowMutations, int maxKeyValueSize) {
        for (Mutation mutation : rowMutations.getMutations()) {
            if (!(mutation instanceof Put)) continue;
            ConnectionUtils.validatePut((Put)mutation, maxKeyValueSize);
        }
    }

    static int calcPriority(int priority, TableName tableName) {
        if (priority != -1) {
            return priority;
        }
        return ConnectionUtils.getPriority(tableName);
    }

    static int getPriority(TableName tableName) {
        if (tableName.isSystemTable()) {
            return 200;
        }
        return 0;
    }

    static <T> CompletableFuture<T> getOrFetch(AtomicReference<T> cacheRef, AtomicReference<CompletableFuture<T>> futureRef, boolean reload, Supplier<CompletableFuture<T>> fetch, Predicate<T> validator, String type) {
        CompletableFuture future;
        do {
            T value2;
            if (!reload && (value2 = cacheRef.get()) != null && validator.test(value2)) {
                return CompletableFuture.completedFuture(value2);
            }
            LOG.trace("{} cache is null, try fetching from registry", (Object)type);
            if (!futureRef.compareAndSet(null, new CompletableFuture())) continue;
            LOG.debug("Start fetching {} from registry", (Object)type);
            future = futureRef.get();
            FutureUtils.addListener(fetch.get(), (value, error) -> {
                if (error != null) {
                    LOG.debug("Failed to fetch {} from registry", (Object)type, error);
                    ((CompletableFuture)futureRef.getAndSet(null)).completeExceptionally((Throwable)error);
                    return;
                }
                LOG.debug("The fetched {} is {}", (Object)type, value);
                cacheRef.set(value);
                futureRef.set(null);
                future.complete(value);
            });
            return future;
        } while ((future = futureRef.get()) == null);
        return future;
    }

    static void updateStats(Optional<ServerStatisticTracker> optStats, Optional<MetricsConnection> optMetrics, ServerName serverName, MultiResponse resp) {
        if (!optStats.isPresent() && !optMetrics.isPresent()) {
            return;
        }
        resp.getResults().forEach((regionName, regionResult) -> {
            ClientProtos.RegionLoadStats stat = regionResult.getStat();
            if (stat == null) {
                LOG.error("No ClientProtos.RegionLoadStats found for server={}, region={}", (Object)serverName, (Object)Bytes.toStringBinary(regionName));
                return;
            }
            RegionLoadStats regionLoadStats = ProtobufUtil.createRegionLoadStats(stat);
            optStats.ifPresent(stats -> ResultStatsUtil.updateStats(stats, serverName, regionName, regionLoadStats));
            optMetrics.ifPresent(metrics -> ResultStatsUtil.updateStats(metrics, serverName, regionName, regionLoadStats));
        });
    }

    static class MasterlessConnection
    extends ConnectionImplementation {
        MasterlessConnection(Configuration conf, ExecutorService pool, User user) throws IOException {
            super(conf, pool, user);
        }

        @Override
        public boolean isTableDisabled(TableName tableName) throws IOException {
            return false;
        }
    }
}

