/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.errorhandling;

import java.util.Timer;
import java.util.TimerTask;
import org.apache.hadoop.hbase.errorhandling.ForeignException;
import org.apache.hadoop.hbase.errorhandling.ForeignExceptionListener;
import org.apache.hadoop.hbase.errorhandling.TimeoutException;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class TimeoutExceptionInjector {
    private static final Logger LOG = LoggerFactory.getLogger(TimeoutExceptionInjector.class);
    private final long maxTime;
    private volatile boolean complete;
    private final Timer timer;
    private final TimerTask timerTask;
    private long start = -1L;

    public TimeoutExceptionInjector(final ForeignExceptionListener listener, final long maxTime) {
        this.maxTime = maxTime;
        this.timer = new Timer();
        this.timerTask = new TimerTask(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                1 var1_1 = this;
                synchronized (var1_1) {
                    if (TimeoutExceptionInjector.this.complete) {
                        return;
                    }
                    TimeoutExceptionInjector.this.complete = true;
                }
                long end = EnvironmentEdgeManager.currentTime();
                TimeoutException tee = new TimeoutException("Timeout caused Foreign Exception", TimeoutExceptionInjector.this.start, end, maxTime);
                String source = "timer-" + TimeoutExceptionInjector.this.timer;
                listener.receive(new ForeignException(source, tee));
            }
        };
    }

    public long getMaxTime() {
        return this.maxTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void complete() {
        TimerTask timerTask2 = this.timerTask;
        synchronized (timerTask2) {
            if (this.complete) {
                LOG.warn("Timer already marked completed, ignoring!");
                return;
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("Marking timer as complete - no error notifications will be received for this timer.");
            }
            this.complete = true;
        }
        this.timer.cancel();
    }

    public synchronized void start() throws IllegalStateException {
        if (this.start >= 0L) {
            LOG.warn("Timer already started, can't be started again. Ignoring second request.");
            return;
        }
        LOG.debug("Scheduling process timer to run in: " + this.maxTime + " ms");
        this.timer.schedule(this.timerTask, this.maxTime);
        this.start = EnvironmentEdgeManager.currentTime();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void trigger() {
        TimerTask timerTask2 = this.timerTask;
        synchronized (timerTask2) {
            if (this.complete) {
                LOG.warn("Timer already completed, not triggering.");
                return;
            }
            LOG.debug("Triggering timer immediately!");
            this.timer.cancel();
            this.timerTask.run();
        }
    }
}

