/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.io.hfile;

import io.hops.hudi.org.apache.hbase.thirdparty.com.google.common.base.Preconditions;
import java.io.IOException;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.fs.HFileSystem;
import org.apache.hadoop.hbase.io.FSDataInputStreamWrapper;
import org.apache.hadoop.hbase.io.hfile.ReaderContext;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class ReaderContextBuilder {
    private Path filePath;
    private FSDataInputStreamWrapper fsdis;
    private long fileSize;
    private HFileSystem hfs;
    private boolean primaryReplicaReader = true;
    private ReaderContext.ReaderType type = ReaderContext.ReaderType.PREAD;

    public ReaderContextBuilder withFilePath(Path filePath) {
        this.filePath = filePath;
        return this;
    }

    public ReaderContextBuilder withFileSize(long fileSize) {
        this.fileSize = fileSize;
        return this;
    }

    public ReaderContextBuilder withInputStreamWrapper(FSDataInputStreamWrapper fsdis) {
        this.fsdis = fsdis;
        return this;
    }

    public ReaderContextBuilder withFileSystem(HFileSystem hfs) {
        this.hfs = hfs;
        return this;
    }

    public ReaderContextBuilder withFileSystem(FileSystem fs) {
        this.hfs = !(fs instanceof HFileSystem) ? new HFileSystem(fs) : (HFileSystem)fs;
        return this;
    }

    public ReaderContextBuilder withPrimaryReplicaReader(boolean primaryReplicaReader) {
        this.primaryReplicaReader = primaryReplicaReader;
        return this;
    }

    public ReaderContextBuilder withReaderType(ReaderContext.ReaderType type) {
        this.type = type;
        return this;
    }

    public ReaderContextBuilder withFileSystemAndPath(FileSystem fs, Path filePath) throws IOException {
        this.withFileSystem(fs).withFilePath(filePath).withFileSize(fs.getFileStatus(filePath).getLen()).withInputStreamWrapper(new FSDataInputStreamWrapper(fs, filePath));
        return this;
    }

    public ReaderContext build() {
        this.validateFields();
        return new ReaderContext(this.filePath, this.fsdis, this.fileSize, this.hfs, this.primaryReplicaReader, this.type);
    }

    private void validateFields() throws IllegalArgumentException {
        Preconditions.checkNotNull(this.filePath, "Illegal ReaderContext, no filePath specified.");
        Preconditions.checkNotNull(this.fsdis, "Illegal ReaderContext, no StreamWrapper specified.");
        Preconditions.checkNotNull(this.hfs, "Illegal ReaderContext, no HFileSystem specified.");
        Preconditions.checkArgument(this.fileSize > 0L, "Illegal ReaderContext, fileSize <= 0");
    }
}

