/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.replication.master;

import io.hops.hudi.org.apache.hbase.thirdparty.com.google.common.base.Predicate;
import io.hops.hudi.org.apache.hbase.thirdparty.com.google.common.collect.Iterables;
import java.io.IOException;
import java.util.Collections;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.hbase.master.cleaner.BaseHFileCleanerDelegate;
import org.apache.hadoop.hbase.replication.ReplicationException;
import org.apache.hadoop.hbase.replication.ReplicationQueueStorage;
import org.apache.hadoop.hbase.replication.ReplicationStorageFactory;
import org.apache.hadoop.hbase.zookeeper.ZKWatcher;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.LimitedPrivate(value={"Configuration"})
public class ReplicationHFileCleaner
extends BaseHFileCleanerDelegate {
    private static final Logger LOG = LoggerFactory.getLogger(ReplicationHFileCleaner.class);
    private ZKWatcher zkw;
    private ReplicationQueueStorage rqs;
    private boolean stopped = false;

    @Override
    public Iterable<FileStatus> getDeletableFiles(Iterable<FileStatus> files) {
        Set hfileRefs;
        if (this.getConf() == null) {
            return files;
        }
        try {
            hfileRefs = this.rqs.getAllHFileRefs();
        }
        catch (ReplicationException e) {
            LOG.warn("Failed to read hfile references from zookeeper, skipping checking deletable files");
            return Collections.emptyList();
        }
        return Iterables.filter(files, new Predicate<FileStatus>(){

            @Override
            public boolean apply(FileStatus file) {
                if (file == null) {
                    return false;
                }
                String hfile = file.getPath().getName();
                boolean foundHFileRefInQueue = hfileRefs.contains(hfile);
                if (LOG.isDebugEnabled()) {
                    if (foundHFileRefInQueue) {
                        LOG.debug("Found hfile reference in ZK, keeping: " + hfile);
                    } else {
                        LOG.debug("Did not find hfile reference in ZK, deleting: " + hfile);
                    }
                }
                return !foundHFileRefInQueue;
            }
        });
    }

    @Override
    public void setConf(Configuration config) {
        if (!config.getBoolean("hbase.replication.bulkload.enabled", false)) {
            LOG.warn("hbase.replication.bulkload.enabled is not enabled. Better to remove " + ReplicationHFileCleaner.class + " from " + "hbase.master.hfilecleaner.plugins" + " configuration.");
            return;
        }
        Configuration conf = new Configuration(config);
        try {
            this.setConf(conf, new ZKWatcher(conf, "replicationHFileCleaner", null));
        }
        catch (IOException e) {
            LOG.error("Error while configuring " + this.getClass().getName(), (Throwable)e);
        }
    }

    @InterfaceAudience.Private
    public void setConf(Configuration conf, ZKWatcher zk) {
        super.setConf(conf);
        try {
            this.initReplicationQueueStorage(conf, zk);
        }
        catch (Exception e) {
            LOG.error("Error while configuring " + this.getClass().getName(), (Throwable)e);
        }
    }

    private void initReplicationQueueStorage(Configuration conf, ZKWatcher zk) {
        this.zkw = zk;
        this.rqs = ReplicationStorageFactory.getReplicationQueueStorage((ZKWatcher)zk, (Configuration)conf);
    }

    @Override
    public void stop(String why) {
        if (this.stopped) {
            return;
        }
        this.stopped = true;
        if (this.zkw != null) {
            LOG.info("Stopping " + this.zkw);
            this.zkw.close();
        }
    }

    @Override
    public boolean isStopped() {
        return this.stopped;
    }

    @Override
    public boolean isFileDeletable(FileStatus fStat) {
        Set hfileRefsFromQueue;
        if (this.getConf() == null) {
            return true;
        }
        try {
            hfileRefsFromQueue = this.rqs.getAllHFileRefs();
        }
        catch (ReplicationException e) {
            LOG.warn("Failed to read hfile references from zookeeper, skipping checking deletable file for " + fStat.getPath());
            return false;
        }
        return !hfileRefsFromQueue.contains(fStat.getPath().getName());
    }
}

