/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.model;

import io.hops.hudi.com.fasterxml.jackson.annotation.JsonCreator;
import io.hops.hudi.com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import io.hops.hudi.com.fasterxml.jackson.annotation.JsonProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.hudi.common.util.JsonUtils;

@JsonIgnoreProperties(ignoreUnknown=true)
public class ConsistentHashingNode
implements Serializable {
    private final int value;
    private final String fileIdPrefix;
    private final NodeTag tag;

    public ConsistentHashingNode(int value, String fileIdPrefix) {
        this(value, fileIdPrefix, NodeTag.NORMAL);
    }

    @JsonCreator
    public ConsistentHashingNode(@JsonProperty(value="value") int value, @JsonProperty(value="fileIdPrefix") String fileIdPrefix, @JsonProperty(value="tag") NodeTag tag) {
        this.value = value;
        this.fileIdPrefix = fileIdPrefix;
        this.tag = tag;
    }

    public static String toJsonString(List<ConsistentHashingNode> nodes) throws IOException {
        return JsonUtils.getObjectMapper().writerWithDefaultPrettyPrinter().writeValueAsString(nodes);
    }

    public static List<ConsistentHashingNode> fromJsonString(String json) throws Exception {
        if (json == null || json.isEmpty()) {
            return Collections.emptyList();
        }
        ConsistentHashingNode[] nodes = JsonUtils.getObjectMapper().readValue(json, ConsistentHashingNode[].class);
        return Arrays.asList(nodes);
    }

    public int getValue() {
        return this.value;
    }

    public String getFileIdPrefix() {
        return this.fileIdPrefix;
    }

    public NodeTag getTag() {
        return this.tag;
    }

    public String toString() {
        return "ConsistentHashingNode{value=" + this.value + ", fileIdPfx='" + this.fileIdPrefix + '\'' + '}';
    }

    public static enum NodeTag {
        NORMAL,
        REPLACE,
        DELETE;

    }
}

