/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.model;

import io.hops.hudi.com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import io.hops.hudi.com.fasterxml.jackson.core.JsonProcessingException;
import java.io.IOException;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.StringJoiner;
import org.apache.hudi.common.model.HoodieIndexDefinition;
import org.apache.hudi.common.util.JsonUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonIgnoreProperties(ignoreUnknown=true)
public class HoodieIndexMetadata
implements Serializable {
    private static final Logger LOG = LoggerFactory.getLogger(HoodieIndexMetadata.class);
    private Map<String, HoodieIndexDefinition> indexDefinitions;

    public HoodieIndexMetadata() {
        this.indexDefinitions = new HashMap<String, HoodieIndexDefinition>();
    }

    public HoodieIndexMetadata(Map<String, HoodieIndexDefinition> indexDefinitions) {
        this.indexDefinitions = indexDefinitions;
    }

    public Map<String, HoodieIndexDefinition> getIndexDefinitions() {
        return this.indexDefinitions;
    }

    public void setIndexDefinitions(Map<String, HoodieIndexDefinition> indexDefinitions) {
        this.indexDefinitions = indexDefinitions;
    }

    public String toJson() throws JsonProcessingException {
        if (this.indexDefinitions.containsKey(null)) {
            LOG.info("null index name for the index definition " + this.indexDefinitions.get(null));
            this.indexDefinitions.remove(null);
        }
        return JsonUtils.getObjectMapper().writerWithDefaultPrettyPrinter().writeValueAsString(this);
    }

    public static HoodieIndexMetadata fromJson(String json) throws IOException {
        if (json == null || json.isEmpty()) {
            return new HoodieIndexMetadata();
        }
        return JsonUtils.getObjectMapper().readValue(json, HoodieIndexMetadata.class);
    }

    public String toString() {
        return new StringJoiner(", ", HoodieIndexMetadata.class.getSimpleName() + "[", "]").add("indexDefinitions=" + this.indexDefinitions).toString();
    }
}

