/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.model;

import io.hops.hudi.org.apache.avro.JsonProperties;
import io.hops.hudi.org.apache.avro.Schema;
import io.hops.hudi.org.apache.avro.generic.GenericRecord;
import io.hops.hudi.org.apache.avro.generic.IndexedRecord;
import java.io.IOException;
import java.util.Objects;
import org.apache.hudi.avro.HoodieAvroUtils;
import org.apache.hudi.common.model.BaseAvroPayload;
import org.apache.hudi.common.model.HoodieRecordPayload;
import org.apache.hudi.common.util.Option;

public class OverwriteWithLatestAvroPayload
extends BaseAvroPayload
implements HoodieRecordPayload<OverwriteWithLatestAvroPayload> {
    public OverwriteWithLatestAvroPayload(GenericRecord record, Comparable orderingVal) {
        super(record, orderingVal);
    }

    public OverwriteWithLatestAvroPayload(Option<GenericRecord> record) {
        this(record.isPresent() ? record.get() : null, Integer.valueOf(0));
    }

    @Override
    public OverwriteWithLatestAvroPayload preCombine(OverwriteWithLatestAvroPayload oldValue) {
        return this;
    }

    @Override
    public Option<IndexedRecord> combineAndGetUpdateValue(IndexedRecord currentValue, Schema schema) throws IOException {
        return this.getInsertValue(schema);
    }

    @Override
    public Option<IndexedRecord> getInsertValue(Schema schema) throws IOException {
        if (this.recordBytes.length == 0 || this.isDeletedRecord) {
            return Option.empty();
        }
        return Option.of(HoodieAvroUtils.bytesToAvro(this.recordBytes, schema));
    }

    public Boolean overwriteField(Object value, Object defaultValue) {
        if (JsonProperties.NULL_VALUE.equals(defaultValue)) {
            return value == null;
        }
        return Objects.equals(value, defaultValue);
    }

    @Override
    public Comparable<?> getOrderingValue() {
        return this.orderingVal;
    }

    @Override
    public byte[] getRecordBytes() {
        return this.recordBytes;
    }
}

