/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.table;

import io.hops.hudi.org.apache.avro.Schema;
import org.apache.hadoop.conf.Configuration;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.TableSchemaResolver;
import org.apache.parquet.avro.AvroSchemaConverter;
import org.apache.parquet.schema.MessageType;

public class ParquetTableSchemaResolver
extends TableSchemaResolver {
    public ParquetTableSchemaResolver(HoodieTableMetaClient metaClient) {
        super(metaClient);
    }

    public static MessageType convertAvroSchemaToParquet(Schema schema, Configuration hadoopConf) {
        AvroSchemaConverter avroSchemaConverter = new AvroSchemaConverter(hadoopConf);
        return avroSchemaConverter.convert(schema);
    }

    private Schema convertParquetSchemaToAvro(MessageType parquetSchema) {
        AvroSchemaConverter avroSchemaConverter = new AvroSchemaConverter(this.metaClient.getStorageConf().unwrapAs(Configuration.class));
        return avroSchemaConverter.convert(parquetSchema);
    }

    private MessageType convertAvroSchemaToParquet(Schema schema) {
        AvroSchemaConverter avroSchemaConverter = new AvroSchemaConverter(this.metaClient.getStorageConf().unwrapAs(Configuration.class));
        return avroSchemaConverter.convert(schema);
    }

    public MessageType getTableParquetSchema() throws Exception {
        return this.convertAvroSchemaToParquet(this.getTableAvroSchema(true));
    }

    public MessageType getTableParquetSchema(boolean includeMetadataField) throws Exception {
        return this.convertAvroSchemaToParquet(this.getTableAvroSchema(includeMetadataField));
    }
}

