/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.table.timeline.versioning.compaction;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.hudi.avro.model.HoodieCompactionOperation;
import org.apache.hudi.avro.model.HoodieCompactionPlan;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.timeline.versioning.AbstractMigratorBase;
import org.apache.hudi.common.util.ValidationUtils;
import org.apache.hudi.storage.StoragePath;

public class CompactionV2MigrationHandler
extends AbstractMigratorBase<HoodieCompactionPlan> {
    public static final Integer VERSION = 2;

    public CompactionV2MigrationHandler(HoodieTableMetaClient metaClient) {
        super(metaClient);
    }

    @Override
    public Integer getManagedVersion() {
        return VERSION;
    }

    @Override
    public HoodieCompactionPlan upgradeFrom(HoodieCompactionPlan input) {
        ValidationUtils.checkArgument(input.getVersion() == 1, "Input version is " + input.getVersion() + ". Must be 1");
        HoodieCompactionPlan compactionPlan = new HoodieCompactionPlan();
        List<HoodieCompactionOperation> v2CompactionOperationList = new ArrayList<HoodieCompactionOperation>();
        if (null != input.getOperations()) {
            v2CompactionOperationList = input.getOperations().stream().map(inp -> HoodieCompactionOperation.newBuilder().setBaseInstantTime(inp.getBaseInstantTime()).setFileId(inp.getFileId()).setPartitionPath(inp.getPartitionPath()).setMetrics(inp.getMetrics()).setDataFilePath(inp.getDataFilePath() == null ? null : new StoragePath(inp.getDataFilePath()).getName()).setDeltaFilePaths(inp.getDeltaFilePaths().stream().map(s -> new StoragePath((String)s).getName()).collect(Collectors.toList())).build()).collect(Collectors.toList());
        }
        compactionPlan.setOperations(v2CompactionOperationList);
        compactionPlan.setExtraMetadata(input.getExtraMetadata());
        compactionPlan.setVersion(this.getManagedVersion());
        return compactionPlan;
    }

    @Override
    public HoodieCompactionPlan downgradeFrom(HoodieCompactionPlan input) {
        throw new IllegalArgumentException("This is the current highest version. Input cannot be any higher version");
    }
}

