/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.util.queue;

import java.util.function.Function;
import org.apache.hudi.common.util.queue.HoodieMessageQueue;
import org.apache.hudi.common.util.queue.HoodieProducer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FunctionBasedQueueProducer<I>
implements HoodieProducer<I> {
    private static final Logger LOG = LoggerFactory.getLogger(FunctionBasedQueueProducer.class);
    private final Function<HoodieMessageQueue<I, ?>, Boolean> producerFunction;

    public FunctionBasedQueueProducer(Function<HoodieMessageQueue<I, ?>, Boolean> producerFunction) {
        this.producerFunction = producerFunction;
    }

    @Override
    public void produce(HoodieMessageQueue<I, ?> queue) {
        LOG.info("Starting to produce records into the queue");
        this.producerFunction.apply(queue);
        LOG.info("Finished producing records into the queue");
    }

    @Override
    public void close() {
    }
}

