/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.expression;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.hudi.expression.BinaryExpression;
import org.apache.hudi.expression.Comparators;
import org.apache.hudi.expression.Expression;
import org.apache.hudi.expression.ExpressionVisitor;
import org.apache.hudi.expression.LeafExpression;
import org.apache.hudi.expression.Predicate;
import org.apache.hudi.expression.StructLike;
import org.apache.hudi.internal.schema.Type;

public class Predicates {
    public static TrueExpression alwaysTrue() {
        return TrueExpression.get();
    }

    public static FalseExpression alwaysFalse() {
        return FalseExpression.get();
    }

    public static And and(Expression left, Expression right) {
        return new And(left, right);
    }

    public static Or or(Expression left, Expression right) {
        return new Or(left, right);
    }

    public static BinaryComparison gt(Expression left, Expression right) {
        return new BinaryComparison(left, Expression.Operator.GT, right);
    }

    public static BinaryComparison lt(Expression left, Expression right) {
        return new BinaryComparison(left, Expression.Operator.LT, right);
    }

    public static BinaryComparison eq(Expression left, Expression right) {
        return new BinaryComparison(left, Expression.Operator.EQ, right);
    }

    public static BinaryComparison gteq(Expression left, Expression right) {
        return new BinaryComparison(left, Expression.Operator.GT_EQ, right);
    }

    public static BinaryComparison lteq(Expression left, Expression right) {
        return new BinaryComparison(left, Expression.Operator.LT_EQ, right);
    }

    public static StringStartsWith startsWith(Expression left, Expression right) {
        return new StringStartsWith(left, right);
    }

    public static StringContains contains(Expression left, Expression right) {
        return new StringContains(left, right);
    }

    public static In in(Expression left, List<Expression> validExpressions) {
        return new In(left, validExpressions);
    }

    public static IsNull isNull(Expression child) {
        return new IsNull(child);
    }

    public static IsNotNull isNotNull(Expression child) {
        return new IsNotNull(child);
    }

    public static Not not(Expression expr) {
        return new Not(expr);
    }

    public static class BinaryComparison
    extends BinaryExpression
    implements Predicate {
        public BinaryComparison(Expression left, Expression.Operator operator, Expression right) {
            super(left, operator, right);
        }

        @Override
        public Boolean eval(StructLike data) {
            if (this.getLeft().getDataType().isNestedType()) {
                throw new IllegalArgumentException("The nested type doesn't support binary comparison");
            }
            Comparator<Object> comparator = Comparators.forType((Type.PrimitiveType)this.getLeft().getDataType());
            switch (this.getOperator()) {
                case EQ: {
                    return comparator.compare(this.getLeft().eval(data), this.getRight().eval(data)) == 0;
                }
                case GT: {
                    return comparator.compare(this.getLeft().eval(data), this.getRight().eval(data)) > 0;
                }
                case GT_EQ: {
                    return comparator.compare(this.getLeft().eval(data), this.getRight().eval(data)) >= 0;
                }
                case LT: {
                    return comparator.compare(this.getLeft().eval(data), this.getRight().eval(data)) < 0;
                }
                case LT_EQ: {
                    return comparator.compare(this.getLeft().eval(data), this.getRight().eval(data)) <= 0;
                }
            }
            throw new IllegalArgumentException("The operation " + (Object)((Object)this.getOperator()) + " doesn't support binary comparison");
        }
    }

    public static class Not
    implements Predicate {
        Expression child;

        public Not(Expression child) {
            this.child = child;
        }

        @Override
        public List<Expression> getChildren() {
            return Collections.singletonList(this.child);
        }

        @Override
        public Boolean eval(StructLike data) {
            return (Boolean)this.child.eval(data) == false;
        }

        @Override
        public Expression.Operator getOperator() {
            return Expression.Operator.NOT;
        }

        @Override
        public String toString() {
            return "NOT " + this.child;
        }
    }

    public static class IsNotNull
    implements Predicate {
        protected final Expression child;

        public IsNotNull(Expression child) {
            this.child = child;
        }

        @Override
        public List<Expression> getChildren() {
            return Collections.singletonList(this.child);
        }

        @Override
        public Boolean eval(StructLike data) {
            return this.child.eval(data) != null;
        }

        @Override
        public Expression.Operator getOperator() {
            return Expression.Operator.IS_NOT_NULL;
        }

        @Override
        public String toString() {
            return this.child.toString() + " IS NOT NULL";
        }
    }

    public static class IsNull
    implements Predicate {
        protected final Expression child;

        public IsNull(Expression child) {
            this.child = child;
        }

        @Override
        public List<Expression> getChildren() {
            return Collections.singletonList(this.child);
        }

        @Override
        public Boolean eval(StructLike data) {
            return this.child.eval(data) == null;
        }

        @Override
        public Expression.Operator getOperator() {
            return Expression.Operator.IS_NULL;
        }

        @Override
        public String toString() {
            return this.child.toString() + " IS NULL";
        }
    }

    public static class In
    implements Predicate {
        protected final Expression value;
        protected final List<Expression> validValues;

        public In(Expression value, List<Expression> validValues) {
            this.value = value;
            this.validValues = validValues;
        }

        @Override
        public List<Expression> getChildren() {
            ArrayList<Expression> children = new ArrayList<Expression>(this.validValues.size() + 1);
            children.add(this.value);
            children.addAll(this.validValues);
            return children;
        }

        @Override
        public Boolean eval(StructLike data) {
            Set values2 = this.validValues.stream().map(validValue -> validValue.eval(data)).collect(Collectors.toSet());
            return values2.contains(this.value.eval(data));
        }

        @Override
        public Expression.Operator getOperator() {
            return Expression.Operator.IN;
        }

        @Override
        public String toString() {
            return this.value.toString() + " " + this.getOperator().symbol + " " + this.validValues.stream().map(Expression::toString).collect(Collectors.joining(",", "(", ")"));
        }
    }

    public static class StringContains
    extends BinaryExpression
    implements Predicate {
        StringContains(Expression left, Expression right) {
            super(left, Expression.Operator.CONTAINS, right);
        }

        @Override
        public String toString() {
            return this.getLeft().toString() + ".contains(" + this.getRight().toString() + ")";
        }

        @Override
        public Object eval(StructLike data) {
            return this.getLeft().eval(data).toString().contains(this.getRight().eval(data).toString());
        }
    }

    public static class StringStartsWith
    extends BinaryExpression
    implements Predicate {
        StringStartsWith(Expression left, Expression right) {
            super(left, Expression.Operator.STARTS_WITH, right);
        }

        @Override
        public String toString() {
            return this.getLeft().toString() + ".startWith(" + this.getRight().toString() + ")";
        }

        @Override
        public Object eval(StructLike data) {
            return this.getLeft().eval(data).toString().startsWith(this.getRight().eval(data).toString());
        }
    }

    public static class Or
    extends BinaryExpression
    implements Predicate {
        public Or(Expression left, Expression right) {
            super(left, Expression.Operator.OR, right);
        }

        @Override
        public Boolean eval(StructLike data) {
            if (this.getLeft() instanceof TrueExpression || this.getRight() instanceof TrueExpression) {
                return true;
            }
            Object left = this.getLeft().eval(data);
            if (left == null) {
                return false;
            }
            if (((Boolean)left).booleanValue()) {
                return true;
            }
            Object right = this.getRight().eval(data);
            return right != null && (Boolean)right != false;
        }

        @Override
        public <T> T accept(ExpressionVisitor<T> exprVisitor) {
            return exprVisitor.visitOr(this);
        }

        @Override
        public String toString() {
            return "(" + this.getLeft() + " " + this.getOperator().symbol + " " + this.getRight() + ")";
        }
    }

    public static class And
    extends BinaryExpression
    implements Predicate {
        public And(Expression left, Expression right) {
            super(left, Expression.Operator.AND, right);
        }

        @Override
        public Boolean eval(StructLike data) {
            if (this.getLeft() instanceof FalseExpression || this.getRight() instanceof FalseExpression) {
                return false;
            }
            Object left = this.getLeft().eval(data);
            if (left != null && !((Boolean)left).booleanValue()) {
                return false;
            }
            Object right = this.getRight().eval(data);
            if (right != null && !((Boolean)right).booleanValue()) {
                return false;
            }
            return left != null && right != null;
        }

        @Override
        public <T> T accept(ExpressionVisitor<T> exprVisitor) {
            return exprVisitor.visitAnd(this);
        }

        @Override
        public String toString() {
            return "(" + this.getLeft() + " " + this.getOperator().symbol + " " + this.getRight() + ")";
        }
    }

    public static class FalseExpression
    extends LeafExpression
    implements Predicate {
        private static final FalseExpression INSTANCE = new FalseExpression();

        public static FalseExpression get() {
            return INSTANCE;
        }

        @Override
        public Boolean eval(StructLike data) {
            return false;
        }

        @Override
        public Expression.Operator getOperator() {
            return Expression.Operator.FALSE;
        }

        @Override
        public <T> T accept(ExpressionVisitor<T> exprVisitor) {
            return exprVisitor.alwaysFalse();
        }

        @Override
        public String toString() {
            return "FALSE";
        }
    }

    public static class TrueExpression
    extends LeafExpression
    implements Predicate {
        private static final TrueExpression INSTANCE = new TrueExpression();

        public static TrueExpression get() {
            return INSTANCE;
        }

        @Override
        public Boolean eval(StructLike data) {
            return true;
        }

        @Override
        public Expression.Operator getOperator() {
            return Expression.Operator.TRUE;
        }

        @Override
        public <T> T accept(ExpressionVisitor<T> exprVisitor) {
            return exprVisitor.alwaysTrue();
        }

        @Override
        public String toString() {
            return "TRUE";
        }
    }
}

