/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.io.hadoop;

import io.hops.hudi.org.apache.avro.generic.IndexedRecord;
import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.Path;
import org.apache.hudi.avro.HoodieAvroWriteSupport;
import org.apache.hudi.common.model.HoodieKey;
import org.apache.hudi.io.storage.HoodieAvroFileWriter;
import org.apache.hudi.io.storage.HoodieParquetConfig;
import org.apache.hudi.parquet.io.OutputStreamBackedOutputFile;
import org.apache.parquet.hadoop.ParquetFileWriter;
import org.apache.parquet.hadoop.ParquetWriter;
import org.apache.parquet.hadoop.api.WriteSupport;
import org.apache.parquet.io.OutputFile;

public class HoodieParquetStreamWriter
implements HoodieAvroFileWriter,
AutoCloseable {
    private final ParquetWriter<IndexedRecord> writer;
    private final HoodieAvroWriteSupport writeSupport;

    public HoodieParquetStreamWriter(FSDataOutputStream outputStream, HoodieParquetConfig<HoodieAvroWriteSupport> parquetConfig) throws IOException {
        this.writeSupport = parquetConfig.getWriteSupport();
        this.writer = ((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)new Builder(new OutputStreamBackedOutputFile(outputStream), (WriteSupport)this.writeSupport).withWriteMode(ParquetFileWriter.Mode.CREATE)).withCompressionCodec(parquetConfig.getCompressionCodecName())).withRowGroupSize(parquetConfig.getBlockSize())).withPageSize(parquetConfig.getPageSize())).withDictionaryPageSize(parquetConfig.getPageSize())).withDictionaryEncoding(parquetConfig.dictionaryEnabled())).withWriterVersion(ParquetWriter.DEFAULT_WRITER_VERSION)).withConf(parquetConfig.getStorageConf().unwrapAs(Configuration.class))).build();
    }

    @Override
    public boolean canWrite() {
        return true;
    }

    @Override
    public void writeAvro(String key, IndexedRecord record) throws IOException {
        this.writer.write((Object)record);
        this.writeSupport.add(key);
    }

    @Override
    public void writeAvroWithMetadata(HoodieKey key, IndexedRecord avroRecord) throws IOException {
        this.writeAvro(key.getRecordKey(), avroRecord);
    }

    @Override
    public void close() throws IOException {
        this.writer.close();
    }

    private static class Builder<T>
    extends ParquetWriter.Builder<T, Builder<T>> {
        private final WriteSupport<T> writeSupport;

        private Builder(Path file, WriteSupport<T> writeSupport) {
            super(file);
            this.writeSupport = writeSupport;
        }

        private Builder(OutputFile file, WriteSupport<T> writeSupport) {
            super(file);
            this.writeSupport = writeSupport;
        }

        protected Builder<T> self() {
            return this;
        }

        protected WriteSupport<T> getWriteSupport(Configuration conf) {
            return this.writeSupport;
        }
    }
}

