/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hudi.com.google.common.collect;

import io.hops.hudi.com.google.common.annotations.GwtCompatible;
import io.hops.hudi.com.google.common.annotations.GwtIncompatible;
import io.hops.hudi.com.google.common.collect.MapMaker;
import java.lang.reflect.Array;

@GwtCompatible(emulated=true)
class Platform {
    static <T> T[] clone(T[] array) {
        return (Object[])array.clone();
    }

    @GwtIncompatible(value="Array.newInstance(Class, int)")
    static <T> T[] newArray(Class<T> type, int length) {
        return (Object[])Array.newInstance(type, length);
    }

    static <T> T[] newArray(T[] reference, int length) {
        Class<?> type = reference.getClass().getComponentType();
        Object[] result = (Object[])Array.newInstance(type, length);
        return result;
    }

    static MapMaker tryWeakKeys(MapMaker mapMaker) {
        return mapMaker.weakKeys();
    }

    private Platform() {
    }
}

