/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hudi.org.apache.avro.file;

import io.hops.hudi.org.apache.avro.file.Codec;
import io.hops.hudi.org.apache.avro.file.CodecFactory;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import org.apache.commons.compress.compressors.bzip2.BZip2CompressorInputStream;
import org.apache.commons.compress.compressors.bzip2.BZip2CompressorOutputStream;

public class BZip2Codec
extends Codec {
    public static final int DEFAULT_BUFFER_SIZE = 65536;
    private ByteArrayOutputStream outputBuffer;

    @Override
    public String getName() {
        return "bzip2";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ByteBuffer compress(ByteBuffer uncompressedData) throws IOException {
        ByteArrayOutputStream baos = this.getOutputBuffer(uncompressedData.remaining());
        BZip2CompressorOutputStream outputStream = new BZip2CompressorOutputStream((OutputStream)baos);
        try {
            outputStream.write(uncompressedData.array(), uncompressedData.position(), uncompressedData.remaining());
        }
        finally {
            outputStream.close();
        }
        ByteBuffer result = ByteBuffer.wrap(baos.toByteArray());
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ByteBuffer decompress(ByteBuffer compressedData) throws IOException {
        ByteArrayInputStream bais = new ByteArrayInputStream(compressedData.array());
        BZip2CompressorInputStream inputStream = new BZip2CompressorInputStream((InputStream)bais);
        try {
            ByteBuffer result;
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            byte[] buffer = new byte[65536];
            int readCount = -1;
            while ((readCount = inputStream.read(buffer, compressedData.position(), buffer.length)) > 0) {
                baos.write(buffer, 0, readCount);
            }
            ByteBuffer byteBuffer = result = ByteBuffer.wrap(baos.toByteArray());
            return byteBuffer;
        }
        finally {
            inputStream.close();
        }
    }

    @Override
    public int hashCode() {
        return this.getName().hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        return this.getClass() == obj.getClass();
    }

    private ByteArrayOutputStream getOutputBuffer(int suggestedLength) {
        if (null == this.outputBuffer) {
            this.outputBuffer = new ByteArrayOutputStream(suggestedLength);
        }
        this.outputBuffer.reset();
        return this.outputBuffer;
    }

    static class Option
    extends CodecFactory {
        Option() {
        }

        @Override
        protected Codec createInstance() {
            return new BZip2Codec();
        }
    }
}

