/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hudi.org.apache.avro.specific;

import io.hops.hudi.org.apache.avro.Conversion;
import io.hops.hudi.org.apache.avro.LogicalType;
import io.hops.hudi.org.apache.avro.Schema;
import io.hops.hudi.org.apache.avro.generic.GenericDatumWriter;
import io.hops.hudi.org.apache.avro.io.Encoder;
import io.hops.hudi.org.apache.avro.specific.SpecificData;
import io.hops.hudi.org.apache.avro.specific.SpecificRecordBase;
import java.io.IOException;

public class SpecificDatumWriter<T>
extends GenericDatumWriter<T> {
    public SpecificDatumWriter() {
        super(SpecificData.get());
    }

    public SpecificDatumWriter(Class<T> c) {
        super(SpecificData.get().getSchema(c), SpecificData.get());
    }

    public SpecificDatumWriter(Schema schema) {
        super(schema, SpecificData.get());
    }

    public SpecificDatumWriter(Schema root, SpecificData specificData) {
        super(root, specificData);
    }

    protected SpecificDatumWriter(SpecificData specificData) {
        super(specificData);
    }

    public SpecificData getSpecificData() {
        return (SpecificData)this.getData();
    }

    @Override
    protected void writeEnum(Schema schema, Object datum, Encoder out) throws IOException {
        if (!(datum instanceof Enum)) {
            super.writeEnum(schema, datum, out);
        } else {
            out.writeEnum(((Enum)datum).ordinal());
        }
    }

    @Override
    protected void writeString(Schema schema, Object datum, Encoder out) throws IOException {
        if (!(datum instanceof CharSequence) && this.getSpecificData().isStringable(datum.getClass())) {
            datum = datum.toString();
        }
        this.writeString(datum, out);
    }

    @Override
    protected void writeField(Object datum, Schema.Field f, Encoder out, Object state) throws IOException {
        if (datum instanceof SpecificRecordBase) {
            Conversion<?> conversion = ((SpecificRecordBase)datum).getConversion(f.pos());
            Schema fieldSchema = f.schema();
            LogicalType logicalType = fieldSchema.getLogicalType();
            Object value = this.getData().getField(datum, f.name(), f.pos());
            if (conversion != null && logicalType != null) {
                value = this.convert(fieldSchema, logicalType, conversion, value);
            }
            this.writeWithoutConversion(fieldSchema, value, out);
        } else {
            super.writeField(datum, f, out, state);
        }
    }
}

