/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hudi.org.apache.hadoop.hbase;

import io.hops.hudi.org.apache.hadoop.hbase.util.DNS;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.hadoop.fs.StorageType;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class HDFSBlocksDistribution {
    private Map<String, HostAndWeight> hostAndWeights = new TreeMap<String, HostAndWeight>();
    private long uniqueBlocksTotalWeight = 0L;

    public synchronized String toString() {
        return "number of unique hosts in the distribution=" + this.hostAndWeights.size();
    }

    public void addHostsAndBlockWeight(String[] hosts, long weight) {
        this.addHostsAndBlockWeight(hosts, weight, null);
    }

    public void addHostsAndBlockWeight(String[] hosts, long weight, StorageType[] storageTypes) {
        if (hosts == null || hosts.length == 0) {
            return;
        }
        this.addUniqueWeight(weight);
        if (storageTypes != null && storageTypes.length == hosts.length) {
            for (int i = 0; i < hosts.length; ++i) {
                long weightForSsd = 0L;
                if (storageTypes[i] == StorageType.SSD) {
                    weightForSsd = weight;
                }
                this.addHostAndBlockWeight(hosts[i], weight, weightForSsd);
            }
        } else {
            for (String hostname : hosts) {
                this.addHostAndBlockWeight(hostname, weight, 0L);
            }
        }
    }

    private void addUniqueWeight(long weight) {
        this.uniqueBlocksTotalWeight += weight;
    }

    private void addHostAndBlockWeight(String host, long weight, long weightForSsd) {
        if (host == null) {
            return;
        }
        HostAndWeight hostAndWeight = this.hostAndWeights.get(host);
        if (hostAndWeight == null) {
            hostAndWeight = new HostAndWeight(host, weight, weightForSsd);
            this.hostAndWeights.put(host, hostAndWeight);
        } else {
            hostAndWeight.addWeight(weight, weightForSsd);
        }
    }

    public Map<String, HostAndWeight> getHostAndWeights() {
        return this.hostAndWeights;
    }

    public long getWeight(String host) {
        HostAndWeight hostAndWeight;
        long weight = 0L;
        if (host != null && (hostAndWeight = this.hostAndWeights.get(host)) != null) {
            weight = hostAndWeight.getWeight();
        }
        return weight;
    }

    public long getUniqueBlocksTotalWeight() {
        return this.uniqueBlocksTotalWeight;
    }

    public float getBlockLocalityIndex(String host) {
        if (this.uniqueBlocksTotalWeight == 0L) {
            return 0.0f;
        }
        return (float)this.getBlocksLocalityWeightInternal(host, HostAndWeight::getWeight) / (float)this.uniqueBlocksTotalWeight;
    }

    public float getBlockLocalityIndexForSsd(String host) {
        if (this.uniqueBlocksTotalWeight == 0L) {
            return 0.0f;
        }
        return (float)this.getBlocksLocalityWeightInternal(host, HostAndWeight::getWeightForSsd) / (float)this.uniqueBlocksTotalWeight;
    }

    public long getBlocksLocalWeight(String host) {
        return this.getBlocksLocalityWeightInternal(host, HostAndWeight::getWeight);
    }

    public long getBlocksLocalWithSsdWeight(String host) {
        return this.getBlocksLocalityWeightInternal(host, HostAndWeight::getWeightForSsd);
    }

    private long getBlocksLocalityWeightInternal(String host, Visitor visitor) {
        long localityIndex = 0L;
        HostAndWeight hostAndWeight = this.hostAndWeights.get(host);
        if (hostAndWeight == null) {
            String currentHost = "";
            try {
                currentHost = DNS.getDefaultHost("default", "default");
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (host.equals(currentHost)) {
                hostAndWeight = this.hostAndWeights.get("localhost");
            }
        }
        if (hostAndWeight != null && this.uniqueBlocksTotalWeight != 0L) {
            localityIndex = visitor.visit(hostAndWeight);
        }
        return localityIndex;
    }

    public void add(HDFSBlocksDistribution otherBlocksDistribution) {
        Map<String, HostAndWeight> otherHostAndWeights = otherBlocksDistribution.getHostAndWeights();
        for (Map.Entry<String, HostAndWeight> otherHostAndWeight : otherHostAndWeights.entrySet()) {
            this.addHostAndBlockWeight(otherHostAndWeight.getValue().host, otherHostAndWeight.getValue().weight, otherHostAndWeight.getValue().weightForSsd);
        }
        this.addUniqueWeight(otherBlocksDistribution.getUniqueBlocksTotalWeight());
    }

    public List<String> getTopHosts() {
        HostAndWeight[] hostAndWeights = this.getTopHostsWithWeights();
        ArrayList<String> topHosts = new ArrayList<String>(hostAndWeights.length);
        for (HostAndWeight haw : hostAndWeights) {
            topHosts.add(haw.getHost());
        }
        return topHosts;
    }

    public HostAndWeight[] getTopHostsWithWeights() {
        TreeSet<HostAndWeight> orderedHosts = new TreeSet<HostAndWeight>(new HostAndWeight.WeightComparator());
        orderedHosts.addAll(this.hostAndWeights.values());
        return orderedHosts.descendingSet().toArray(new HostAndWeight[orderedHosts.size()]);
    }

    public static interface Visitor {
        public long visit(HostAndWeight var1);
    }

    public static class HostAndWeight {
        private final String host;
        private long weight;
        private long weightForSsd;

        public HostAndWeight(String host, long weight, long weightForSsd) {
            this.host = host;
            this.weight = weight;
            this.weightForSsd = weightForSsd;
        }

        public void addWeight(long weight, long weightForSsd) {
            this.weight += weight;
            this.weightForSsd += weightForSsd;
        }

        public String getHost() {
            return this.host;
        }

        public long getWeight() {
            return this.weight;
        }

        public long getWeightForSsd() {
            return this.weightForSsd;
        }

        public static class WeightComparator
        implements Comparator<HostAndWeight> {
            @Override
            public int compare(HostAndWeight l, HostAndWeight r) {
                if (l.getWeight() == r.getWeight()) {
                    return l.getHost().compareTo(r.getHost());
                }
                return l.getWeight() < r.getWeight() ? -1 : 1;
            }
        }
    }
}

