/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hudi.org.apache.hadoop.hbase.client;

import io.hops.hudi.org.apache.hadoop.hbase.CellScannable;
import io.hops.hudi.org.apache.hadoop.hbase.CellUtil;
import io.hops.hudi.org.apache.hadoop.hbase.DoNotRetryIOException;
import io.hops.hudi.org.apache.hadoop.hbase.HRegionInfo;
import io.hops.hudi.org.apache.hadoop.hbase.HRegionLocation;
import io.hops.hudi.org.apache.hadoop.hbase.ServerName;
import io.hops.hudi.org.apache.hadoop.hbase.TableName;
import io.hops.hudi.org.apache.hadoop.hbase.client.Action;
import io.hops.hudi.org.apache.hadoop.hbase.client.CancellableRegionServerCallable;
import io.hops.hudi.org.apache.hadoop.hbase.client.ClusterConnection;
import io.hops.hudi.org.apache.hadoop.hbase.client.MultiAction;
import io.hops.hudi.org.apache.hadoop.hbase.client.MultiResponse;
import io.hops.hudi.org.apache.hadoop.hbase.client.RetryingTimeTracker;
import io.hops.hudi.org.apache.hadoop.hbase.shaded.protobuf.RequestConverter;
import io.hops.hudi.org.apache.hadoop.hbase.shaded.protobuf.ResponseConverter;
import io.hops.hudi.org.apache.hadoop.hbase.shaded.protobuf.generated.ClientProtos;
import io.hops.hudi.org.apache.hbase.thirdparty.com.google.protobuf.RpcController;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
class MultiServerCallable
extends CancellableRegionServerCallable<MultiResponse> {
    private MultiAction multiAction;
    private boolean cellBlock;

    MultiServerCallable(ClusterConnection connection, TableName tableName, ServerName location, MultiAction multi, RpcController rpcController, int rpcTimeout, RetryingTimeTracker tracker, int priority) {
        super(connection, tableName, null, rpcController, rpcTimeout, tracker, priority);
        this.multiAction = multi;
        this.location = new HRegionLocation(null, location);
        this.cellBlock = this.isCellBlock();
    }

    public void reset(ServerName location, MultiAction multiAction) {
        this.location = new HRegionLocation(null, location);
        this.multiAction = multiAction;
        this.cellBlock = this.isCellBlock();
    }

    @Override
    protected HRegionLocation getLocation() {
        throw new RuntimeException("Cannot get region location for multi-region request");
    }

    @Override
    public HRegionInfo getHRegionInfo() {
        throw new RuntimeException("Cannot get region info for multi-region request");
    }

    MultiAction getMulti() {
        return this.multiAction;
    }

    @Override
    protected MultiResponse rpcCall() throws Exception {
        int countOfActions = this.multiAction.size();
        if (countOfActions <= 0) {
            throw new DoNotRetryIOException("No Actions");
        }
        ClientProtos.MultiRequest.Builder multiRequestBuilder = ClientProtos.MultiRequest.newBuilder();
        ClientProtos.RegionAction.Builder regionActionBuilder = ClientProtos.RegionAction.newBuilder();
        ClientProtos.Action.Builder actionBuilder = ClientProtos.Action.newBuilder();
        ClientProtos.MutationProto.Builder mutationBuilder = ClientProtos.MutationProto.newBuilder();
        ArrayList<CellScannable> cells = this.cellBlock ? new ArrayList<CellScannable>(countOfActions) : null;
        long nonceGroup = this.multiAction.getNonceGroup();
        HashMap<Integer, Integer> indexMap = new HashMap<Integer, Integer>();
        for (Map.Entry<byte[], List<Action>> e : this.multiAction.actions.entrySet()) {
            byte[] regionName = e.getKey();
            List<Action> actions = e.getValue();
            if (this.cellBlock) {
                RequestConverter.buildNoDataRegionActions(regionName, actions, cells, multiRequestBuilder, regionActionBuilder, actionBuilder, mutationBuilder, nonceGroup, indexMap);
                continue;
            }
            RequestConverter.buildRegionActions(regionName, actions, multiRequestBuilder, regionActionBuilder, actionBuilder, mutationBuilder, nonceGroup, indexMap);
        }
        if (cells != null) {
            this.setRpcControllerCellScanner(CellUtil.createCellScanner(cells));
        }
        ClientProtos.MultiRequest requestProto = multiRequestBuilder.build();
        ClientProtos.MultiResponse responseProto = ((ClientProtos.ClientService.BlockingInterface)this.getStub()).multi(this.getRpcController(), requestProto);
        if (responseProto == null) {
            return null;
        }
        return ResponseConverter.getResults(requestProto, indexMap, responseProto, this.getRpcControllerCellScanner());
    }

    private boolean isCellBlock() {
        ClusterConnection conn = this.getConnection();
        return conn.hasCellBlockSupport();
    }

    @Override
    public void prepare(boolean reload) throws IOException {
        this.setStub(this.getConnection().getClient(this.location.getServerName()));
    }

    ServerName getServerName() {
        return this.location.getServerName();
    }
}

