/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hudi.org.apache.hadoop.hbase.client;

import io.hops.hudi.com.google.protobuf.Descriptors;
import io.hops.hudi.com.google.protobuf.Message;
import io.hops.hudi.org.apache.hadoop.hbase.TableName;
import io.hops.hudi.org.apache.hadoop.hbase.client.ClientServiceCallable;
import io.hops.hudi.org.apache.hadoop.hbase.client.ClusterConnection;
import io.hops.hudi.org.apache.hadoop.hbase.client.Connection;
import io.hops.hudi.org.apache.hadoop.hbase.client.RpcRetryingCallerFactory;
import io.hops.hudi.org.apache.hadoop.hbase.client.SyncCoprocessorRpcChannel;
import io.hops.hudi.org.apache.hadoop.hbase.ipc.CoprocessorRpcUtils;
import io.hops.hudi.org.apache.hadoop.hbase.shaded.protobuf.generated.ClientProtos;
import io.hops.hudi.org.apache.hbase.thirdparty.com.google.protobuf.RpcController;
import java.io.IOException;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
class RegionCoprocessorRpcChannel
extends SyncCoprocessorRpcChannel {
    private static final Logger LOG = LoggerFactory.getLogger(RegionCoprocessorRpcChannel.class);
    private final TableName table;
    private final byte[] row;
    private final ClusterConnection conn;
    private byte[] lastRegion;
    private final int operationTimeout;
    private final RpcRetryingCallerFactory rpcCallerFactory;

    RegionCoprocessorRpcChannel(ClusterConnection conn, TableName table, byte[] row) {
        this.table = table;
        this.row = row;
        this.conn = conn;
        this.operationTimeout = conn.getConnectionConfiguration().getOperationTimeout();
        this.rpcCallerFactory = conn.getRpcRetryingCallerFactory();
    }

    @Override
    protected Message callExecService(io.hops.hudi.com.google.protobuf.RpcController controller, final Descriptors.MethodDescriptor method, final Message request, Message responsePrototype) throws IOException {
        if (LOG.isTraceEnabled()) {
            LOG.trace("Call: " + method.getName() + ", " + request.toString());
        }
        if (this.row == null) {
            throw new NullPointerException("Can't be null!");
        }
        ClientServiceCallable<ClientProtos.CoprocessorServiceResponse> callable = new ClientServiceCallable<ClientProtos.CoprocessorServiceResponse>((Connection)this.conn, this.table, this.row, (RpcController)this.conn.getRpcControllerFactory().newController(), -1){

            @Override
            protected ClientProtos.CoprocessorServiceResponse rpcCall() throws Exception {
                byte[] regionName = this.getLocation().getRegionInfo().getRegionName();
                ClientProtos.CoprocessorServiceRequest csr = CoprocessorRpcUtils.getCoprocessorServiceRequest(method, request, RegionCoprocessorRpcChannel.this.row, regionName);
                return ((ClientProtos.ClientService.BlockingInterface)this.getStub()).execService(this.getRpcController(), csr);
            }
        };
        ClientProtos.CoprocessorServiceResponse result = this.rpcCallerFactory.newCaller().callWithRetries(callable, this.operationTimeout);
        this.lastRegion = result.getRegion().getValue().toByteArray();
        return CoprocessorRpcUtils.getResponse(result, responsePrototype);
    }

    public byte[] getLastRegion() {
        return this.lastRegion;
    }
}

