/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hudi.org.apache.hadoop.hbase.filter;

import io.hops.hudi.org.apache.hadoop.hbase.Cell;
import io.hops.hudi.org.apache.hadoop.hbase.CellComparator;
import io.hops.hudi.org.apache.hadoop.hbase.exceptions.DeserializationException;
import io.hops.hudi.org.apache.hadoop.hbase.filter.Filter;
import io.hops.hudi.org.apache.hadoop.hbase.filter.FilterBase;
import io.hops.hudi.org.apache.hadoop.hbase.filter.ParseFilter;
import io.hops.hudi.org.apache.hadoop.hbase.shaded.protobuf.generated.FilterProtos;
import io.hops.hudi.org.apache.hadoop.hbase.util.Bytes;
import io.hops.hudi.org.apache.hbase.thirdparty.com.google.common.base.Preconditions;
import io.hops.hudi.org.apache.hbase.thirdparty.com.google.protobuf.InvalidProtocolBufferException;
import io.hops.hudi.org.apache.hbase.thirdparty.com.google.protobuf.UnsafeByteOperations;
import java.util.ArrayList;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Public
public class InclusiveStopFilter
extends FilterBase {
    private byte[] stopRowKey;
    private boolean done = false;

    public InclusiveStopFilter(byte[] stopRowKey) {
        this.stopRowKey = stopRowKey;
    }

    public byte[] getStopRowKey() {
        return this.stopRowKey;
    }

    @Override
    @Deprecated
    public Filter.ReturnCode filterKeyValue(Cell c) {
        return this.filterCell(c);
    }

    @Override
    public Filter.ReturnCode filterCell(Cell c) {
        if (this.done) {
            return Filter.ReturnCode.NEXT_ROW;
        }
        return Filter.ReturnCode.INCLUDE;
    }

    @Override
    public boolean filterRowKey(Cell firstRowCell) {
        if (this.filterAllRemaining()) {
            return true;
        }
        int cmp = CellComparator.getInstance().compareRows(firstRowCell, this.stopRowKey, 0, this.stopRowKey.length);
        this.done = this.reversed ? cmp < 0 : cmp > 0;
        return this.done;
    }

    @Override
    public boolean filterAllRemaining() {
        return this.done;
    }

    public static Filter createFilterFromArguments(ArrayList<byte[]> filterArguments) {
        Preconditions.checkArgument(filterArguments.size() == 1, "Expected 1 but got: %s", filterArguments.size());
        byte[] stopRowKey = ParseFilter.removeQuotesFromByteArray(filterArguments.get(0));
        return new InclusiveStopFilter(stopRowKey);
    }

    @Override
    public byte[] toByteArray() {
        FilterProtos.InclusiveStopFilter.Builder builder = FilterProtos.InclusiveStopFilter.newBuilder();
        if (this.stopRowKey != null) {
            builder.setStopRowKey(UnsafeByteOperations.unsafeWrap(this.stopRowKey));
        }
        return builder.build().toByteArray();
    }

    public static InclusiveStopFilter parseFrom(byte[] pbBytes) throws DeserializationException {
        FilterProtos.InclusiveStopFilter proto;
        try {
            proto = FilterProtos.InclusiveStopFilter.parseFrom(pbBytes);
        }
        catch (InvalidProtocolBufferException e) {
            throw new DeserializationException(e);
        }
        return new InclusiveStopFilter(proto.hasStopRowKey() ? proto.getStopRowKey().toByteArray() : null);
    }

    @Override
    boolean areSerializedFieldsEqual(Filter o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof InclusiveStopFilter)) {
            return false;
        }
        InclusiveStopFilter other = (InclusiveStopFilter)o;
        return Bytes.equals(this.getStopRowKey(), other.getStopRowKey());
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + " " + Bytes.toStringBinary(this.stopRowKey);
    }

    public boolean equals(Object obj) {
        return obj instanceof Filter && this.areSerializedFieldsEqual((Filter)obj);
    }

    public int hashCode() {
        return Bytes.hashCode(this.stopRowKey);
    }
}

