/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hudi.org.apache.hadoop.hbase.io.crypto.aes;

import io.hops.hudi.org.apache.hadoop.hbase.io.crypto.Cipher;
import io.hops.hudi.org.apache.hadoop.hbase.io.crypto.CipherProvider;
import io.hops.hudi.org.apache.hadoop.hbase.io.crypto.Context;
import io.hops.hudi.org.apache.hadoop.hbase.io.crypto.Decryptor;
import io.hops.hudi.org.apache.hadoop.hbase.io.crypto.Encryptor;
import io.hops.hudi.org.apache.hadoop.hbase.io.crypto.aes.AESDecryptor;
import io.hops.hudi.org.apache.hadoop.hbase.io.crypto.aes.AESEncryptor;
import io.hops.hudi.org.apache.hbase.thirdparty.com.google.common.base.Preconditions;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.SecureRandom;
import javax.crypto.spec.SecretKeySpec;
import org.apache.yetus.audience.InterfaceAudience;
import org.apache.yetus.audience.InterfaceStability;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public class AES
extends Cipher {
    private static final Logger LOG = LoggerFactory.getLogger(AES.class);
    public static final String CIPHER_MODE_KEY = "hbase.crypto.algorithm.aes.mode";
    public static final String CIPHER_PROVIDER_KEY = "hbase.crypto.algorithm.aes.provider";
    private final String rngAlgorithm;
    private final String cipherMode;
    private final String cipherProvider;
    private SecureRandom rng;

    public AES(CipherProvider provider) {
        super(provider);
        this.cipherMode = provider.getConf().get(CIPHER_MODE_KEY, "AES/CTR/NoPadding");
        this.cipherProvider = provider.getConf().get(CIPHER_PROVIDER_KEY);
        this.rngAlgorithm = provider.getConf().get("hbase.crypto.algorithm.rng", "SHA1PRNG");
        String rngProvider = provider.getConf().get("hbase.crypto.algorithm.rng.provider");
        try {
            this.rng = rngProvider != null ? SecureRandom.getInstance(this.rngAlgorithm, rngProvider) : SecureRandom.getInstance(this.rngAlgorithm);
        }
        catch (GeneralSecurityException e) {
            LOG.warn("Could not instantiate specified RNG, falling back to default", (Throwable)e);
            this.rng = new SecureRandom();
        }
    }

    @Override
    public String getName() {
        return "AES";
    }

    @Override
    public int getKeyLength() {
        return 16;
    }

    @Override
    public int getIvLength() {
        return 16;
    }

    @Override
    public Key getRandomKey() {
        byte[] keyBytes = new byte[this.getKeyLength()];
        this.rng.nextBytes(keyBytes);
        return new SecretKeySpec(keyBytes, this.getName());
    }

    @Override
    public Encryptor getEncryptor() {
        return new AESEncryptor(this.getJCECipherInstance(), this.rng);
    }

    @Override
    public Decryptor getDecryptor() {
        return new AESDecryptor(this.getJCECipherInstance());
    }

    @Override
    public OutputStream createEncryptionStream(OutputStream out, Context context, byte[] iv) throws IOException {
        Preconditions.checkNotNull(context);
        Preconditions.checkState(context.getKey() != null, "Context does not have a key");
        Preconditions.checkNotNull(iv);
        Encryptor e = this.getEncryptor();
        e.setKey(context.getKey());
        e.setIv(iv);
        return e.createEncryptionStream(out);
    }

    @Override
    public OutputStream createEncryptionStream(OutputStream out, Encryptor e) throws IOException {
        Preconditions.checkNotNull(e);
        return e.createEncryptionStream(out);
    }

    @Override
    public InputStream createDecryptionStream(InputStream in, Context context, byte[] iv) throws IOException {
        Preconditions.checkNotNull(context);
        Preconditions.checkState(context.getKey() != null, "Context does not have a key");
        Preconditions.checkNotNull(iv);
        Decryptor d = this.getDecryptor();
        d.setKey(context.getKey());
        d.setIv(iv);
        return d.createDecryptionStream(in);
    }

    @Override
    public InputStream createDecryptionStream(InputStream in, Decryptor d) throws IOException {
        Preconditions.checkNotNull(d);
        return d.createDecryptionStream(in);
    }

    SecureRandom getRNG() {
        return this.rng;
    }

    private javax.crypto.Cipher getJCECipherInstance() {
        try {
            if (this.cipherProvider != null) {
                return javax.crypto.Cipher.getInstance(this.cipherMode, this.cipherProvider);
            }
            return javax.crypto.Cipher.getInstance(this.cipherMode);
        }
        catch (GeneralSecurityException e) {
            throw new RuntimeException(e);
        }
    }
}

