/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hudi.org.apache.hadoop.hbase.io.encoding;

import io.hops.hudi.org.apache.hadoop.hbase.Cell;
import io.hops.hudi.org.apache.hadoop.hbase.KeyValue;
import io.hops.hudi.org.apache.hadoop.hbase.KeyValueUtil;
import io.hops.hudi.org.apache.hadoop.hbase.io.ByteArrayOutputStream;
import io.hops.hudi.org.apache.hadoop.hbase.io.encoding.AbstractDataBlockEncoder;
import io.hops.hudi.org.apache.hadoop.hbase.io.encoding.DataBlockEncoder;
import io.hops.hudi.org.apache.hadoop.hbase.io.encoding.EncodingState;
import io.hops.hudi.org.apache.hadoop.hbase.io.encoding.HFileBlockDecodingContext;
import io.hops.hudi.org.apache.hadoop.hbase.io.encoding.HFileBlockDefaultEncodingContext;
import io.hops.hudi.org.apache.hadoop.hbase.io.encoding.HFileBlockEncodingContext;
import io.hops.hudi.org.apache.hadoop.hbase.io.encoding.RowIndexEncoderV1;
import io.hops.hudi.org.apache.hadoop.hbase.io.encoding.RowIndexSeekerV1;
import io.hops.hudi.org.apache.hadoop.hbase.nio.ByteBuff;
import io.hops.hudi.org.apache.hadoop.hbase.nio.SingleByteBuff;
import io.hops.hudi.org.apache.hadoop.hbase.util.ByteBufferUtils;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import org.apache.hadoop.io.WritableUtils;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class RowIndexCodecV1
extends AbstractDataBlockEncoder {
    @Override
    public void startBlockEncoding(HFileBlockEncodingContext blkEncodingCtx, DataOutputStream out) throws IOException {
        if (blkEncodingCtx.getClass() != HFileBlockDefaultEncodingContext.class) {
            throw new IOException(this.getClass().getName() + " only accepts " + HFileBlockDefaultEncodingContext.class.getName() + " as the encoding context.");
        }
        HFileBlockDefaultEncodingContext encodingCtx = (HFileBlockDefaultEncodingContext)blkEncodingCtx;
        encodingCtx.prepareEncoding(out);
        RowIndexEncoderV1 encoder = new RowIndexEncoderV1(out, encodingCtx);
        RowIndexEncodingState state = new RowIndexEncodingState();
        state.encoder = encoder;
        blkEncodingCtx.setEncodingState(state);
    }

    @Override
    public void encode(Cell cell, HFileBlockEncodingContext encodingCtx, DataOutputStream out) throws IOException {
        RowIndexEncodingState state = (RowIndexEncodingState)encodingCtx.getEncodingState();
        RowIndexEncoderV1 encoder = state.encoder;
        encoder.write(cell);
    }

    @Override
    public void endBlockEncoding(HFileBlockEncodingContext encodingCtx, DataOutputStream out, byte[] uncompressedBytesWithHeader) throws IOException {
        RowIndexEncodingState state = (RowIndexEncodingState)encodingCtx.getEncodingState();
        RowIndexEncoderV1 encoder = state.encoder;
        encoder.flush();
        this.postEncoding(encodingCtx);
    }

    @Override
    public ByteBuffer decodeKeyValues(DataInputStream source, HFileBlockDecodingContext decodingCtx) throws IOException {
        ByteBuffer sourceAsBuffer = ByteBufferUtils.drainInputStreamToBuffer(source);
        sourceAsBuffer.mark();
        if (!decodingCtx.getHFileContext().isIncludesTags()) {
            sourceAsBuffer.position(sourceAsBuffer.limit() - 4);
            int onDiskSize = sourceAsBuffer.getInt();
            sourceAsBuffer.reset();
            ByteBuffer dup = sourceAsBuffer.duplicate();
            dup.position(sourceAsBuffer.position());
            dup.limit(sourceAsBuffer.position() + onDiskSize);
            return dup.slice();
        }
        RowIndexSeekerV1 seeker = new RowIndexSeekerV1(decodingCtx);
        seeker.setCurrentBuffer(new SingleByteBuff(sourceAsBuffer));
        ArrayList<Cell> kvs = new ArrayList<Cell>();
        kvs.add(seeker.getCell());
        while (seeker.next()) {
            kvs.add(seeker.getCell());
        }
        boolean includesMvcc = decodingCtx.getHFileContext().isIncludesMvcc();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream out = new DataOutputStream(baos);
        for (Cell cell : kvs) {
            KeyValue currentCell = KeyValueUtil.copyToNewKeyValue(cell);
            out.write(currentCell.getBuffer(), currentCell.getOffset(), currentCell.getLength());
            if (!includesMvcc) continue;
            WritableUtils.writeVLong((DataOutput)out, (long)cell.getSequenceId());
        }
        out.flush();
        return ByteBuffer.wrap(baos.getBuffer(), 0, baos.size());
    }

    @Override
    public Cell getFirstKeyCellInBlock(ByteBuff block) {
        block.mark();
        int keyLength = block.getInt();
        block.getInt();
        ByteBuffer key = block.asSubByteBuffer(keyLength).duplicate();
        block.reset();
        return this.createFirstKeyCell(key, keyLength);
    }

    @Override
    public DataBlockEncoder.EncodedSeeker createSeeker(HFileBlockDecodingContext decodingCtx) {
        return new RowIndexSeekerV1(decodingCtx);
    }

    private static class RowIndexEncodingState
    extends EncodingState {
        RowIndexEncoderV1 encoder = null;

        private RowIndexEncodingState() {
        }

        @Override
        public void beforeShipped() {
            if (this.encoder != null) {
                this.encoder.beforeShipped();
            }
        }
    }
}

