/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hudi.org.apache.hadoop.hbase.master.janitor;

import io.hops.hudi.org.apache.hadoop.hbase.HBaseIOException;
import io.hops.hudi.org.apache.hadoop.hbase.HConstants;
import io.hops.hudi.org.apache.hadoop.hbase.MetaTableAccessor;
import io.hops.hudi.org.apache.hadoop.hbase.TableName;
import io.hops.hudi.org.apache.hadoop.hbase.client.RegionInfo;
import io.hops.hudi.org.apache.hadoop.hbase.client.RegionInfoBuilder;
import io.hops.hudi.org.apache.hadoop.hbase.client.RegionReplicaUtil;
import io.hops.hudi.org.apache.hadoop.hbase.client.TableDescriptor;
import io.hops.hudi.org.apache.hadoop.hbase.exceptions.MergeRegionException;
import io.hops.hudi.org.apache.hadoop.hbase.master.MasterServices;
import io.hops.hudi.org.apache.hadoop.hbase.master.assignment.TransitRegionStateProcedure;
import io.hops.hudi.org.apache.hadoop.hbase.master.janitor.Report;
import io.hops.hudi.org.apache.hadoop.hbase.procedure2.Procedure;
import io.hops.hudi.org.apache.hadoop.hbase.replication.ReplicationException;
import io.hops.hudi.org.apache.hadoop.hbase.util.Bytes;
import io.hops.hudi.org.apache.hadoop.hbase.util.Pair;
import io.hops.hudi.org.apache.hadoop.hbase.util.ServerRegionReplicaUtil;
import io.hops.hudi.org.apache.hbase.thirdparty.com.google.common.collect.ArrayListMultimap;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class MetaFixer {
    private static final Logger LOG = LoggerFactory.getLogger(MetaFixer.class);
    private static final String MAX_MERGE_COUNT_KEY = "hbase.master.metafixer.max.merge.count";
    private static final int MAX_MERGE_COUNT_DEFAULT = 64;
    private final MasterServices masterServices;
    private final int maxMergeCount;

    public MetaFixer(MasterServices masterServices) {
        this.masterServices = masterServices;
        this.maxMergeCount = this.masterServices.getConfiguration().getInt(MAX_MERGE_COUNT_KEY, 64);
    }

    public void fix() throws IOException {
        Report report = this.masterServices.getCatalogJanitor().getLastReport();
        if (report == null) {
            LOG.info("CatalogJanitor has not generated a report yet; run 'catalogjanitor_run' in shell or wait until CatalogJanitor chore runs.");
            return;
        }
        this.fixHoles(report);
        this.fixOverlaps(report);
        this.masterServices.runReplicationBarrierCleaner();
    }

    void fixHoles(Report report) {
        List<Pair<RegionInfo, RegionInfo>> holes = report.getHoles();
        if (holes.isEmpty()) {
            LOG.info("CatalogJanitor Report contains no holes to fix. Skipping.");
            return;
        }
        LOG.info("Identified {} region holes to fix. Detailed fixup progress logged at DEBUG.", (Object)holes.size());
        List<RegionInfo> newRegionInfos = MetaFixer.createRegionInfosForHoles(holes);
        List<RegionInfo> newMetaEntries = MetaFixer.createMetaEntries(this.masterServices, newRegionInfos);
        TransitRegionStateProcedure[] assignProcedures = this.masterServices.getAssignmentManager().createRoundRobinAssignProcedures(newMetaEntries);
        this.masterServices.getMasterProcedureExecutor().submitProcedures((Procedure[])assignProcedures);
        LOG.info("Scheduled {}/{} new regions for assignment.", (Object)assignProcedures.length, (Object)holes.size());
    }

    private static List<RegionInfo> createRegionInfosForHoles(List<Pair<RegionInfo, RegionInfo>> holes) {
        List<RegionInfo> newRegionInfos = holes.stream().map(MetaFixer::getHoleCover).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
        LOG.debug("Constructed {}/{} RegionInfo descriptors corresponding to identified holes.", (Object)newRegionInfos.size(), (Object)holes.size());
        return newRegionInfos;
    }

    private static Optional<RegionInfo> getHoleCover(Pair<RegionInfo, RegionInfo> hole) {
        RegionInfo left = hole.getFirst();
        RegionInfo right = hole.getSecond();
        if (left.getTable().equals(right.getTable())) {
            if (Bytes.compareTo(left.getEndKey(), right.getStartKey()) >= 0) {
                LOG.warn("Skipping hole fix; left-side endKey is not less than right-side startKey; left=<{}>, right=<{}>", (Object)left, (Object)right);
                return Optional.empty();
            }
            return Optional.of(MetaFixer.buildRegionInfo(left.getTable(), left.getEndKey(), right.getStartKey()));
        }
        boolean leftUndefined = left.equals(RegionInfoBuilder.UNDEFINED);
        boolean rightUndefined = right.equals(RegionInfoBuilder.UNDEFINED);
        boolean last = left.isLast();
        boolean first = right.isFirst();
        if (leftUndefined && rightUndefined) {
            LOG.warn("Skipping hole fix; both the hole left-side and right-side RegionInfos are UNDEFINED; left=<{}>, right=<{}>", (Object)left, (Object)right);
            return Optional.empty();
        }
        if (leftUndefined || last) {
            return Optional.of(MetaFixer.buildRegionInfo(right.getTable(), HConstants.EMPTY_START_ROW, right.getStartKey()));
        }
        if (rightUndefined || first) {
            return Optional.of(MetaFixer.buildRegionInfo(left.getTable(), left.getEndKey(), HConstants.EMPTY_END_ROW));
        }
        LOG.warn("Skipping hole fix; don't know what to do with left=<{}>, right=<{}>", (Object)left, (Object)right);
        return Optional.empty();
    }

    private static RegionInfo buildRegionInfo(TableName tn, byte[] start, byte[] end) {
        return RegionInfoBuilder.newBuilder(tn).setStartKey(start).setEndKey(end).build();
    }

    private static List<RegionInfo> createMetaEntries(MasterServices masterServices, List<RegionInfo> newRegionInfos) {
        List addMetaEntriesResults = newRegionInfos.stream().map(regionInfo -> {
            try {
                TableDescriptor td = masterServices.getTableDescriptors().get(regionInfo.getTable());
                List<RegionInfo> newRegions = RegionReplicaUtil.addReplicas(Collections.singletonList(regionInfo), 1, td.getRegionReplication());
                MetaTableAccessor.addRegionsToMeta(masterServices.getConnection(), newRegions, td.getRegionReplication());
                if (td.getRegionReplication() > 1) {
                    ServerRegionReplicaUtil.setupRegionReplicaReplication(masterServices);
                }
                return Either.ofLeft(newRegions);
            }
            catch (IOException e) {
                return Either.ofRight(e);
            }
            catch (ReplicationException e) {
                return Either.ofRight(new HBaseIOException(e));
            }
        }).collect(Collectors.toList());
        List<RegionInfo> createMetaEntriesSuccesses = addMetaEntriesResults.stream().filter(Either::hasLeft).map(Either::getLeft).flatMap(Collection::stream).collect(Collectors.toList());
        List<IOException> createMetaEntriesFailures = addMetaEntriesResults.stream().filter(Either::hasRight).map(Either::getRight).collect(Collectors.toList());
        LOG.debug("Added {}/{} entries to hbase:meta", (Object)createMetaEntriesSuccesses.size(), (Object)newRegionInfos.size());
        if (!createMetaEntriesFailures.isEmpty()) {
            LOG.warn("Failed to create entries in hbase:meta for {}/{} RegionInfo descriptors. First failure message included; full list of failures with accompanying stack traces is available at log level DEBUG. message={}", new Object[]{createMetaEntriesFailures.size(), addMetaEntriesResults.size(), ((IOException)createMetaEntriesFailures.get(0)).getMessage()});
            if (LOG.isDebugEnabled()) {
                createMetaEntriesFailures.forEach(ioe -> LOG.debug("Attempt to fix region hole in hbase:meta failed.", (Throwable)ioe));
            }
        }
        return createMetaEntriesSuccesses;
    }

    List<Long> fixOverlaps(Report report) throws IOException {
        ArrayList<Long> pidList = new ArrayList<Long>();
        for (Set set : MetaFixer.calculateMerges(this.maxMergeCount, report.getOverlaps())) {
            RegionInfo[] regionsArray = set.toArray(new RegionInfo[0]);
            try {
                pidList.add(this.masterServices.mergeRegions(regionsArray, true, 0L, 0L));
            }
            catch (MergeRegionException mre) {
                LOG.warn("Failed overlap fix of {}", (Object)regionsArray, (Object)mre);
            }
        }
        return pidList;
    }

    static List<SortedSet<RegionInfo>> calculateMerges(int maxMergeCount, List<Pair<RegionInfo, RegionInfo>> overlaps) {
        if (overlaps.isEmpty()) {
            LOG.debug("No overlaps.");
            return Collections.emptyList();
        }
        ArrayList<SortedSet<RegionInfo>> merges = new ArrayList<SortedSet<RegionInfo>>();
        ArrayListMultimap<TableName, Pair<RegionInfo, RegionInfo>> overlapGroups = ArrayListMultimap.create();
        for (Pair<RegionInfo, RegionInfo> pair : overlaps) {
            overlapGroups.put(pair.getFirst().getTable(), pair);
        }
        for (Map.Entry entry : overlapGroups.asMap().entrySet()) {
            MetaFixer.calculateTableMerges(maxMergeCount, merges, (Collection)entry.getValue());
        }
        return merges;
    }

    private static void calculateTableMerges(int maxMergeCount, List<SortedSet<RegionInfo>> merges, Collection<Pair<RegionInfo, RegionInfo>> overlaps) {
        TreeSet<RegionInfo> currentMergeSet = new TreeSet<RegionInfo>();
        HashSet<RegionInfo> regionsInMergeSet = new HashSet<RegionInfo>();
        RegionInfo regionInfoWithlargestEndKey = null;
        for (Pair<RegionInfo, RegionInfo> pair : overlaps) {
            if (!(regionInfoWithlargestEndKey == null || MetaFixer.isOverlap(regionInfoWithlargestEndKey, pair) && currentMergeSet.size() < maxMergeCount)) {
                if (currentMergeSet.size() >= maxMergeCount) {
                    LOG.warn("Ran into maximum-at-a-time merges limit={}", (Object)maxMergeCount);
                }
                if (currentMergeSet.size() <= 1) {
                    for (RegionInfo ri : currentMergeSet) {
                        regionsInMergeSet.remove(ri);
                    }
                    currentMergeSet.clear();
                } else {
                    merges.add(currentMergeSet);
                    currentMergeSet = new TreeSet();
                }
            }
            if (!regionsInMergeSet.contains(pair.getFirst())) {
                currentMergeSet.add(pair.getFirst());
                regionsInMergeSet.add(pair.getFirst());
            }
            if (!regionsInMergeSet.contains(pair.getSecond())) {
                currentMergeSet.add(pair.getSecond());
                regionsInMergeSet.add(pair.getSecond());
            }
            regionInfoWithlargestEndKey = MetaFixer.getRegionInfoWithLargestEndKey(MetaFixer.getRegionInfoWithLargestEndKey(pair.getFirst(), pair.getSecond()), regionInfoWithlargestEndKey);
        }
        merges.add(currentMergeSet);
    }

    static RegionInfo getRegionInfoWithLargestEndKey(RegionInfo a, RegionInfo b) {
        if (a == null) {
            return b;
        }
        if (b == null) {
            return a;
        }
        if (!a.getTable().equals(b.getTable())) {
            return b;
        }
        if (a.isLast()) {
            return a;
        }
        if (b.isLast()) {
            return b;
        }
        int compare = Bytes.compareTo(a.getEndKey(), b.getEndKey());
        return compare == 0 || compare > 0 ? a : b;
    }

    static boolean isOverlap(RegionInfo ri, Pair<RegionInfo, RegionInfo> pair) {
        if (ri == null || pair == null) {
            return false;
        }
        return ri.isOverlap(pair.getFirst()) || ri.isOverlap(pair.getSecond());
    }

    private static class Either<L, R> {
        private final L left;
        private final R right;

        public static <L, R> Either<L, R> ofLeft(L left) {
            return new Either<L, Object>(left, null);
        }

        public static <L, R> Either<L, R> ofRight(R right) {
            return new Either<Object, R>(null, right);
        }

        Either(L left, R right) {
            this.left = left;
            this.right = right;
        }

        public boolean hasLeft() {
            return this.left != null;
        }

        public L getLeft() {
            if (!this.hasLeft()) {
                throw new IllegalStateException("Either contains no left.");
            }
            return this.left;
        }

        public boolean hasRight() {
            return this.right != null;
        }

        public R getRight() {
            if (!this.hasRight()) {
                throw new IllegalStateException("Either contains no right.");
            }
            return this.right;
        }
    }
}

