/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hudi.org.apache.hadoop.hbase.namequeues;

import com.lmax.disruptor.BlockingWaitStrategy;
import com.lmax.disruptor.EventHandler;
import com.lmax.disruptor.ExceptionHandler;
import com.lmax.disruptor.RingBuffer;
import com.lmax.disruptor.WaitStrategy;
import com.lmax.disruptor.dsl.Disruptor;
import com.lmax.disruptor.dsl.ProducerType;
import io.hops.hudi.org.apache.hadoop.hbase.namequeues.DisruptorExceptionHandler;
import io.hops.hudi.org.apache.hadoop.hbase.namequeues.LogEventHandler;
import io.hops.hudi.org.apache.hadoop.hbase.namequeues.NamedQueuePayload;
import io.hops.hudi.org.apache.hadoop.hbase.namequeues.RingBufferEnvelope;
import io.hops.hudi.org.apache.hadoop.hbase.namequeues.request.NamedQueueGetRequest;
import io.hops.hudi.org.apache.hadoop.hbase.namequeues.response.NamedQueueGetResponse;
import io.hops.hudi.org.apache.hadoop.hbase.util.Threads;
import io.hops.hudi.org.apache.hbase.thirdparty.com.google.common.base.Preconditions;
import io.hops.hudi.org.apache.hbase.thirdparty.com.google.common.util.concurrent.ThreadFactoryBuilder;
import org.apache.hadoop.conf.Configuration;
import org.apache.yetus.audience.InterfaceAudience;
import org.apache.yetus.audience.InterfaceStability;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public class NamedQueueRecorder {
    private final Disruptor<RingBufferEnvelope> disruptor;
    private final LogEventHandler logEventHandler;
    private static NamedQueueRecorder namedQueueRecorder;
    private static boolean isInit;
    private static final Object LOCK;

    private NamedQueueRecorder(Configuration conf) {
        String hostingThreadName = Thread.currentThread().getName();
        int eventCount = conf.getInt("hbase.namedqueue.ringbuffer.size", 1024);
        this.disruptor = new Disruptor(RingBufferEnvelope::new, this.getEventCount(eventCount), new ThreadFactoryBuilder().setNameFormat(hostingThreadName + ".slowlog.append-pool-%d").setDaemon(true).setUncaughtExceptionHandler(Threads.LOGGING_EXCEPTION_HANDLER).build(), ProducerType.MULTI, (WaitStrategy)new BlockingWaitStrategy());
        this.disruptor.setDefaultExceptionHandler((ExceptionHandler)new DisruptorExceptionHandler());
        this.logEventHandler = new LogEventHandler(conf);
        this.disruptor.handleEventsWith((EventHandler[])new LogEventHandler[]{this.logEventHandler});
        this.disruptor.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static NamedQueueRecorder getInstance(Configuration conf) {
        if (namedQueueRecorder != null) {
            return namedQueueRecorder;
        }
        Object object = LOCK;
        synchronized (object) {
            if (!isInit) {
                namedQueueRecorder = new NamedQueueRecorder(conf);
                isInit = true;
            }
        }
        return namedQueueRecorder;
    }

    private int getEventCount(int eventCount) {
        Preconditions.checkArgument(eventCount >= 0, "hbase.namedqueue.ringbuffer.size must be > 0");
        int floor = Integer.highestOneBit(eventCount);
        if (floor == eventCount) {
            return floor;
        }
        if (floor >= 0x20000000) {
            return 0x40000000;
        }
        return floor << 1;
    }

    public NamedQueueGetResponse getNamedQueueRecords(NamedQueueGetRequest request) {
        return this.logEventHandler.getNamedQueueRecords(request);
    }

    public boolean clearNamedQueue(NamedQueuePayload.NamedQueueEvent namedQueueEvent) {
        return this.logEventHandler.clearNamedQueue(namedQueueEvent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addRecord(NamedQueuePayload namedQueuePayload) {
        RingBuffer ringBuffer = this.disruptor.getRingBuffer();
        long seqId = ringBuffer.next();
        try {
            ((RingBufferEnvelope)ringBuffer.get(seqId)).load(namedQueuePayload);
        }
        finally {
            ringBuffer.publish(seqId);
        }
    }

    public void persistAll(NamedQueuePayload.NamedQueueEvent namedQueueEvent) {
        if (this.logEventHandler != null) {
            this.logEventHandler.persistAll(namedQueueEvent);
        }
    }

    static {
        isInit = false;
        LOCK = new Object();
    }
}

