/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hudi.org.apache.hadoop.hbase.replication;

import io.hops.hudi.org.apache.hadoop.hbase.Abortable;
import io.hops.hudi.org.apache.hadoop.hbase.TableDescriptors;
import io.hops.hudi.org.apache.hadoop.hbase.replication.ReplicationPeer;
import io.hops.hudi.org.apache.hadoop.hbase.replication.ReplicationPeerConfig;
import io.hops.hudi.org.apache.hadoop.hbase.replication.ReplicationPeerConfigListener;
import io.hops.hudi.org.apache.hadoop.hbase.replication.WALEntryFilter;
import io.hops.hudi.org.apache.hadoop.hbase.replication.regionserver.MetricsSource;
import io.hops.hudi.org.apache.hadoop.hbase.wal.WAL;
import java.io.IOException;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.LimitedPrivate(value={"Replication"})
public interface ReplicationEndpoint
extends ReplicationPeerConfigListener {
    public void init(Context var1) throws IOException;

    public boolean canReplicateToSameCluster();

    public UUID getPeerUUID();

    public WALEntryFilter getWALEntryfilter();

    public boolean replicate(ReplicateContext var1);

    public boolean isRunning();

    public boolean isStarting();

    public void start();

    public void awaitRunning();

    public void awaitRunning(long var1, TimeUnit var3) throws TimeoutException;

    public void stop();

    public void awaitTerminated();

    public void awaitTerminated(long var1, TimeUnit var3) throws TimeoutException;

    public Throwable failureCause();

    @InterfaceAudience.LimitedPrivate(value={"Replication"})
    public static class ReplicateContext {
        List<WAL.Entry> entries;
        int size;
        String walGroupId;
        int timeout;

        @InterfaceAudience.Private
        public ReplicateContext() {
        }

        public ReplicateContext setEntries(List<WAL.Entry> entries) {
            this.entries = entries;
            return this;
        }

        public ReplicateContext setSize(int size) {
            this.size = size;
            return this;
        }

        public ReplicateContext setWalGroupId(String walGroupId) {
            this.walGroupId = walGroupId;
            return this;
        }

        public List<WAL.Entry> getEntries() {
            return this.entries;
        }

        public int getSize() {
            return this.size;
        }

        public String getWalGroupId() {
            return this.walGroupId;
        }

        public void setTimeout(int timeout) {
            this.timeout = timeout;
        }

        public int getTimeout() {
            return this.timeout;
        }
    }

    @InterfaceAudience.LimitedPrivate(value={"Replication"})
    public static class Context {
        private final Configuration localConf;
        private final Configuration conf;
        private final FileSystem fs;
        private final TableDescriptors tableDescriptors;
        private final ReplicationPeer replicationPeer;
        private final String peerId;
        private final UUID clusterId;
        private final MetricsSource metrics;
        private final Abortable abortable;

        @InterfaceAudience.Private
        public Context(Configuration localConf, Configuration conf, FileSystem fs, String peerId, UUID clusterId, ReplicationPeer replicationPeer, MetricsSource metrics, TableDescriptors tableDescriptors, Abortable abortable) {
            this.localConf = localConf;
            this.conf = conf;
            this.fs = fs;
            this.clusterId = clusterId;
            this.peerId = peerId;
            this.replicationPeer = replicationPeer;
            this.metrics = metrics;
            this.tableDescriptors = tableDescriptors;
            this.abortable = abortable;
        }

        public Configuration getConfiguration() {
            return this.conf;
        }

        public Configuration getLocalConfiguration() {
            return this.localConf;
        }

        public FileSystem getFilesystem() {
            return this.fs;
        }

        public UUID getClusterId() {
            return this.clusterId;
        }

        public String getPeerId() {
            return this.peerId;
        }

        public ReplicationPeerConfig getPeerConfig() {
            return this.replicationPeer.getPeerConfig();
        }

        public ReplicationPeer getReplicationPeer() {
            return this.replicationPeer;
        }

        public MetricsSource getMetrics() {
            return this.metrics;
        }

        public TableDescriptors getTableDescriptors() {
            return this.tableDescriptors;
        }

        public Abortable getAbortable() {
            return this.abortable;
        }
    }
}

