/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hudi.org.apache.hadoop.hbase.wal;

import io.hops.hudi.org.apache.hadoop.hbase.io.asyncfs.FanOutOneBlockAsyncDFSOutput;
import io.hops.hudi.org.apache.hadoop.hbase.io.asyncfs.FanOutOneBlockAsyncDFSOutputHelper;
import io.hops.hudi.org.apache.hadoop.hbase.io.asyncfs.FanOutOneBlockAsyncDFSOutputSaslHelper;
import io.hops.hudi.org.apache.hadoop.hbase.regionserver.wal.AsyncFSWAL;
import io.hops.hudi.org.apache.hadoop.hbase.regionserver.wal.AsyncProtobufLogWriter;
import io.hops.hudi.org.apache.hadoop.hbase.regionserver.wal.WALUtil;
import io.hops.hudi.org.apache.hadoop.hbase.util.CommonFSUtils;
import io.hops.hudi.org.apache.hadoop.hbase.util.Pair;
import io.hops.hudi.org.apache.hadoop.hbase.wal.AbstractFSWALProvider;
import io.hops.hudi.org.apache.hadoop.hbase.wal.NettyAsyncFSWALConfigHelper;
import io.hops.hudi.org.apache.hadoop.hbase.wal.WALProvider;
import io.hops.hudi.org.apache.hbase.thirdparty.com.google.common.base.Throwables;
import io.hops.hudi.org.apache.hbase.thirdparty.io.netty.channel.Channel;
import io.hops.hudi.org.apache.hbase.thirdparty.io.netty.channel.EventLoopGroup;
import io.hops.hudi.org.apache.hbase.thirdparty.io.netty.channel.nio.NioEventLoopGroup;
import io.hops.hudi.org.apache.hbase.thirdparty.io.netty.channel.socket.nio.NioSocketChannel;
import io.hops.hudi.org.apache.hbase.thirdparty.io.netty.util.concurrent.DefaultThreadFactory;
import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.yetus.audience.InterfaceAudience;
import org.apache.yetus.audience.InterfaceStability;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public class AsyncFSWALProvider
extends AbstractFSWALProvider<AsyncFSWAL> {
    private static final Logger LOG = LoggerFactory.getLogger(AsyncFSWALProvider.class);
    public static final String WRITER_IMPL = "hbase.regionserver.hlog.async.writer.impl";
    private EventLoopGroup eventLoopGroup;
    private Class<? extends Channel> channelClass;

    @Override
    protected AsyncFSWAL createWAL() throws IOException {
        return new AsyncFSWAL(CommonFSUtils.getWALFileSystem(this.conf), this.abortable, CommonFSUtils.getWALRootDir(this.conf), AsyncFSWALProvider.getWALDirectoryName(this.factory.factoryId), AsyncFSWALProvider.getWALArchiveDirectoryName(this.conf, this.factory.factoryId), this.conf, this.listeners, true, this.logPrefix, ".meta".equals(this.providerId) ? ".meta" : null, this.eventLoopGroup, this.channelClass);
    }

    @Override
    protected void doInit(Configuration conf) throws IOException {
        Pair<EventLoopGroup, Class<? extends Channel>> eventLoopGroupAndChannelClass = NettyAsyncFSWALConfigHelper.getEventLoopConfig(conf);
        if (eventLoopGroupAndChannelClass != null) {
            this.eventLoopGroup = eventLoopGroupAndChannelClass.getFirst();
            this.channelClass = eventLoopGroupAndChannelClass.getSecond();
        } else {
            this.eventLoopGroup = new NioEventLoopGroup(1, new DefaultThreadFactory("AsyncFSWAL", true, 10));
            this.channelClass = NioSocketChannel.class;
        }
    }

    public static AsyncWriter createAsyncWriter(Configuration conf, FileSystem fs, Path path, boolean overwritable, EventLoopGroup eventLoopGroup, Class<? extends Channel> channelClass) throws IOException {
        return AsyncFSWALProvider.createAsyncWriter(conf, fs, path, overwritable, WALUtil.getWALBlockSize(conf, fs, path), eventLoopGroup, channelClass);
    }

    public static AsyncWriter createAsyncWriter(Configuration conf, FileSystem fs, Path path, boolean overwritable, long blocksize, EventLoopGroup eventLoopGroup, Class<? extends Channel> channelClass) throws IOException {
        Class logWriterClass = conf.getClass(WRITER_IMPL, AsyncProtobufLogWriter.class, AsyncWriter.class);
        try {
            AsyncWriter writer = (AsyncWriter)logWriterClass.getConstructor(EventLoopGroup.class, Class.class).newInstance(eventLoopGroup, channelClass);
            writer.init(fs, path, conf, overwritable, blocksize);
            return writer;
        }
        catch (Exception e) {
            if (e instanceof CommonFSUtils.StreamLacksCapabilityException) {
                LOG.error("The RegionServer async write ahead log provider relies on the ability to call " + e.getMessage() + " for proper operation during component failures, but the current FileSystem does not support doing so. Please check the config value of '" + "hbase.wal.dir" + "' and ensure it points to a FileSystem mount that has suitable capabilities for output streams.");
            } else {
                LOG.debug("Error instantiating log writer.", (Throwable)e);
            }
            Throwables.propagateIfPossible(e, IOException.class);
            throw new IOException("cannot get log writer", e);
        }
    }

    public static boolean load() {
        try {
            Class.forName(FanOutOneBlockAsyncDFSOutput.class.getName());
            Class.forName(FanOutOneBlockAsyncDFSOutputHelper.class.getName());
            Class.forName(FanOutOneBlockAsyncDFSOutputSaslHelper.class.getName());
            return true;
        }
        catch (Throwable e) {
            return false;
        }
    }

    public static interface AsyncWriter
    extends WALProvider.AsyncWriter {
        public void init(FileSystem var1, Path var2, Configuration var3, boolean var4, long var5) throws IOException, CommonFSUtils.StreamLacksCapabilityException;
    }
}

